/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.cram.common.IntHashMap;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.DataSeries;
import htsjdk.samtools.cram.encoding.DataSeriesMap;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.encoding.reader.DataReader;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.ReadTag;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;

public class DataReaderFactory {
    private boolean collectStats = false;

    public AbstractReader buildReader(AbstractReader abstractReader, BitInputStream bitInputStream, Map<Integer, InputStream> map, CompressionHeader compressionHeader, int n) throws IllegalArgumentException, IllegalAccessException {
        abstractReader.captureReadNames = compressionHeader.readNamesIncluded;
        abstractReader.refId = n;
        abstractReader.AP_delta = compressionHeader.AP_seriesDelta;
        for (Field field : abstractReader.getClass().getFields()) {
            Object object;
            Object object2;
            Annotation annotation;
            if (field.isAnnotationPresent(DataSeries.class)) {
                annotation = field.getAnnotation(DataSeries.class);
                object2 = annotation.key();
                object = annotation.type();
                if (compressionHeader.eMap.get(object2) == null) {
                    System.err.println("Encoding not found for key: " + (Object)object2);
                }
                field.set(abstractReader, this.createReader((DataSeriesType)((Object)object), compressionHeader.eMap.get(object2), bitInputStream, map));
            }
            if (!field.isAnnotationPresent(DataSeriesMap.class) || !"TAG".equals(object2 = (annotation = field.getAnnotation(DataSeriesMap.class)).name())) continue;
            object = new IntHashMap();
            for (Integer n2 : compressionHeader.tMap.keySet()) {
                EncodingParams encodingParams = compressionHeader.tMap.get(n2);
                DataReader dataReader = this.createReader(DataSeriesType.BYTE_ARRAY, encodingParams, bitInputStream, map);
                ((IntHashMap)object).put(n2, dataReader);
            }
            field.set(abstractReader, object);
        }
        abstractReader.tagIdDictionary = compressionHeader.dictionary;
        return abstractReader;
    }

    private <T> DataReader<T> createReader(DataSeriesType dataSeriesType, EncodingParams encodingParams, BitInputStream bitInputStream, Map<Integer, InputStream> map) {
        if (encodingParams.id == EncodingID.NULL) {
            return this.collectStats ? new DataReaderWithStats<T>(DataReaderFactory.buildNullReader(dataSeriesType)) : DataReaderFactory.buildNullReader(dataSeriesType);
        }
        EncodingFactory encodingFactory = new EncodingFactory();
        Encoding encoding = encodingFactory.createEncoding(dataSeriesType, encodingParams.id);
        if (encoding == null) {
            throw new RuntimeException("Encoding not found for value type " + dataSeriesType.name() + ", id=" + (Object)((Object)encodingParams.id));
        }
        encoding.fromByteArray(encodingParams.params);
        return this.collectStats ? new DataReaderWithStats(new DefaultDataReader(encoding.buildCodec(map, null), bitInputStream)) : new DefaultDataReader(encoding.buildCodec(map, null), bitInputStream);
    }

    private static <T> DataReader<T> buildNullReader(DataSeriesType dataSeriesType) {
        switch (dataSeriesType) {
            case BYTE: {
                return new SingleValueReader<Byte>(new Byte(0));
            }
            case INT: {
                return new SingleValueReader<Integer>(new Integer(0));
            }
            case LONG: {
                return new SingleValueReader<Long>(new Long(0L));
            }
            case BYTE_ARRAY: {
                return new SingleValueReader<byte[]>(new byte[0]);
            }
        }
        throw new RuntimeException("Unknown data type: " + dataSeriesType.name());
    }

    public Map<String, DataReaderWithStats> getStats(CramRecordReader cramRecordReader) throws IllegalArgumentException, IllegalAccessException {
        TreeMap<String, DataReaderWithStats> treeMap = new TreeMap<String, DataReaderWithStats>();
        if (!this.collectStats) {
            return treeMap;
        }
        for (Field field : cramRecordReader.getClass().getFields()) {
            Object object;
            Object object2;
            Annotation annotation;
            if (field.isAnnotationPresent(DataSeries.class)) {
                annotation = field.getAnnotation(DataSeries.class);
                object2 = annotation.key();
                object = annotation.type();
                treeMap.put(((Enum)object2).name(), (DataReaderWithStats)field.get(cramRecordReader));
            }
            if (!field.isAnnotationPresent(DataSeriesMap.class) || !"TAG".equals(object2 = (annotation = field.getAnnotation(DataSeriesMap.class)).name())) continue;
            object = (Map)field.get(cramRecordReader);
            for (Integer n : object.keySet()) {
                String string = ReadTag.intToNameType4Bytes(n);
                treeMap.put(string, (DataReaderWithStats)object.get(n));
            }
        }
        return treeMap;
    }

    public static class DataReaderWithStats<T>
    implements DataReader<T> {
        public long nanos = 0L;
        DataReader<T> delegate;

        public DataReaderWithStats(DataReader<T> dataReader) {
            this.delegate = dataReader;
        }

        @Override
        public T readData() throws IOException {
            long l = System.nanoTime();
            T t = this.delegate.readData();
            this.nanos += System.nanoTime() - l;
            return t;
        }

        @Override
        public T readDataArray(int n) throws IOException {
            long l = System.nanoTime();
            T t = this.delegate.readDataArray(n);
            this.nanos += System.nanoTime() - l;
            return t;
        }

        @Override
        public void skip() throws IOException {
            long l = System.nanoTime();
            this.delegate.skip();
            this.nanos += System.nanoTime() - l;
        }

        @Override
        public void readByteArrayInto(byte[] byArray, int n, int n2) throws IOException {
            long l = System.nanoTime();
            this.delegate.readByteArrayInto(byArray, n, n2);
            this.nanos += System.nanoTime() - l;
        }
    }

    private static class SingleValueReader<T>
    implements DataReader<T> {
        private T value;
        private Byte byteValue;

        public SingleValueReader(T t) {
            this.value = t;
            this.byteValue = t instanceof Byte ? (Byte)t : null;
        }

        @Override
        public T readData() throws IOException {
            return this.value;
        }

        @Override
        public T readDataArray(int n) {
            return this.value;
        }

        @Override
        public void skip() throws IOException {
        }

        @Override
        public void readByteArrayInto(byte[] byArray, int n, int n2) throws IOException {
            if (this.byteValue != null) {
                for (int i = 0; i < n2; ++i) {
                    byArray[i + n] = this.byteValue;
                }
            } else {
                throw new RuntimeException("Not a byte reader.");
            }
        }
    }

    private static class DefaultDataReader<T>
    implements DataReader<T> {
        private BitCodec<T> codec;
        private BitInputStream bis;

        public DefaultDataReader(BitCodec<T> bitCodec, BitInputStream bitInputStream) {
            this.codec = bitCodec;
            this.bis = bitInputStream;
        }

        @Override
        public T readData() throws IOException {
            return this.codec.read(this.bis);
        }

        @Override
        public T readDataArray(int n) throws IOException {
            return this.codec.read(this.bis, n);
        }

        @Override
        public void skip() throws IOException {
            this.codec.read(this.bis);
        }

        @Override
        public void readByteArrayInto(byte[] byArray, int n, int n2) throws IOException {
            this.codec.readInto(this.bis, byArray, n, n2);
        }
    }
}

