/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.index;

import htsjdk.samtools.CRAMIndexer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

class BaiIndexer {
    private static Log log = Log.getInstance(BaiIndexer.class);
    public CountingInputStream is;
    public SAMFileHeader samFileHeader;
    public CRAMIndexer indexer;

    public BaiIndexer(InputStream inputStream, SAMFileHeader sAMFileHeader, File file) {
        this.is = new CountingInputStream(inputStream);
        this.samFileHeader = sAMFileHeader;
        this.indexer = new CRAMIndexer(file, sAMFileHeader);
    }

    public BaiIndexer(InputStream inputStream, File file) throws IOException {
        this.is = new CountingInputStream(inputStream);
        CramHeader cramHeader = CramIO.readCramHeader(this.is);
        this.samFileHeader = cramHeader.getSamFileHeader();
        this.indexer = new CRAMIndexer(file, this.samFileHeader);
    }

    private boolean nextContainer() throws IOException {
        long l = this.is.getCount();
        Container container = CramIO.readContainer(this.is);
        if (container == null) {
            return false;
        }
        container.offset = l;
        int n = 0;
        for (Slice slice : container.slices) {
            slice.containerOffset = l;
            slice.index = n++;
            this.indexer.processAlignment(slice);
        }
        log.info("INDEXED: " + container.toString());
        return true;
    }

    private void index() throws IOException {
        while (this.nextContainer()) {
        }
    }

    public void run() throws IOException {
        this.index();
        this.indexer.finish();
    }
}

