/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.index;

import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.Slice;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;

public class CramIndex {
    private OutputStream os;
    private static Comparator<Entry> byEnd = new Comparator<Entry>(){

        @Override
        public int compare(Entry entry, Entry entry2) {
            if (entry.sequenceId != entry2.sequenceId) {
                return entry2.sequenceId - entry.sequenceId;
            }
            if (entry.alignmentStart + entry.alignmentSpan != entry2.alignmentStart + entry2.alignmentSpan) {
                return entry.alignmentStart + entry.alignmentSpan - entry2.alignmentStart - entry2.alignmentSpan;
            }
            return (int)(entry.containerStartOffset - entry2.containerStartOffset);
        }
    };
    private static Comparator<Entry> byStart = new Comparator<Entry>(){

        @Override
        public int compare(Entry entry, Entry entry2) {
            if (entry.sequenceId != entry2.sequenceId) {
                return entry2.sequenceId - entry.sequenceId;
            }
            if (entry.alignmentStart != entry2.alignmentStart) {
                return entry.alignmentStart - entry2.alignmentStart;
            }
            return (int)(entry.containerStartOffset - entry2.containerStartOffset);
        }
    };

    public CramIndex(OutputStream outputStream) {
        this.os = outputStream;
    }

    public void addContainer(Container container) throws IOException {
        int n = 0;
        while (n < container.slices.length) {
            Slice slice = container.slices[n];
            Entry entry = new Entry();
            entry.sequenceId = container.sequenceId;
            entry.alignmentStart = slice.alignmentStart;
            entry.alignmentSpan = slice.alignmentSpan;
            entry.containerStartOffset = container.offset;
            entry.sliceOffset = container.landmarks[n];
            entry.sliceSize = slice.size;
            entry.sliceIndex = n++;
            String string = entry.toString();
            this.os.write(string.getBytes());
            this.os.write(10);
        }
    }

    private static void addContainer(Container container, List<Entry> list) throws IOException {
        int n = 0;
        while (n < container.slices.length) {
            Slice slice = container.slices[n];
            Entry entry = new Entry();
            entry.sequenceId = container.sequenceId;
            entry.alignmentStart = slice.alignmentStart;
            entry.alignmentSpan = slice.alignmentSpan;
            entry.containerStartOffset = container.offset;
            entry.sliceOffset = container.landmarks[n];
            entry.sliceSize = slice.size;
            entry.sliceIndex = n++;
            list.add(entry);
        }
    }

    public static List<Entry> buildIndexForCramFile(InputStream inputStream) throws IOException {
        CountingInputStream countingInputStream = new CountingInputStream(inputStream);
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        while (true) {
            long l = countingInputStream.getCount();
            Container container = CramIO.readContainer(countingInputStream);
            if (container == null || container.isEOF()) break;
            container.offset = l;
            CramIndex.addContainer(container, arrayList);
        }
        return arrayList;
    }

    public static List<Entry> buildIndexForCramFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return CramIndex.buildIndexForCramFile(bufferedInputStream);
    }

    public static List<Entry> readIndexFromCraiFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
        return CramIndex.readIndexFromCraiStream(gZIPInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Entry> readIndexFromCraiStream(InputStream inputStream) {
        LinkedList<Entry> linkedList = new LinkedList<Entry>();
        Scanner scanner = new Scanner(inputStream);
        try {
            while (scanner.hasNextLine()) {
                String string = scanner.nextLine();
                Entry entry = new Entry(string);
                linkedList.add(entry);
            }
        }
        finally {
            try {
                scanner.close();
            }
            catch (Exception exception) {}
        }
        return linkedList;
    }

    private static boolean intersect(Entry entry, Entry entry2) {
        if (entry.sequenceId != entry2.sequenceId) {
            return false;
        }
        if (entry.sequenceId < 0) {
            return false;
        }
        int n = entry.alignmentStart;
        int n2 = n + entry.alignmentSpan;
        int n3 = entry2.alignmentStart;
        int n4 = n3 + entry2.alignmentSpan;
        boolean bl = Math.abs(n + n2 - n3 - n4) < entry.alignmentSpan + entry2.alignmentSpan;
        return bl;
    }

    public static List<Entry> find(List<Entry> list, int n, int n2, int n3) {
        boolean bl = n2 < 1 || n3 < 1;
        Entry entry = new Entry();
        entry.sequenceId = n;
        entry.alignmentStart = n2 < 1 ? 1 : n2;
        entry.alignmentSpan = n3 < 1 ? Integer.MAX_VALUE : n3;
        entry.containerStartOffset = Long.MAX_VALUE;
        entry.sliceOffset = Integer.MAX_VALUE;
        entry.sliceSize = Integer.MAX_VALUE;
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (Entry entry2 : list) {
            if (entry2.sequenceId != n || !bl && !CramIndex.intersect(entry2, entry)) continue;
            arrayList.add(entry2);
        }
        Collections.sort(arrayList, byStart);
        return arrayList;
    }

    public void close() throws IOException {
        this.os.close();
    }

    public static Entry getLeftmost(List<Entry> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Entry entry = list.get(0);
        for (Entry entry2 : list) {
            if (entry2.alignmentStart >= entry.alignmentStart) continue;
            entry = entry2;
        }
        return entry;
    }

    private static int findLastAlignedEntry(List<Entry> list) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            Entry entry = list.get(n3);
            if (entry.sequenceId >= 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return n;
    }

    public static class Entry
    implements Comparable<Entry>,
    Cloneable {
        public int sequenceId;
        public int alignmentStart;
        public int alignmentSpan;
        public long containerStartOffset;
        public int sliceOffset;
        public int sliceSize;
        public int sliceIndex;

        public Entry() {
        }

        public Entry(String string) {
            String[] stringArray = string.split("\t");
            if (stringArray.length != 6) {
                throw new RuntimeException("Invalid index format.");
            }
            this.sequenceId = Integer.valueOf(stringArray[0]);
            this.alignmentStart = Integer.valueOf(stringArray[1]);
            this.alignmentSpan = Integer.valueOf(stringArray[2]);
            this.containerStartOffset = Long.valueOf(stringArray[3]);
            this.sliceOffset = Integer.valueOf(stringArray[4]);
            this.sliceSize = Integer.valueOf(stringArray[5]);
        }

        public String toString() {
            return String.format("%d\t%d\t%d\t%d\t%d\t%d", this.sequenceId, this.alignmentStart, this.alignmentSpan, this.containerStartOffset, this.sliceOffset, this.sliceSize);
        }

        @Override
        public int compareTo(Entry entry) {
            if (this.sequenceId != entry.sequenceId) {
                return entry.sequenceId - this.sequenceId;
            }
            if (this.alignmentStart != entry.alignmentStart) {
                return this.alignmentStart - entry.alignmentStart;
            }
            return (int)(this.containerStartOffset - entry.containerStartOffset);
        }

        public Entry clone() throws CloneNotSupportedException {
            Entry entry = new Entry();
            entry.sequenceId = this.sequenceId;
            entry.alignmentStart = this.alignmentStart;
            entry.alignmentSpan = this.alignmentSpan;
            entry.containerStartOffset = this.containerStartOffset;
            entry.sliceOffset = this.sliceOffset;
            entry.sliceSize = this.sliceSize;
            return entry;
        }
    }
}

