/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import sun.misc.CRC16;

public class ByteBufferUtils {
    private static ExposedByteArrayOutputStream ltf8TestBAOS = new ExposedByteArrayOutputStream();
    private static ByteArrayInputStream ltf8TestBAIS = new ByteArrayInputStream(ltf8TestBAOS.getBuffer());
    public static int GZIP_COMPRESSION_LEVEL = Integer.valueOf(System.getProperty("gzip.compression.level", "5"));
    private static BigInteger HASH = new BigInteger("811c9dc5", 16);
    private static final BigInteger PRIME32 = new BigInteger("01000193", 16);
    private static final BigInteger MOD32 = new BigInteger("2").pow(32);
    private static long prime32 = PRIME32.longValue();
    private static long mod32 = MOD32.longValue();

    public static final int readUnsignedITF8(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        if ((n & 0x80) == 0) {
            return n;
        }
        if ((n & 0x40) == 0) {
            return (n & 0x7F) << 8 | inputStream.read();
        }
        if ((n & 0x20) == 0) {
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            return (n & 0x3F) << 16 | n2 << 8 | n3;
        }
        if ((n & 0x10) == 0) {
            return (n & 0x1F) << 24 | inputStream.read() << 16 | inputStream.read() << 8 | inputStream.read();
        }
        return (n & 0xF) << 28 | inputStream.read() << 20 | inputStream.read() << 12 | inputStream.read() << 4 | 0xF & inputStream.read();
    }

    public static final int writeUnsignedITF8(int n, OutputStream outputStream) throws IOException {
        if (n >>> 7 == 0) {
            outputStream.write(n);
            return 8;
        }
        if (n >>> 14 == 0) {
            outputStream.write(n >> 8 | 0x80);
            outputStream.write(n & 0xFF);
            return 16;
        }
        if (n >>> 21 == 0) {
            outputStream.write(n >> 16 | 0xC0);
            outputStream.write(n >> 8 & 0xFF);
            outputStream.write(n & 0xFF);
            return 24;
        }
        if (n >>> 28 == 0) {
            outputStream.write(n >> 24 | 0xE0);
            outputStream.write(n >> 16 & 0xFF);
            outputStream.write(n >> 8 & 0xFF);
            outputStream.write(n & 0xFF);
            return 32;
        }
        outputStream.write(n >> 28 | 0xF0);
        outputStream.write(n >> 20 & 0xFF);
        outputStream.write(n >> 12 & 0xFF);
        outputStream.write(n >> 4 & 0xFF);
        outputStream.write(n & 0xFF);
        return 40;
    }

    public static final long readUnsignedLTF8(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        if ((n & 0x80) == 0) {
            return n;
        }
        if ((n & 0x40) == 0) {
            return (n & 0x7F) << 8 | inputStream.read();
        }
        if ((n & 0x20) == 0) {
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            return (n & 0x3F) << 16 | n2 << 8 | n3;
        }
        if ((n & 0x10) == 0) {
            long l = (long)(n & 0x1F) << 24;
            l |= (long)(inputStream.read() << 16);
            l |= (long)(inputStream.read() << 8);
            return l |= (long)inputStream.read();
        }
        if ((n & 8) == 0) {
            long l = (long)(n & 0xF) << 32;
            l |= (0xFFL & (long)inputStream.read()) << 24;
            l |= (long)(inputStream.read() << 16);
            l |= (long)(inputStream.read() << 8);
            return l |= (long)inputStream.read();
        }
        if ((n & 4) == 0) {
            long l = (long)(n & 7) << 40;
            l |= (0xFFL & (long)inputStream.read()) << 32;
            l |= (0xFFL & (long)inputStream.read()) << 24;
            l |= (long)(inputStream.read() << 16);
            l |= (long)(inputStream.read() << 8);
            return l |= (long)inputStream.read();
        }
        if ((n & 2) == 0) {
            long l = (long)(n & 3) << 48;
            l |= (0xFFL & (long)inputStream.read()) << 40;
            l |= (0xFFL & (long)inputStream.read()) << 32;
            l |= (0xFFL & (long)inputStream.read()) << 24;
            l |= (long)(inputStream.read() << 16);
            l |= (long)(inputStream.read() << 8);
            return l |= (long)inputStream.read();
        }
        if ((n & 1) == 0) {
            long l = (0xFFL & (long)inputStream.read()) << 48;
            l |= (0xFFL & (long)inputStream.read()) << 40;
            l |= (0xFFL & (long)inputStream.read()) << 32;
            l |= (0xFFL & (long)inputStream.read()) << 24;
            l |= (long)(inputStream.read() << 16);
            l |= (long)(inputStream.read() << 8);
            return l |= (long)inputStream.read();
        }
        long l = (0xFFL & (long)inputStream.read()) << 56;
        l |= (0xFFL & (long)inputStream.read()) << 48;
        l |= (0xFFL & (long)inputStream.read()) << 40;
        l |= (0xFFL & (long)inputStream.read()) << 32;
        l |= (0xFFL & (long)inputStream.read()) << 24;
        l |= (long)(inputStream.read() << 16);
        l |= (long)(inputStream.read() << 8);
        return l |= (long)inputStream.read();
    }

    public static final int writeUnsignedLTF8(long l, OutputStream outputStream) throws IOException {
        if (l >>> 7 == 0L) {
            outputStream.write((int)l);
            return 8;
        }
        if (l >>> 14 == 0L) {
            outputStream.write((int)(l >> 8 | 0x80L));
            outputStream.write((int)(l & 0xFFL));
            return 16;
        }
        if (l >>> 21 == 0L) {
            outputStream.write((int)(l >> 16 | 0xC0L));
            outputStream.write((int)(l >> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 24;
        }
        if (l >>> 28 == 0L) {
            outputStream.write((int)(l >> 24 | 0xE0L));
            outputStream.write((int)(l >> 16 & 0xFFL));
            outputStream.write((int)(l >> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 32;
        }
        if (l >>> 35 == 0L) {
            outputStream.write((int)(l >> 32 | 0xF0L));
            outputStream.write((int)(l >> 24 & 0xFFL));
            outputStream.write((int)(l >> 16 & 0xFFL));
            outputStream.write((int)(l >> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 40;
        }
        if (l >>> 42 == 0L) {
            outputStream.write((int)(l >> 40 | 0xF8L));
            outputStream.write((int)(l >> 32 & 0xFFL));
            outputStream.write((int)(l >> 24 & 0xFFL));
            outputStream.write((int)(l >> 16 & 0xFFL));
            outputStream.write((int)(l >> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 48;
        }
        if (l >>> 49 == 0L) {
            outputStream.write((int)(l >> 48 | 0xFCL));
            outputStream.write((int)(l >> 40 & 0xFFL));
            outputStream.write((int)(l >> 32 & 0xFFL));
            outputStream.write((int)(l >> 24 & 0xFFL));
            outputStream.write((int)(l >> 16 & 0xFFL));
            outputStream.write((int)(l >> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 56;
        }
        if (l >>> 56 == 0L) {
            outputStream.write(254);
            outputStream.write((int)(l >> 48 & 0xFFL));
            outputStream.write((int)(l >> 40 & 0xFFL));
            outputStream.write((int)(l >> 32 & 0xFFL));
            outputStream.write((int)(l >> 24 & 0xFFL));
            outputStream.write((int)(l >> 16 & 0xFFL));
            outputStream.write((int)(l >> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 64;
        }
        outputStream.write(255);
        outputStream.write((int)(l >> 56 & 0xFFL));
        outputStream.write((int)(l >> 48 & 0xFFL));
        outputStream.write((int)(l >> 40 & 0xFFL));
        outputStream.write((int)(l >> 32 & 0xFFL));
        outputStream.write((int)(l >> 28 & 0xFFL));
        outputStream.write((int)(l >> 16 & 0xFFL));
        outputStream.write((int)(l >> 8 & 0xFFL));
        outputStream.write((int)(l & 0xFFL));
        return 72;
    }

    public static final int readUnsignedITF8(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        byteBuffer.clear();
        return n;
    }

    public static final byte[] writeUnsignedITF8(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        ByteBufferUtils.writeUnsignedITF8(n, byteBuffer);
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        byteBuffer.clear();
        return byArray;
    }

    public static final int readUnsignedITF8(ByteBuffer byteBuffer) {
        int n = 0xFF & byteBuffer.get();
        if ((n & 0x80) == 0) {
            return n;
        }
        if ((n & 0x40) == 0) {
            return (n & 0x7F) << 8 | 0xFF & byteBuffer.get();
        }
        if ((n & 0x20) == 0) {
            int n2 = 0xFF & byteBuffer.get();
            int n3 = 0xFF & byteBuffer.get();
            return (n & 0x3F) << 16 | n2 << 8 | n3;
        }
        if ((n & 0x10) == 0) {
            return (n & 0x1F) << 24 | (0xFF & byteBuffer.get()) << 16 | (0xFF & byteBuffer.get()) << 8 | 0xFF & byteBuffer.get();
        }
        return (n & 0xF) << 28 | (0xFF & byteBuffer.get()) << 20 | (0xFF & byteBuffer.get()) << 12 | (0xFF & byteBuffer.get()) << 4 | 0xF & byteBuffer.get();
    }

    public static final void writeUnsignedITF8(int n, ByteBuffer byteBuffer) {
        if (n >>> 7 == 0) {
            byteBuffer.put((byte)n);
            return;
        }
        if (n >>> 14 == 0) {
            byteBuffer.put((byte)(n >> 8 | 0x80));
            byteBuffer.put((byte)(n & 0xFF));
            return;
        }
        if (n >>> 21 == 0) {
            byteBuffer.put((byte)(n >> 16 | 0xC0));
            byteBuffer.put((byte)(n >> 8 & 0xFF));
            byteBuffer.put((byte)(n & 0xFF));
            return;
        }
        if (n >>> 28 == 0) {
            byteBuffer.put((byte)(n >> 24 | 0xE0));
            byteBuffer.put((byte)(n >> 16 & 0xFF));
            byteBuffer.put((byte)(n >> 8 & 0xFF));
            byteBuffer.put((byte)(n & 0xFF));
            return;
        }
        byteBuffer.put((byte)(n >> 28 | 0xF0));
        byteBuffer.put((byte)(n >> 20 & 0xFF));
        byteBuffer.put((byte)(n >> 12 & 0xFF));
        byteBuffer.put((byte)(n >> 4 & 0xFF));
        byteBuffer.put((byte)(n & 0xFF));
    }

    private static boolean testLTF8(long l) throws IOException {
        ltf8TestBAOS.reset();
        int n = ByteBufferUtils.writeUnsignedLTF8(l, ltf8TestBAOS);
        if (n > 72) {
            System.out.println("Written length is too big: " + n);
            return false;
        }
        ltf8TestBAIS.reset();
        long l2 = ByteBufferUtils.readUnsignedLTF8(ltf8TestBAIS);
        if (l != l2) {
            System.out.printf("Value=%d, result=%d\n", l, l2);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        CRC16 cRC16 = new CRC16();
        String string = "00 00 00 00 ff ff ff ff ff e0 45 4f 46 00 00 00 00 01 00";
        string = "01";
        for (byte by : ByteBufferUtils.bytesFromHex(string)) {
            cRC16.update(by);
        }
        cRC16.reset();
        cRC16.update((byte)1);
        System.out.println("crc16: " + cRC16.value);
        System.out.println("fnv1a_32: " + ByteBufferUtils.fnv1a_32("a".getBytes()));
        System.out.println("FNV_1a: " + ByteBufferUtils.my_fnv1a_32("a".getBytes()));
        System.out.println(2166136261L);
        System.out.println(3826002220L);
        byte[] byArray = new byte[0x100000];
        new Random().nextBytes(byArray);
        long l = 0L;
        Adler32 adler32 = new Adler32();
        long l2 = 0L;
        long l3 = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            l += ByteBufferUtils.my_fnv1a_32(byArray);
        }
        long l4 = System.currentTimeMillis();
        System.out.println(l2);
        System.out.printf("FNV_1A: %.2f s\n", Float.valueOf((float)(l4 - l3) / 1000.0f));
        CRC32 cRC32 = new CRC32();
        l3 = System.currentTimeMillis();
        for (n = 0; n < 100; ++n) {
            cRC32.reset();
            cRC32.update(byArray);
            l += cRC32.getValue();
        }
        l4 = System.currentTimeMillis();
        System.out.println(l2);
        System.out.printf("CRC32: %.2f s\n", Float.valueOf((float)(l4 - l3) / 1000.0f));
        l3 = System.currentTimeMillis();
        for (n = 0; n < 100; ++n) {
            adler32.reset();
            adler32.update(byArray);
            l2 += adler32.getValue();
        }
        l4 = System.currentTimeMillis();
        System.out.println(l);
        System.out.printf("Adler32: %.2f s\n", Float.valueOf((float)(l4 - l3) / 1000.0f));
    }

    private static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by : byArray) {
            stringBuffer.append(Integer.toHexString(0xFF & by));
        }
        return stringBuffer.toString();
    }

    public static int int32(InputStream inputStream) throws IOException {
        return inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | inputStream.read() << 24;
    }

    public static int int32(byte[] byArray) throws IOException {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Expecting a 4-byte integer. ");
        }
        return 0xFF & byArray[0] | (0xFF & byArray[1]) << 8 | (0xFF & byArray[2]) << 16 | (0xFF & byArray[3]) << 24;
    }

    public static int writeInt32(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)n);
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)(n >> 16));
        outputStream.write((byte)(n >> 24));
        return 4;
    }

    public static int int32(ByteBuffer byteBuffer) throws IOException {
        return byteBuffer.get() | byteBuffer.get() << 8 | byteBuffer.get() << 16 | byteBuffer.get() << 24;
    }

    public static int[] array(InputStream inputStream) throws IOException {
        int n = ByteBufferUtils.readUnsignedITF8(inputStream);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = ByteBufferUtils.readUnsignedITF8(inputStream);
        }
        return nArray;
    }

    public static int write(int[] nArray, OutputStream outputStream) throws IOException {
        int n = ByteBufferUtils.writeUnsignedITF8(nArray.length, outputStream);
        for (int i = 0; i < nArray.length; ++i) {
            n += ByteBufferUtils.writeUnsignedITF8(nArray[i], outputStream);
        }
        return n;
    }

    public static int readFully(byte[] byArray, InputStream inputStream) throws IOException {
        return ByteBufferUtils.readFully(byArray, byArray.length, 0, inputStream);
    }

    public static int readFully(byte[] byArray, int n, int n2, InputStream inputStream) throws IOException {
        int n3;
        int n4;
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n3 = 0; n3 < n; n3 += n4) {
            n4 = inputStream.read(byArray, n2 + n3, n - n3);
            if (n4 >= 0) continue;
            throw new EOFException();
        }
        return n3;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        long l = 0L;
        int n = 0;
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        long l = ByteBufferUtils.copyLarge(inputStream, byteArrayOutputStream);
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("Failed to copy data because the size is over 2g limit. ");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] gunzip(byte[] byArray) throws IOException {
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
        return ByteBufferUtils.readFully(gZIPInputStream);
    }

    public static byte[] gzip(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream){
            {
                this.def.setLevel(GZIP_COMPRESSION_LEVEL);
            }
        };
        long l = ByteBufferUtils.copyLarge(new ByteArrayInputStream(byArray), gZIPOutputStream);
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static String substring(ByteBuffer byteBuffer, int n) {
        byte[] byArray = new byte[Math.min(n, byteBuffer.limit())];
        byteBuffer.get(byArray);
        return new String(byArray);
    }

    public static final long FNV_1a(byte[] byArray) {
        int n;
        long l = 2166136261L;
        long l2 = 0L;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        for (n = 0; n < byArray.length / 8; ++n) {
            l |= byteBuffer.getLong();
            l *= 1099511628211L;
        }
        for (n = 0; n < byArray.length % 8; ++n) {
            l2 |= (long)(byArray[byArray.length - byArray.length % 8 + n] << 64 - n * 8);
        }
        return l *= 1099511628211L;
    }

    public static final BigInteger fnv1a_32(byte[] byArray) {
        for (byte by : byArray) {
            HASH = HASH.xor(BigInteger.valueOf(by & 0xFF));
            HASH = HASH.multiply(PRIME32).mod(MOD32);
        }
        return HASH;
    }

    public static final long my_fnv1a(byte[] byArray) {
        long l = 2166136261L;
        for (byte by : byArray) {
            l ^= (long)(by & 0xFF);
            l = l * 16777619L % 0x100000000L;
        }
        return l;
    }

    public static final long my_fnv1a_32(byte[] byArray) {
        long l = 2166136261L;
        for (byte by : byArray) {
            l ^= (long)(by & 0xFF);
            l *= 16777619L;
        }
        return l % 0x100000000L;
    }

    public static byte[] bytesFromHex(String string) {
        String string2 = string.replaceAll("[^0-9a-f]", "");
        if (string2.length() % 2 != 0) {
            throw new RuntimeException("Not a hex string: " + string);
        }
        byte[] byArray = new byte[string2.length() / 2];
        for (int i = 0; i < string2.length(); i += 2) {
            byArray[i / 2] = Integer.decode("0x" + string2.charAt(i) + string2.charAt(i + 1)).byteValue();
        }
        return byArray;
    }

    public static void reverse(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return;
        }
        int n3 = n;
        for (int i = n2 - 1; i > n3; --i, ++n3) {
            byte by = byArray[i];
            byArray[i] = byArray[n3];
            byArray[n3] = by;
        }
    }

    public static void reverse(ByteBuffer byteBuffer) {
        byte by = 0;
        if (byteBuffer.hasArray()) {
            ByteBufferUtils.reverse(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
        } else {
            for (int i = 0; i < byteBuffer.limit(); ++i) {
                by = byteBuffer.get(i);
                byteBuffer.put(i, byteBuffer.get(byteBuffer.limit() - i - 1));
                byteBuffer.put(byteBuffer.limit() - i - 1, by);
            }
        }
    }
}

