/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.lossy;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.encoding.read_features.BaseQualityScore;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.lossy.BaseCategory;
import htsjdk.samtools.cram.lossy.BaseCategoryType;
import htsjdk.samtools.cram.lossy.Binning;
import htsjdk.samtools.cram.lossy.PreservationPolicy;
import htsjdk.samtools.cram.lossy.QualityScoreTreatment;
import htsjdk.samtools.cram.lossy.ReadCategory;
import htsjdk.samtools.cram.ref.ReferenceTracks;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class QualityScorePreservation {
    private String specification;
    private List<PreservationPolicy> policyList;
    private static final Comparator<ReadFeature> readFeaturePositionComparator = new Comparator<ReadFeature>(){

        @Override
        public int compare(ReadFeature readFeature, ReadFeature readFeature2) {
            return readFeature.getPosition() - readFeature2.getPosition();
        }
    };

    public QualityScorePreservation(String string) {
        this.specification = string;
        this.policyList = QualityScorePreservation.parsePolicies(string);
    }

    public List<PreservationPolicy> getPreservationPolicies() {
        return this.policyList;
    }

    private static final int readParam(LinkedList<Character> linkedList) {
        int n = 0;
        while (!linkedList.isEmpty() && Character.isDigit(linkedList.getFirst().charValue())) {
            n = n * 10 + (linkedList.removeFirst().charValue() - 48);
        }
        return n;
    }

    private static final QualityScoreTreatment readTreament(LinkedList<Character> linkedList) {
        QualityScoreTreatment qualityScoreTreatment;
        int n = QualityScorePreservation.readParam(linkedList);
        switch (n) {
            case 0: {
                qualityScoreTreatment = QualityScoreTreatment.drop();
                break;
            }
            case 40: {
                qualityScoreTreatment = QualityScoreTreatment.preserve();
                break;
            }
            default: {
                qualityScoreTreatment = QualityScoreTreatment.bin(n);
            }
        }
        return qualityScoreTreatment;
    }

    public static final List<PreservationPolicy> parsePolicies(String string) {
        ArrayList<PreservationPolicy> arrayList = new ArrayList<PreservationPolicy>();
        for (String string2 : string.split("-")) {
            if (string2.length() == 0) continue;
            PreservationPolicy preservationPolicy = QualityScorePreservation.parseSinglePolicy(string2);
            arrayList.add(preservationPolicy);
        }
        Collections.sort(arrayList, new Comparator<PreservationPolicy>(){

            @Override
            public int compare(PreservationPolicy preservationPolicy, PreservationPolicy preservationPolicy2) {
                QualityScoreTreatment qualityScoreTreatment = preservationPolicy.treatment;
                QualityScoreTreatment qualityScoreTreatment2 = preservationPolicy2.treatment;
                int n = qualityScoreTreatment2.type.ordinal() - qualityScoreTreatment.type.ordinal();
                if (n != 0) {
                    return n;
                }
                return 0;
            }
        });
        return arrayList;
    }

    private static final PreservationPolicy parseSinglePolicy(String string) {
        PreservationPolicy preservationPolicy = new PreservationPolicy();
        LinkedList<Character> linkedList = new LinkedList<Character>();
        for (char n : string.toCharArray()) {
            linkedList.add(Character.valueOf(n));
        }
        while (!linkedList.isEmpty()) {
            char c = ((Character)linkedList.removeFirst()).charValue();
            switch (c) {
                case 'R': {
                    preservationPolicy.baseCategories.add(BaseCategory.match());
                    preservationPolicy.treatment = QualityScorePreservation.readTreament(linkedList);
                    break;
                }
                case 'N': {
                    preservationPolicy.baseCategories.add(BaseCategory.mismatch());
                    preservationPolicy.treatment = QualityScorePreservation.readTreament(linkedList);
                    break;
                }
                case 'X': {
                    int n = QualityScorePreservation.readParam(linkedList);
                    preservationPolicy.baseCategories.add(BaseCategory.lower_than_coverage(n));
                    break;
                }
                case 'D': {
                    preservationPolicy.baseCategories.add(BaseCategory.flanking_deletion());
                    preservationPolicy.treatment = QualityScorePreservation.readTreament(linkedList);
                    break;
                }
                case 'M': {
                    int n = QualityScorePreservation.readParam(linkedList);
                    preservationPolicy.readCategory = ReadCategory.higher_than_mapping_score(n);
                    break;
                }
                case 'm': {
                    int n = QualityScorePreservation.readParam(linkedList);
                    preservationPolicy.readCategory = ReadCategory.lower_than_mapping_score(n);
                    break;
                }
                case 'U': {
                    preservationPolicy.readCategory = ReadCategory.unplaced();
                    preservationPolicy.treatment = QualityScorePreservation.readTreament(linkedList);
                    break;
                }
                case 'P': {
                    int n = QualityScorePreservation.readParam(linkedList);
                    preservationPolicy.baseCategories.add(BaseCategory.pileup(n));
                    preservationPolicy.treatment = QualityScorePreservation.readTreament(linkedList);
                    break;
                }
                case 'I': {
                    preservationPolicy.baseCategories.add(BaseCategory.insertion());
                    preservationPolicy.treatment = QualityScorePreservation.readTreament(linkedList);
                    break;
                }
                case '_': {
                    preservationPolicy.treatment = QualityScorePreservation.readTreament(linkedList);
                    break;
                }
                case '*': {
                    preservationPolicy.readCategory = ReadCategory.all();
                    preservationPolicy.treatment = QualityScorePreservation.readTreament(linkedList);
                    break;
                }
                default: {
                    throw new RuntimeException("Uknown read or base category: " + c);
                }
            }
            if (preservationPolicy.treatment != null) continue;
            preservationPolicy.treatment = QualityScoreTreatment.preserve();
        }
        return preservationPolicy;
    }

    public static final void applyBinning(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = Binning.Illumina_binning_matrix[byArray[i]];
        }
    }

    public static final byte applyTreatment(byte by, QualityScoreTreatment qualityScoreTreatment) {
        switch (qualityScoreTreatment.type) {
            case BIN: {
                return Binning.Illumina_binning_matrix[by];
            }
            case DROP: {
                return -1;
            }
            case PRESERVE: {
                return by;
            }
        }
        throw new RuntimeException("Unknown quality score treatment type: " + qualityScoreTreatment.type.name());
    }

    public void addQualityScores(SAMRecord sAMRecord, CramCompressionRecord cramCompressionRecord, ReferenceTracks referenceTracks) {
        if (sAMRecord.getBaseQualities() == SAMRecord.NULL_QUALS) {
            cramCompressionRecord.qualityScores = SAMRecord.NULL_QUALS;
            cramCompressionRecord.setForcePreserveQualityScores(false);
            return;
        }
        byte[] byArray = new byte[sAMRecord.getReadLength()];
        Arrays.fill(byArray, (byte)-1);
        for (PreservationPolicy preservationPolicy : this.policyList) {
            QualityScorePreservation.addQS(sAMRecord, cramCompressionRecord, byArray, referenceTracks, preservationPolicy);
        }
        if (!cramCompressionRecord.isForcePreserveQualityScores()) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] <= -1) continue;
                if (cramCompressionRecord.readFeatures == null) {
                    cramCompressionRecord.readFeatures = new LinkedList<ReadFeature>();
                }
                cramCompressionRecord.readFeatures.add(new BaseQualityScore(i + 1, byArray[i]));
            }
            if (cramCompressionRecord.readFeatures != null) {
                Collections.sort(cramCompressionRecord.readFeatures, readFeaturePositionComparator);
            }
        }
        cramCompressionRecord.qualityScores = byArray;
    }

    public boolean areReferenceTracksRequired() {
        if (this.policyList == null || this.policyList.isEmpty()) {
            return false;
        }
        for (PreservationPolicy preservationPolicy : this.policyList) {
            if (preservationPolicy.baseCategories == null || preservationPolicy.baseCategories.isEmpty()) continue;
            for (BaseCategory baseCategory : preservationPolicy.baseCategories) {
                switch (baseCategory.type) {
                    case LOWER_COVERAGE: 
                    case PILEUP: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static final void addQS(SAMRecord sAMRecord, CramCompressionRecord cramCompressionRecord, byte[] byArray, ReferenceTracks referenceTracks, PreservationPolicy preservationPolicy) {
        int n = sAMRecord.getAlignmentEnd() - sAMRecord.getAlignmentStart();
        byte[] byArray2 = sAMRecord.getBaseQualities();
        if (preservationPolicy.readCategory != null) {
            boolean bl = false;
            switch (preservationPolicy.readCategory.type) {
                case ALL: {
                    bl = true;
                    break;
                }
                case UNPLACED: {
                    bl = sAMRecord.getReadUnmappedFlag();
                    break;
                }
                case LOWER_MAPPING_SCORE: {
                    bl = sAMRecord.getMappingQuality() < preservationPolicy.readCategory.param;
                    break;
                }
                case HIGHER_MAPPING_SCORE: {
                    bl = sAMRecord.getMappingQuality() > preservationPolicy.readCategory.param;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown read category: " + preservationPolicy.readCategory.type.name());
                }
            }
            if (!bl) {
                return;
            }
        }
        if (preservationPolicy.baseCategories == null || preservationPolicy.baseCategories.isEmpty()) {
            switch (preservationPolicy.treatment.type) {
                case BIN: {
                    if (cramCompressionRecord.qualityScores == null) {
                        cramCompressionRecord.qualityScores = sAMRecord.getBaseQualities();
                    }
                    System.arraycopy(sAMRecord.getBaseQualities(), 0, byArray, 0, byArray.length);
                    QualityScorePreservation.applyBinning(byArray);
                    cramCompressionRecord.setForcePreserveQualityScores(true);
                    break;
                }
                case PRESERVE: {
                    System.arraycopy(sAMRecord.getBaseQualities(), 0, byArray, 0, byArray.length);
                    cramCompressionRecord.setForcePreserveQualityScores(true);
                    break;
                }
                case DROP: {
                    cramCompressionRecord.qualityScores = null;
                    cramCompressionRecord.setForcePreserveQualityScores(false);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown quality score treatment type: " + preservationPolicy.treatment.type.name());
                }
            }
            return;
        }
        boolean[] blArray = new boolean[byArray2.length];
        int n2 = sAMRecord.getAlignmentStart();
        if (n2 == 0) {
            return;
        }
        referenceTracks.ensureRange(n2, n);
        block24: for (BaseCategory baseCategory : preservationPolicy.baseCategories) {
            switch (baseCategory.type) {
                case FLANKING_DELETION: {
                    int n3 = 0;
                    for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
                        if (cigarElement.getOperator() == CigarOperator.D) {
                            blArray[n3] = true;
                            if (n3 + 1 < blArray.length) {
                                blArray[n3 + 1] = true;
                            }
                        }
                        n3 += cigarElement.getOperator().consumesReadBases() ? cigarElement.getLength() : 0;
                    }
                    continue block24;
                }
                case MATCH: 
                case MISMATCH: {
                    int n4;
                    int n3 = 0;
                    int n5 = sAMRecord.getAlignmentStart();
                    for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
                        if (cigarElement.getOperator().consumesReadBases()) {
                            for (n4 = 0; n4 < cigarElement.getLength(); ++n4) {
                                boolean bl = sAMRecord.getReadBases()[n3 + n4] == referenceTracks.baseAt(n5 + n4);
                                blArray[n3 + n4] = baseCategory.type == BaseCategoryType.MATCH && bl || baseCategory.type == BaseCategoryType.MISMATCH && !bl;
                            }
                            n3 += cigarElement.getLength();
                        }
                        n5 += cigarElement.getOperator().consumesReferenceBases() ? cigarElement.getLength() : 0;
                    }
                    continue block24;
                }
                case INSERTION: {
                    int n4;
                    int n3 = 0;
                    for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
                        switch (cigarElement.getOperator()) {
                            case I: {
                                for (n4 = 0; n4 < cigarElement.getLength(); ++n4) {
                                    blArray[n3 + n4] = true;
                                }
                                break;
                            }
                        }
                        n3 += cigarElement.getOperator().consumesReadBases() ? cigarElement.getLength() : 0;
                    }
                    continue block24;
                }
                case LOWER_COVERAGE: {
                    int n4;
                    int n3 = 1;
                    int n5 = sAMRecord.getAlignmentStart();
                    for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
                        switch (cigarElement.getOperator()) {
                            case M: 
                            case EQ: 
                            case X: {
                                for (n4 = 0; n4 < cigarElement.getLength(); ++n4) {
                                    blArray[n3 + n4 - 1] = referenceTracks.coverageAt(n5 + n4) < baseCategory.param;
                                }
                                break;
                            }
                        }
                        n3 += cigarElement.getOperator().consumesReadBases() ? cigarElement.getLength() : 0;
                        n5 += cigarElement.getOperator().consumesReferenceBases() ? cigarElement.getLength() : 0;
                    }
                    continue block24;
                }
                case PILEUP: {
                    for (int i = 0; i < byArray2.length; ++i) {
                        if (referenceTracks.mismatchesAt(n2 + i) <= baseCategory.param) continue;
                        blArray[i] = true;
                    }
                    continue block24;
                }
            }
        }
        int n6 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            byArray[i] = QualityScorePreservation.applyTreatment(byArray2[i], preservationPolicy.treatment);
            ++n6;
        }
        if (n6 > sAMRecord.getReadLength() / 2) {
            cramCompressionRecord.setForcePreserveQualityScores(true);
        }
    }
}

