/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.mask;

import htsjdk.samtools.cram.mask.ArrayPositionMask;
import htsjdk.samtools.cram.mask.PositionMask;
import htsjdk.samtools.cram.mask.ReadMaskFactory;
import htsjdk.samtools.cram.mask.ReadMaskFormatException;
import java.nio.IntBuffer;

public class FastaByteArrayMaskFactory
implements ReadMaskFactory<String> {
    public static final byte DEFAULT_MASK_BYTE = 120;
    public static final byte DEFAULT_NON_MASK_BYTE = 95;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private byte maskByte;
    private IntBuffer buf;

    public FastaByteArrayMaskFactory(byte by, int n) {
        this.maskByte = by;
        this.buf = IntBuffer.allocate(n);
    }

    public FastaByteArrayMaskFactory(byte by) {
        this(by, 1024);
    }

    public FastaByteArrayMaskFactory() {
        this(120, 1024);
    }

    @Override
    public PositionMask createMask(String string) throws ReadMaskFormatException {
        if (string.length() == 0) {
            return ArrayPositionMask.EMPTY_INSTANCE;
        }
        byte[] byArray = string.getBytes();
        this.buf.clear();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == this.maskByte) {
                this.buf.put(i + 1);
                continue;
            }
            if (byArray[i] != 10) continue;
            throw new ReadMaskFormatException("New line not allowed inside of mask line: " + string.substring(0, Math.min(10, string.length())));
        }
        this.buf.flip();
        int[] nArray = new int[this.buf.limit()];
        this.buf.get(nArray);
        return new ArrayPositionMask(nArray);
    }
}

