/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.mask;

import htsjdk.samtools.cram.mask.ArrayPositionMask;
import htsjdk.samtools.cram.mask.PositionMask;
import htsjdk.samtools.cram.mask.ReadMaskFactory;
import htsjdk.samtools.cram.mask.ReadMaskFormatException;
import java.nio.IntBuffer;

public class IntegerListMaskFactory
implements ReadMaskFactory<String> {
    public static final String DEFAULT_DEMLIITER = " ";
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private String delimiter;
    private IntBuffer buf;

    public IntegerListMaskFactory(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Delimiter is null.");
        }
        if (n < 1) {
            throw new IllegalAccessError("Buffer size must be greater then 0.");
        }
        this.delimiter = string;
        this.buf = IntBuffer.allocate(n);
    }

    public IntegerListMaskFactory(String string) {
        this(string, 1024);
    }

    public IntegerListMaskFactory() {
        this(DEFAULT_DEMLIITER, 1024);
    }

    @Override
    public PositionMask createMask(String string) throws ReadMaskFormatException {
        if (string.length() == 0) {
            return ArrayPositionMask.EMPTY_INSTANCE;
        }
        this.buf.clear();
        try {
            for (String string2 : string.split(this.delimiter)) {
                this.buf.put(Integer.valueOf(string2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ReadMaskFormatException("Expecting integers in " + string.substring(0, Math.min(10, string.length())), numberFormatException);
        }
        this.buf.flip();
        int[] nArray = new int[this.buf.limit()];
        this.buf.get(nArray);
        ArrayPositionMask arrayPositionMask = new ArrayPositionMask(nArray);
        return arrayPositionMask;
    }
}

