/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.mask;

import java.util.Arrays;

public class RefMaskUtils {
    public static final byte[] bases = new byte[]{65, 67, 71, 84};
    public static final byte[] base2index = new byte[256];
    public static int minHits;

    public static final int getBaseCount(byte by, byte by2) {
        return 3 & by >>> 2 * base2index[by2];
    }

    public static final byte addReadBase(byte by, byte by2, byte by3) {
        int n = 0;
        switch (by2) {
            case 65: 
            case 97: {
                n = 3;
                break;
            }
            case 67: 
            case 99: {
                n = 12;
                break;
            }
            case 71: 
            case 103: {
                n = 48;
                break;
            }
            case 84: 
            case 116: {
                n = -64;
                break;
            }
            default: {
                return by;
            }
        }
        int n2 = RefMaskUtils.getBaseCount(by, by2);
        if (n2 < 3) {
            by = (byte)(by & ~n);
            by = (byte)(by | ++n2 << 2 * base2index[by2]);
        }
        return by;
    }

    public static final boolean shouldStore(byte by, byte by2) {
        for (byte by3 : bases) {
            if (by3 == by2 || RefMaskUtils.getBaseCount(by, by3) < minHits) continue;
            return true;
        }
        return false;
    }

    public static final int getBaseCount(short s, byte by) {
        return 0xF & s >>> 4 * base2index[by];
    }

    public static final short addReadBase(short s, byte by, byte by2) {
        int n = 0;
        switch (by) {
            case 65: 
            case 97: {
                n = 15;
                break;
            }
            case 67: 
            case 99: {
                n = 240;
                break;
            }
            case 71: 
            case 103: {
                n = 3840;
                break;
            }
            case 84: 
            case 116: {
                n = -4096;
                break;
            }
            default: {
                return s;
            }
        }
        int n2 = RefMaskUtils.getBaseCount(s, by);
        if (n2 < 15) {
            s = (short)(s & ~n);
            s = (short)(s | ++n2 << 4 * base2index[by]);
        }
        return s;
    }

    private static final int minCoverageEstimate(short s) {
        int n = 0xF & s;
        n += 0xF & s >>> 4;
        n += 0xF & s >>> 8;
        return n += 0xF & s >>> 12;
    }

    public static final boolean shouldStore(short s, byte by) {
        if (RefMaskUtils.minCoverageEstimate(s) > 10) {
            return false;
        }
        int[] nArray = new int[3];
        int n = 0;
        for (byte by2 : bases) {
            if (by2 == by) continue;
            nArray[n] = RefMaskUtils.getBaseCount(s, by2);
            if (nArray[n] >= minHits) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static {
        Arrays.fill(base2index, (byte)-1);
        RefMaskUtils.base2index[65] = 0;
        RefMaskUtils.base2index[97] = 0;
        RefMaskUtils.base2index[67] = 1;
        RefMaskUtils.base2index[99] = 1;
        RefMaskUtils.base2index[71] = 2;
        RefMaskUtils.base2index[103] = 2;
        RefMaskUtils.base2index[84] = 3;
        RefMaskUtils.base2index[116] = 3;
        minHits = 2;
    }

    public static class RefMask {
        private short[] mask;
        private int minHits;

        public RefMask(int n, int n2) {
            this.mask = new short[n];
            Arrays.fill(this.mask, (short)0);
            this.minHits = n2;
        }

        public void addReadBase(int n, byte by, byte by2) {
            this.mask[n] = RefMaskUtils.addReadBase(this.mask[n], by, by2);
        }

        public boolean shouldStore(int n, byte by) {
            short s = this.mask[n];
            if (s == 0) {
                return false;
            }
            if (RefMaskUtils.minCoverageEstimate(s) > 10) {
                return false;
            }
            int[] nArray = new int[3];
            int n2 = 0;
            for (byte by2 : bases) {
                if (by2 == by) continue;
                nArray[n2] = RefMaskUtils.getBaseCount(s, by2);
                if (nArray[n2] >= this.minHits) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public int getMinHits() {
            return this.minHits;
        }

        public void setMinHits(int n) {
            this.minHits = n;
        }
    }
}

