/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.ref;

import java.util.Arrays;

public class ReferenceTracks {
    private int sequenceId;
    private byte[] reference;
    private int position;
    private final byte[] bases;
    private final short[] coverage;
    private final short[] mismatches;

    public ReferenceTracks(int n, byte[] byArray) {
        this(n, byArray, 1000000);
    }

    public ReferenceTracks(int n, byte[] byArray, int n2) {
        this.sequenceId = n;
        this.reference = byArray;
        this.bases = new byte[Math.min(n2, byArray.length)];
        this.coverage = new short[Math.min(n2, byArray.length)];
        this.mismatches = new short[Math.min(n2, byArray.length)];
        this.position = 1;
        this.reset();
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public int getWindowPosition() {
        return this.position;
    }

    public int getWindowLength() {
        return this.bases.length;
    }

    public int getReferenceLength() {
        return this.reference.length;
    }

    public void ensure(int n, int n2) {
        if (n2 - n > this.bases.length) {
            throw new RuntimeException("Window is too small for start " + n + " end " + n2);
        }
        if (this.position < n) {
            this.moveForwardTo(n);
        }
    }

    public void moveForwardTo(int n) {
        if (n - 1 >= this.reference.length) {
            throw new RuntimeException("New position is beyond the reference: " + n);
        }
        if (n < this.position) {
            throw new RuntimeException("Cannot shift to smaller position on the reference.");
        }
        if (n > this.reference.length - this.bases.length + 1) {
            n = this.reference.length - this.bases.length + 1;
        }
        if (n == this.position) {
            return;
        }
        System.arraycopy(this.reference, n - 1, this.bases, 0, Math.min(this.bases.length, this.reference.length - n + 1));
        if (n > this.position && this.position + this.bases.length - n > 0) {
            for (int i = 0; i < this.coverage.length; ++i) {
                if (i + n - this.position < this.coverage.length) {
                    this.coverage[i] = this.coverage[i + n - this.position];
                    this.mismatches[i] = this.mismatches[i + n - this.position];
                    continue;
                }
                this.coverage[i] = 0;
                this.mismatches[i] = 0;
            }
        } else {
            Arrays.fill(this.coverage, (short)0);
            Arrays.fill(this.mismatches, (short)0);
        }
        this.position = n;
    }

    public void reset() {
        System.arraycopy(this.reference, this.position - 1, this.bases, 0, Math.min(this.bases.length, this.reference.length - this.position + 1));
        Arrays.fill(this.coverage, (short)0);
        Arrays.fill(this.mismatches, (short)0);
    }

    public void ensureRange(int n, int n2) {
        if (n < this.position) {
            throw new RuntimeException("Cannot move the window backwords: " + n);
        }
        if (n > this.position || n + n2 > this.position + this.bases.length) {
            this.moveForwardTo(n);
        }
    }

    public final byte baseAt(int n) {
        if (n - this.position < this.coverage.length) {
            return this.bases[n - this.position];
        }
        return 78;
    }

    public final short coverageAt(int n) {
        if (n - this.position >= this.coverage.length) {
            return 0;
        }
        return this.coverage[n - this.position];
    }

    public final short mismatchesAt(int n) {
        if (n - this.position >= this.coverage.length) {
            return 0;
        }
        return this.mismatches[n - this.position];
    }

    public final void addCoverage(int n, int n2) {
        if (n - this.position < this.coverage.length) {
            int n3 = n - this.position;
            this.coverage[n3] = (short)(this.coverage[n3] + n2);
        }
    }

    public final void addMismatches(int n, int n2) {
        if (n - this.position < this.coverage.length) {
            int n3 = n - this.position;
            this.mismatches[n3] = (short)(this.mismatches[n3] + n2);
        }
    }
}

