/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.BlockContentType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class Block {
    public BlockCompressionMethod method;
    public BlockContentType contentType;
    public int contentId;
    private int compressedContentSize;
    private int rawContentSize;
    private byte[] rawContent;
    private byte[] compressedContent;

    public Block() {
    }

    public Block(BlockCompressionMethod blockCompressionMethod, BlockContentType blockContentType, int n, byte[] byArray, byte[] byArray2) {
        this.method = blockCompressionMethod;
        this.contentType = blockContentType;
        this.contentId = n;
        if (byArray != null) {
            this.setRawContent(byArray);
        }
        if (byArray2 != null) {
            this.setCompressedContent(byArray2);
        }
    }

    public Block(InputStream inputStream, boolean bl, boolean bl2) throws IOException {
        this.method = BlockCompressionMethod.values()[inputStream.read()];
        int n = inputStream.read();
        this.contentType = BlockContentType.values()[n];
        this.contentId = ByteBufferUtils.readUnsignedITF8(inputStream);
        this.compressedContentSize = ByteBufferUtils.readUnsignedITF8(inputStream);
        this.rawContentSize = ByteBufferUtils.readUnsignedITF8(inputStream);
        if (bl) {
            this.compressedContent = new byte[this.compressedContentSize];
            ByteBufferUtils.readFully(this.compressedContent, inputStream);
            if (bl2) {
                this.uncompress();
            }
        }
    }

    public String toString() {
        String string = this.rawContent == null ? "NULL" : Arrays.toString(Arrays.copyOf(this.rawContent, 20));
        String string2 = this.compressedContent == null ? "NULL" : Arrays.toString(Arrays.copyOf(this.compressedContent, 20));
        return String.format("method=%d, type=%s, id=%d, raw size=%d, compressed size=%d, raw=%s, comp=%s.", new Object[]{this.method, this.contentType.name(), this.contentId, this.rawContentSize, this.compressedContentSize, string, string2});
    }

    public boolean isCompressed() {
        return this.compressedContent != null;
    }

    public boolean isUncompressed() {
        return this.rawContent != null;
    }

    public void setRawContent(byte[] byArray) {
        this.rawContent = byArray;
        this.rawContentSize = byArray == null ? 0 : byArray.length;
        this.compressedContent = null;
        this.compressedContentSize = 0;
    }

    public byte[] getRawContent() {
        if (this.rawContent == null) {
            this.uncompress();
        }
        return this.rawContent;
    }

    public int getRawContentSize() {
        return this.rawContentSize;
    }

    public void setCompressedContent(byte[] byArray) {
        this.compressedContent = byArray;
        this.compressedContentSize = byArray == null ? 0 : byArray.length;
        this.rawContent = null;
        this.rawContentSize = 0;
    }

    public byte[] getCompressedContent() {
        if (this.compressedContent == null) {
            this.compress();
        }
        return this.compressedContent;
    }

    public void compress() {
        if (this.compressedContent != null || this.rawContent == null) {
            return;
        }
        switch (this.method) {
            case RAW: {
                this.compressedContent = this.rawContent;
                this.compressedContentSize = this.rawContentSize;
                break;
            }
            case GZIP: {
                try {
                    this.compressedContent = ByteBufferUtils.gzip(this.rawContent);
                }
                catch (IOException iOException) {
                    throw new RuntimeException("This should have never happned.", iOException);
                }
                this.compressedContentSize = this.compressedContent.length;
                break;
            }
        }
    }

    public void uncompress() {
        if (this.rawContent != null || this.compressedContent == null) {
            return;
        }
        switch (this.method) {
            case RAW: {
                this.rawContent = this.compressedContent;
                this.rawContentSize = this.compressedContentSize;
                break;
            }
            case GZIP: {
                try {
                    this.rawContent = ByteBufferUtils.gunzip(this.compressedContent);
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException("This should have never happned.", iOException);
                }
            }
            default: {
                throw new RuntimeException("Unknown block compression method: " + this.method.name());
            }
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        if (!this.isCompressed()) {
            this.compress();
        }
        if (!this.isUncompressed()) {
            this.uncompress();
        }
        outputStream.write(this.method.ordinal());
        outputStream.write(this.contentType.ordinal());
        outputStream.write(this.contentId);
        ByteBufferUtils.writeUnsignedITF8(this.compressedContentSize, outputStream);
        ByteBufferUtils.writeUnsignedITF8(this.rawContentSize, outputStream);
        outputStream.write(this.getCompressedContent());
    }
}

