/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.common.NullOutputStream;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.structure.Container;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ContainerHeaderIO {
    public boolean readContainerHeader(Container container, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = inputStream.read();
        if (n == -1) {
            return false;
        }
        byArray[0] = (byte)n;
        for (int i = 1; i < byArray.length; ++i) {
            n = inputStream.read();
            if (n == -1) {
                throw new RuntimeException("Incomplete or broken stream.");
            }
            byArray[i] = (byte)n;
        }
        container.containerByteSize = ByteBufferUtils.int32(byArray);
        container.sequenceId = ByteBufferUtils.readUnsignedITF8(inputStream);
        container.alignmentStart = ByteBufferUtils.readUnsignedITF8(inputStream);
        container.alignmentSpan = ByteBufferUtils.readUnsignedITF8(inputStream);
        container.nofRecords = ByteBufferUtils.readUnsignedITF8(inputStream);
        container.globalRecordCounter = ByteBufferUtils.readUnsignedLTF8(inputStream);
        container.bases = ByteBufferUtils.readUnsignedLTF8(inputStream);
        container.blockCount = ByteBufferUtils.readUnsignedITF8(inputStream);
        container.landmarks = ByteBufferUtils.array(inputStream);
        return true;
    }

    public int writeContainerHeader(Container container, OutputStream outputStream) throws IOException {
        int n = ByteBufferUtils.writeInt32(container.containerByteSize, outputStream);
        n += ByteBufferUtils.writeUnsignedITF8(container.sequenceId, outputStream);
        n += ByteBufferUtils.writeUnsignedITF8(container.alignmentStart, outputStream);
        n += ByteBufferUtils.writeUnsignedITF8(container.alignmentSpan, outputStream);
        n += ByteBufferUtils.writeUnsignedITF8(container.nofRecords, outputStream);
        n += ByteBufferUtils.writeUnsignedLTF8(container.globalRecordCounter, outputStream);
        n += ByteBufferUtils.writeUnsignedLTF8(container.bases, outputStream);
        n += ByteBufferUtils.writeUnsignedITF8(container.blockCount, outputStream);
        return n += ByteBufferUtils.write(container.landmarks, outputStream);
    }

    public int sizeOfContainerHeader(Container container) throws IOException {
        NullOutputStream nullOutputStream = new NullOutputStream();
        return this.writeContainerHeader(container, nullOutputStream);
    }
}

