/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;

public class Slice {
    public static final int UNMAPPED_OR_NOREF = -1;
    public static final int MUTLIREF = -2;
    private static final Log log = Log.getInstance(Slice.class);
    public int sequenceId = -1;
    public int alignmentStart = -1;
    public int alignmentSpan = -1;
    public int nofRecords = -1;
    public long globalRecordCounter = -1L;
    public int nofBlocks = -1;
    public int[] contentIDs;
    public int embeddedRefBlockContentID = -1;
    public byte[] refMD5;
    public Block headerBlock;
    public BlockContentType contentType;
    public Block coreBlock;
    public Block embeddedRefBlock;
    public Map<Integer, Block> external;
    public int offset = -1;
    public long containerOffset = -1L;
    public int size = -1;
    public int index = -1;
    public long bases;
    private static final int shoulder = 10;

    private boolean alignmentBordersSanityCheck(byte[] byArray) {
        if (this.alignmentStart > 0 && this.sequenceId >= 0 && byArray == null) {
            throw new NullPointerException("Mapped slice reference is null.");
        }
        if (this.alignmentStart > byArray.length) {
            log.error(String.format("Slice mapped outside of reference: seqid=%d, alstart=%d, counter=%d.", this.sequenceId, this.alignmentStart, this.globalRecordCounter));
            throw new RuntimeException("Slice mapped outside of the reference.");
        }
        if (this.alignmentStart - 1 + this.alignmentSpan > byArray.length) {
            log.warn(String.format("Slice partially mapped outside of reference: seqid=%d, alstart=%d, alspan=%d, counter=%d.", this.sequenceId, this.alignmentStart, this.alignmentSpan, this.globalRecordCounter));
            return false;
        }
        return true;
    }

    public boolean validateRefMD5(byte[] byArray) throws NoSuchAlgorithmException {
        this.alignmentBordersSanityCheck(byArray);
        if (!Slice.validateRefMD5(byArray, this.alignmentStart, this.alignmentSpan, this.refMD5)) {
            String string = Slice.getBrief(this.alignmentStart, this.alignmentSpan, byArray, 10, null);
            if (Slice.validateRefMD5(byArray, this.alignmentStart, this.alignmentSpan - 1, this.refMD5)) {
                log.warn(String.format("Reference MD5 matches partially for slice %d:%d-%d, %s", this.sequenceId, this.alignmentStart, this.alignmentStart + this.alignmentSpan - 1, string));
                return true;
            }
            log.error(String.format("Reference MD5 mismatch for slice %d:%d-%d, %s", this.sequenceId, this.alignmentStart, this.alignmentStart + this.alignmentSpan - 1, string));
            return false;
        }
        return true;
    }

    private static boolean validateRefMD5(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = Math.min(n2, byArray.length - n + 1);
        String string = SequenceUtil.calculateMD5String(byArray, n - 1, n3);
        return string.equals(String.format("%032x", new BigInteger(1, byArray2)));
    }

    private static String getBrief(int n, int n2, byte[] byArray, int n3, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        int n4 = n - 1;
        int n5 = n + n2 - 1;
        if ((n5 = Math.min(n5, byArray.length)) - n4 <= 2 * n3) {
            stringBuffer.append(new String(Arrays.copyOfRange(byArray, n4, n5)));
        } else {
            stringBuffer.append(new String(Arrays.copyOfRange(byArray, n4, n4 + n3)));
            stringBuffer.append("...");
            stringBuffer.append(new String(Arrays.copyOfRange(byArray, n5 - n3, n5)));
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = "0123456789";
        byte[] byArray = string.getBytes();
        String string2 = "start %d, span %d, shoulder %d:\t";
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        StringBuffer stringBuffer = new StringBuffer(String.format(string2, n, n2, n3));
        Slice.getBrief(n, n2, byArray, n3, stringBuffer);
        System.out.println(stringBuffer.toString());
        n = 1;
        n2 = 11;
        n3 = 1;
        stringBuffer = new StringBuffer(String.format(string2, n, n2, n3));
        Slice.getBrief(n, n2, byArray, n3, stringBuffer);
        System.out.println(stringBuffer.toString());
        n = 1;
        n2 = 10;
        n3 = 10;
        stringBuffer = new StringBuffer(String.format(string2, n, n2, n3));
        Slice.getBrief(n, n2, byArray, n3, stringBuffer);
        System.out.println(stringBuffer.toString());
        n = 2;
        n2 = 1;
        n3 = 1;
        stringBuffer = new StringBuffer(String.format(string2, n, n2, n3));
        Slice.getBrief(n, n2, byArray, n3, stringBuffer);
        System.out.println(stringBuffer.toString());
        n = 2;
        n2 = 11;
        n3 = 1;
        stringBuffer = new StringBuffer(String.format(string2, n, n2, n3));
        Slice.getBrief(n, n2, byArray, n3, stringBuffer);
        System.out.println(stringBuffer.toString());
        n = 2;
        n2 = 10;
        n3 = 10;
        stringBuffer = new StringBuffer(String.format(string2, n, n2, n3));
        Slice.getBrief(n, n2, byArray, n3, stringBuffer);
        System.out.println(stringBuffer.toString());
        n = 2;
        n2 = 2;
        n3 = 2;
        stringBuffer = new StringBuffer(String.format(string2, n, n2, n3));
        Slice.getBrief(n, n2, byArray, n3, stringBuffer);
        System.out.println(stringBuffer.toString());
        n = 2;
        n2 = 4;
        n3 = 2;
        stringBuffer = new StringBuffer(String.format(string2, n, n2, n3));
        Slice.getBrief(n, n2, byArray, n3, stringBuffer);
        System.out.println(stringBuffer.toString());
        n = 2;
        n2 = 5;
        n3 = 2;
        stringBuffer = new StringBuffer(String.format(string2, n, n2, n3));
        Slice.getBrief(n, n2, byArray, n3, stringBuffer);
        System.out.println(stringBuffer.toString());
        n = 2;
        n2 = 10;
        n3 = 4;
        stringBuffer = new StringBuffer(String.format(string2, n, n2, n3));
        Slice.getBrief(n, n2, byArray, n3, stringBuffer);
        System.out.println(stringBuffer.toString());
        n = 2;
        n2 = 10;
        n3 = 5;
        stringBuffer = new StringBuffer(String.format(string2, n, n2, n3));
        Slice.getBrief(n, n2, byArray, n3, stringBuffer);
        System.out.println(stringBuffer.toString());
        n = 2;
        n2 = 10;
        n3 = 6;
        stringBuffer = new StringBuffer(String.format(string2, n, n2, n3));
        Slice.getBrief(n, n2, byArray, n3, stringBuffer);
        System.out.println(stringBuffer.toString());
    }

    public void setRefMD5(byte[] byArray) {
        this.alignmentBordersSanityCheck(byArray);
        if (this.sequenceId < 0 && this.alignmentStart < 1) {
            this.refMD5 = new byte[16];
            Arrays.fill(this.refMD5, (byte)0);
            log.debug("Empty slice ref md5 is set.");
        } else {
            int n = Math.min(this.alignmentSpan, byArray.length - this.alignmentStart + 1);
            if (this.alignmentStart + n > byArray.length + 1) {
                throw new RuntimeException("Invalid alignment boundaries.");
            }
            this.refMD5 = SequenceUtil.calculateMD5(byArray, this.alignmentStart - 1, n);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 10;
            stringBuffer.append(new String(Arrays.copyOfRange(byArray, this.alignmentStart - 1, this.alignmentStart + n2)));
            stringBuffer.append("...");
            stringBuffer.append(new String(Arrays.copyOfRange(byArray, this.alignmentStart - 1 + n - n2, this.alignmentStart + n)));
            log.debug(String.format("Slice md5: %s for %d:%d-%d, %s", String.format("%032x", new BigInteger(1, this.refMD5)), this.sequenceId, this.alignmentStart, this.alignmentStart + n - 1, stringBuffer.toString()));
        }
    }
}

