/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.io.BitwiseUtils;
import htsjdk.samtools.util.Log;
import java.util.Arrays;
import java.util.Comparator;

public class SubstitutionMatrix {
    public static final byte[] BASES = new byte[]{65, 67, 71, 84, 78};
    public static final byte[] BASES_LC = new byte[]{97, 99, 103, 116, 110};
    public static final byte[] ORDER = new byte[255];
    private static Log log;
    private byte[] bytes = new byte[5];
    private byte[][] codes = new byte[255][255];
    private byte[][] bases = new byte[255][255];
    private static Comparator<SubCode> comparator;

    public SubstitutionMatrix(long[][] lArray) {
        int n;
        for (n = 0; n < BASES.length; ++n) {
            this.bytes[SubstitutionMatrix.ORDER[SubstitutionMatrix.BASES[n]]] = this.rank(BASES[n], lArray[BASES[n]]);
        }
        for (n = 0; n < this.bases.length; ++n) {
            Arrays.fill(this.bases[n], (byte)78);
        }
        for (n = 0; n < BASES.length; ++n) {
            byte by = BASES[n];
            for (byte by2 : BASES) {
                if (by == by2) continue;
                this.bases[by][this.codes[by][by2]] = by2;
                this.bases[SubstitutionMatrix.BASES_LC[n]][this.codes[by][by2]] = by2;
            }
        }
        this.dump();
    }

    public void dump() {
        log.debug("Subs matrix: " + Arrays.toString(this.bytes) + ": " + BitwiseUtils.toBitString(this.bytes));
        StringBuffer stringBuffer = new StringBuffer("Subs matrix decoded: ");
        for (byte by : "ACGTN".getBytes()) {
            stringBuffer.append((char)by);
            stringBuffer.append(":");
            for (int i = 0; i < 4; ++i) {
                stringBuffer.append((char)this.bases[by][i]);
            }
            stringBuffer.append("\t");
        }
        log.debug(stringBuffer.toString());
    }

    public SubstitutionMatrix(byte[] byArray) {
        int n;
        this.bytes = byArray;
        for (n = 0; n < this.bases.length; ++n) {
            Arrays.fill(this.bases[n], (byte)78);
        }
        this.bases[65][this.bytes[0] >> 6 & 3] = 67;
        this.bases[65][this.bytes[0] >> 4 & 3] = 71;
        this.bases[65][this.bytes[0] >> 2 & 3] = 84;
        this.bases[65][this.bytes[0] >> 0 & 3] = 78;
        for (n = 0; n < 4; ++n) {
            this.bases[97][n] = this.bases[65][n];
        }
        this.bases[67][this.bytes[1] >> 6 & 3] = 65;
        this.bases[67][this.bytes[1] >> 4 & 3] = 71;
        this.bases[67][this.bytes[1] >> 2 & 3] = 84;
        this.bases[67][this.bytes[1] >> 0 & 3] = 78;
        for (n = 0; n < 4; ++n) {
            this.bases[99][n] = this.bases[67][n];
        }
        this.bases[71][this.bytes[2] >> 6 & 3] = 65;
        this.bases[71][this.bytes[2] >> 4 & 3] = 67;
        this.bases[71][this.bytes[2] >> 2 & 3] = 84;
        this.bases[71][this.bytes[2] >> 0 & 3] = 78;
        for (n = 0; n < 4; ++n) {
            this.bases[103][n] = this.bases[71][n];
        }
        this.bases[84][this.bytes[3] >> 6 & 3] = 65;
        this.bases[84][this.bytes[3] >> 4 & 3] = 67;
        this.bases[84][this.bytes[3] >> 2 & 3] = 71;
        this.bases[84][this.bytes[3] >> 0 & 3] = 78;
        for (n = 0; n < 4; ++n) {
            this.bases[116][n] = this.bases[84][n];
        }
        this.bases[78][this.bytes[4] >> 6 & 3] = 65;
        this.bases[78][this.bytes[4] >> 4 & 3] = 67;
        this.bases[78][this.bytes[4] >> 2 & 3] = 71;
        this.bases[78][this.bytes[4] >> 0 & 3] = 84;
        for (byte by : BASES) {
            for (int n2 = 0; n2 < 4; n2 = (int)((byte)(n2 + 1))) {
                this.codes[by][this.bases[by][n2]] = n2;
            }
        }
        this.dump();
    }

    public byte[] getEncodedMatrix() {
        return this.bytes;
    }

    private byte rank(byte by, long[] lArray) {
        SubCode[] subCodeArray = new SubCode[4];
        byte by2 = 0;
        for (byte by3 : BASES) {
            if (by == by3) continue;
            subCodeArray[by2++] = new SubCode(by, by3, lArray[by3]);
        }
        Arrays.sort(subCodeArray, comparator);
        for (by2 = 0; by2 < subCodeArray.length; by2 = (byte)((byte)(by2 + 1))) {
            subCodeArray[by2].rank = by2;
        }
        for (by2 = 0; by2 < subCodeArray.length; by2 = (byte)((byte)(by2 + 1))) {
            subCodeArray[by2].freq = 0L;
        }
        Arrays.sort(subCodeArray, comparator);
        by2 = 0;
        for (int n = 0; n < subCodeArray.length; n = (int)((byte)(n + 1))) {
            by2 = (byte)(by2 << 2);
            by2 = (byte)(by2 | subCodeArray[n].rank);
        }
        for (SubCode subCode : subCodeArray) {
            this.codes[by][subCode.base] = subCode.rank;
        }
        return by2;
    }

    public byte code(byte by, byte by2) {
        return this.codes[by][by2];
    }

    public byte base(byte by, byte by2) {
        byte by3 = this.bases[by][by2];
        return by3;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        void var5_9;
        int n;
        SubstitutionMatrix substitutionMatrix = new SubstitutionMatrix(new byte[]{27, -28, 27, 27, 27});
        byte[] object = BASES;
        int n2 = object.length;
        for (n = 0; n < n2; ++n) {
            byte by = object[n];
            for (byte by2 : BASES) {
                if (by == by2) continue;
                System.out.printf("Ref=%c, base=%c, code=%d\n", Character.valueOf((char)by), Character.valueOf((char)by2), substitutionMatrix.code(by, by2));
            }
        }
        System.out.println(Arrays.toString(substitutionMatrix.bytes));
        System.out.println("===============================================");
        long[][] lArray = new long[255][255];
        for (n2 = 0; n2 < BASES.length; ++n2) {
            for (n = 0; n < BASES.length; ++n) {
                if (n2 == n) continue;
                lArray[SubstitutionMatrix.BASES[n2]][SubstitutionMatrix.BASES[n]] = n;
            }
        }
        substitutionMatrix = new SubstitutionMatrix(lArray);
        byte[] byArray = BASES;
        n = byArray.length;
        boolean bl = false;
        while (var5_9 < n) {
            byte by = byArray[var5_9];
            for (byte by3 : BASES) {
                if (by == by3) continue;
                System.out.printf("Ref=%c, base=%c, code=%d\n", Character.valueOf((char)by), Character.valueOf((char)by3), substitutionMatrix.code(by, by3));
            }
            ++var5_9;
        }
        System.out.println(Arrays.toString(substitutionMatrix.bytes));
    }

    static {
        Arrays.fill(ORDER, (byte)-1);
        SubstitutionMatrix.ORDER[65] = 0;
        SubstitutionMatrix.ORDER[67] = 1;
        SubstitutionMatrix.ORDER[71] = 2;
        SubstitutionMatrix.ORDER[84] = 3;
        SubstitutionMatrix.ORDER[78] = 4;
        log = Log.getInstance(SubstitutionMatrix.class);
        comparator = new Comparator<SubCode>(){

            @Override
            public int compare(SubCode subCode, SubCode subCode2) {
                if (subCode.freq != subCode2.freq) {
                    return (int)(subCode2.freq - subCode.freq);
                }
                return ORDER[subCode.base] - ORDER[subCode2.base];
            }
        };
    }

    private static class SubCode {
        byte ref;
        byte base;
        long freq;
        byte rank;
        byte code;

        public SubCode(byte by, byte by2, long l) {
            this.ref = by;
            this.base = by2;
            this.freq = l;
        }
    }
}

