/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.filter.IntervalFilter;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Interval;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SamRecordIntervalIteratorFactory {
    public CloseableIterator<SAMRecord> makeSamRecordIntervalIterator(SamReader samReader, List<Interval> list, boolean bl) {
        if (!samReader.hasIndex() || !bl) {
            Object object;
            int n;
            int n2;
            if (list.isEmpty()) {
                n2 = -1;
                n = -1;
            } else {
                object = list.get(list.size() - 1);
                n2 = samReader.getFileHeader().getSequenceIndex(((Interval)object).getSequence());
                n = ((Interval)object).getEnd();
            }
            object = new IntervalFilter(list, samReader.getFileHeader());
            return new StopAfterFilteringIterator(samReader.iterator(), (SamRecordFilter)object, n2, n);
        }
        QueryInterval[] queryIntervalArray = new QueryInterval[list.size()];
        for (int i = 0; i < queryIntervalArray.length; ++i) {
            Interval interval = list.get(i);
            queryIntervalArray[i] = new QueryInterval(samReader.getFileHeader().getSequenceIndex(interval.getSequence()), interval.getStart(), interval.getEnd());
        }
        return samReader.queryOverlapping(queryIntervalArray);
    }

    private class StopAfterFilteringIterator
    implements CloseableIterator<SAMRecord> {
        private final int stopAfterSequence;
        private final int stopAfterPosition;
        private final Iterator<SAMRecord> iterator;
        private final SamRecordFilter filter;
        private SAMRecord next = null;

        private StopAfterFilteringIterator(Iterator<SAMRecord> iterator, SamRecordFilter samRecordFilter, int n, int n2) {
            this.stopAfterSequence = n;
            this.stopAfterPosition = n2;
            this.iterator = iterator;
            this.filter = samRecordFilter;
            this.next = this.getNextRecord();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public SAMRecord next() {
            if (this.next == null) {
                throw new NoSuchElementException("Iterator has no more elements.");
            }
            SAMRecord sAMRecord = this.next;
            this.next = this.getNextRecord();
            return sAMRecord;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove() not supported by FilteringIterator");
        }

        @Override
        public void close() {
            CloserUtil.close(this.iterator);
        }

        protected SAMRecord getNextRecord() {
            while (this.iterator.hasNext()) {
                SAMRecord sAMRecord = this.iterator.next();
                if (sAMRecord.getReferenceIndex() == -1) {
                    return null;
                }
                if (sAMRecord.getReferenceIndex() > this.stopAfterSequence) {
                    return null;
                }
                if (sAMRecord.getReferenceIndex() == this.stopAfterSequence && sAMRecord.getAlignmentStart() > this.stopAfterPosition) {
                    return null;
                }
                if (this.filter.filterOut(sAMRecord)) continue;
                return sAMRecord;
            }
            return null;
        }
    }
}

