/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.SnappyLoader;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class TempStreamFactory {
    private static SnappyLoader snappyLoader = null;

    private static synchronized SnappyLoader getSnappyLoader() {
        if (snappyLoader == null) {
            snappyLoader = new SnappyLoader();
        }
        return snappyLoader;
    }

    public InputStream wrapTempInputStream(InputStream inputStream, int n) {
        InputStream inputStream2 = IOUtil.maybeBufferInputStream(inputStream, n);
        if (TempStreamFactory.getSnappyLoader().SnappyAvailable) {
            try {
                return TempStreamFactory.getSnappyLoader().wrapInputStream(inputStream2);
            }
            catch (Exception exception) {
                throw new SAMException("Error creating SnappyInputStream", exception);
            }
        }
        return inputStream2;
    }

    public OutputStream wrapTempOutputStream(OutputStream outputStream, int n) {
        OutputStream outputStream2 = outputStream;
        if (n > 0) {
            outputStream2 = new BufferedOutputStream(outputStream2, n);
        }
        if (TempStreamFactory.getSnappyLoader().SnappyAvailable) {
            try {
                outputStream2 = TempStreamFactory.getSnappyLoader().wrapOutputStream(outputStream2);
            }
            catch (Exception exception) {
                throw new SAMException("Error creating SnappyOutputStream", exception);
            }
        }
        return outputStream2;
    }
}

