/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.tabix;

import htsjdk.samtools.Bin;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.StringUtil;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.Block;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.util.LittleEndianInputStream;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TabixIndex
implements Index {
    private static final byte[] MAGIC = new byte[]{84, 66, 73, 1};
    public static final int MAGIC_NUMBER;
    private final TabixFormat formatSpec;
    private final List<String> sequenceNames;
    private final BinningIndexContent[] indices;

    public TabixIndex(TabixFormat tabixFormat, List<String> list, BinningIndexContent[] binningIndexContentArray) {
        if (list.size() != binningIndexContentArray.length) {
            throw new IllegalArgumentException("sequenceNames.size() != indices.length");
        }
        this.formatSpec = tabixFormat.clone();
        this.sequenceNames = Collections.unmodifiableList(new ArrayList<String>(list));
        this.indices = binningIndexContentArray;
    }

    public TabixIndex(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public TabixIndex(File file) throws IOException {
        this(new BlockCompressedInputStream(file), true);
    }

    private TabixIndex(InputStream inputStream, boolean bl) throws IOException {
        int n;
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(inputStream);
        if (littleEndianInputStream.readInt() != MAGIC_NUMBER) {
            throw new TribbleException(String.format("Unexpected magic number 0x%x", MAGIC_NUMBER));
        }
        int n2 = littleEndianInputStream.readInt();
        this.indices = new BinningIndexContent[n2];
        this.formatSpec = new TabixFormat();
        this.formatSpec.flags = littleEndianInputStream.readInt();
        this.formatSpec.sequenceColumn = littleEndianInputStream.readInt();
        this.formatSpec.startPositionColumn = littleEndianInputStream.readInt();
        this.formatSpec.endPositionColumn = littleEndianInputStream.readInt();
        this.formatSpec.metaCharacter = (char)littleEndianInputStream.readInt();
        this.formatSpec.numHeaderLinesToSkip = littleEndianInputStream.readInt();
        int n3 = littleEndianInputStream.readInt();
        byte[] byArray = new byte[n3];
        if (littleEndianInputStream.read(byArray) != n3) {
            throw new EOFException("Premature end of file reading Tabix header");
        }
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            int n5 = n4;
            while (byArray[n5] != 0) {
                ++n5;
            }
            arrayList.add(StringUtil.bytesToString(byArray, n4, n5 - n4));
            n4 = n5 + 1;
        }
        if (n4 != n3) {
            throw new TribbleException("Tabix header format exception.  Sequence name block is longer than expected");
        }
        for (n = 0; n < n2; ++n) {
            this.indices[n] = this.loadSequence(n, littleEndianInputStream);
        }
        if (bl) {
            CloserUtil.close(littleEndianInputStream);
        }
        this.sequenceNames = Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<Block> getBlocks(String string, int n, int n2) {
        int n3 = this.sequenceNames.indexOf(string);
        if (n3 == -1 || this.indices[n3] == null) {
            return Collections.emptyList();
        }
        List<Chunk> list = this.indices[n3].getChunksOverlapping(n, n2);
        ArrayList<Block> arrayList = new ArrayList<Block>(list.size());
        for (Chunk chunk : list) {
            arrayList.add(new Block(chunk.getChunkStart(), chunk.getChunkEnd() - chunk.getChunkStart()));
        }
        return arrayList;
    }

    @Override
    public boolean isCurrentVersion() {
        return true;
    }

    @Override
    public List<String> getSequenceNames() {
        return this.sequenceNames;
    }

    @Override
    public boolean containsChromosome(String string) {
        return this.sequenceNames.contains(string);
    }

    @Override
    public Map<String, String> getProperties() {
        return null;
    }

    @Override
    public boolean equalsIgnoreProperties(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TabixIndex tabixIndex = (TabixIndex)object;
        if (!this.formatSpec.equals(tabixIndex.formatSpec)) {
            return false;
        }
        if (!Arrays.equals(this.indices, tabixIndex.indices)) {
            return false;
        }
        return ((Object)this.sequenceNames).equals(tabixIndex.sequenceNames);
    }

    public TabixFormat getFormatSpec() {
        return this.formatSpec;
    }

    public void write(File file) {
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(new BlockCompressedOutputStream(file));
        try {
            this.write(littleEndianOutputStream);
            littleEndianOutputStream.close();
        }
        catch (IOException iOException) {
            throw new TribbleException("Exception writing " + file.getAbsolutePath(), iOException);
        }
    }

    @Override
    public void writeBasedOnFeatureFile(File file) throws IOException {
        if (!file.isFile()) {
            return;
        }
        this.write(new File(file.getAbsolutePath() + ".tbi"));
    }

    @Override
    public void write(LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        littleEndianOutputStream.writeInt(MAGIC_NUMBER);
        littleEndianOutputStream.writeInt(this.sequenceNames.size());
        littleEndianOutputStream.writeInt(this.formatSpec.flags);
        littleEndianOutputStream.writeInt(this.formatSpec.sequenceColumn);
        littleEndianOutputStream.writeInt(this.formatSpec.startPositionColumn);
        littleEndianOutputStream.writeInt(this.formatSpec.endPositionColumn);
        littleEndianOutputStream.writeInt(this.formatSpec.metaCharacter);
        littleEndianOutputStream.writeInt(this.formatSpec.numHeaderLinesToSkip);
        int n = this.sequenceNames.size();
        for (String string : this.sequenceNames) {
            n += string.length();
        }
        littleEndianOutputStream.writeInt(n);
        for (String string : this.sequenceNames) {
            littleEndianOutputStream.write(StringUtil.stringToBytes(string));
            littleEndianOutputStream.write(0);
        }
        for (BinningIndexContent binningIndexContent : this.indices) {
            this.writeSequence(binningIndexContent, littleEndianOutputStream);
        }
    }

    private void writeSequence(BinningIndexContent binningIndexContent, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        if (binningIndexContent == null) {
            littleEndianOutputStream.writeInt(0);
        } else {
            BinningIndexContent.BinList binList = binningIndexContent.getBins();
            littleEndianOutputStream.writeInt(binList.numberOfNonNullBins);
            for (Bin bin : binList) {
                this.writeBin(bin, littleEndianOutputStream);
            }
            this.writeLinearIndex(binningIndexContent.getLinearIndex(), littleEndianOutputStream);
        }
    }

    private void writeLinearIndex(LinearIndex linearIndex, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        if (linearIndex.getIndexStart() != 0) {
            throw new IllegalArgumentException("Non-zero linear index start");
        }
        long[] lArray = linearIndex.getIndexEntries();
        littleEndianOutputStream.writeInt(lArray.length);
        for (long l : lArray) {
            littleEndianOutputStream.writeLong(l);
        }
    }

    private void writeBin(Bin bin, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        littleEndianOutputStream.writeInt(bin.getBinNumber());
        List<Chunk> list = bin.getChunkList();
        littleEndianOutputStream.writeInt(list.size());
        for (Chunk chunk : list) {
            littleEndianOutputStream.writeLong(chunk.getChunkStart());
            littleEndianOutputStream.writeLong(chunk.getChunkEnd());
        }
    }

    private BinningIndexContent loadSequence(int n, LittleEndianInputStream littleEndianInputStream) throws IOException {
        int n2 = littleEndianInputStream.readInt();
        if (n2 == 0) {
            return null;
        }
        int n3 = 0;
        ArrayList<Bin> arrayList = new ArrayList<Bin>();
        for (int i = 0; i < n2; ++i) {
            Bin bin = this.loadBin(n, littleEndianInputStream);
            if (bin == null) continue;
            ++n3;
            if (arrayList.size() > bin.getBinNumber()) {
                if (arrayList.get(bin.getBinNumber()) != null) {
                    throw new TribbleException("Bin " + bin.getBinNumber() + " appears more than once in file");
                }
                arrayList.set(bin.getBinNumber(), bin);
                continue;
            }
            arrayList.ensureCapacity(bin.getBinNumber() + 1);
            while (arrayList.size() < bin.getBinNumber()) {
                arrayList.add(null);
            }
            arrayList.add(bin);
        }
        LinearIndex linearIndex = this.loadLinearIndex(n, littleEndianInputStream);
        return new BinningIndexContent(n, new BinningIndexContent.BinList(arrayList.toArray(new Bin[arrayList.size()]), n3), linearIndex);
    }

    private LinearIndex loadLinearIndex(int n, LittleEndianInputStream littleEndianInputStream) throws IOException {
        int n2 = littleEndianInputStream.readInt();
        long[] lArray = new long[n2];
        for (int i = 0; i < n2; ++i) {
            lArray[i] = littleEndianInputStream.readLong();
        }
        return new LinearIndex(n, 0, lArray);
    }

    private Bin loadBin(int n, LittleEndianInputStream littleEndianInputStream) throws IOException {
        int n2 = littleEndianInputStream.readInt();
        Bin bin = new Bin(n, n2);
        int n3 = littleEndianInputStream.readInt();
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>(n3);
        for (int i = 0; i < n3; ++i) {
            arrayList.add(this.loadChunk(littleEndianInputStream));
        }
        bin.setChunkList(arrayList);
        return bin;
    }

    private Chunk loadChunk(LittleEndianInputStream littleEndianInputStream) throws IOException {
        long l = littleEndianInputStream.readLong();
        long l2 = littleEndianInputStream.readLong();
        return new Chunk(l, l2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TabixIndex tabixIndex = (TabixIndex)object;
        if (!this.formatSpec.equals(tabixIndex.formatSpec)) {
            return false;
        }
        if (!Arrays.equals(this.indices, tabixIndex.indices)) {
            return false;
        }
        return ((Object)this.sequenceNames).equals(tabixIndex.sequenceNames);
    }

    public int hashCode() {
        int n = this.formatSpec.hashCode();
        n = 31 * n + ((Object)this.sequenceNames).hashCode();
        n = 31 * n + Arrays.hashCode(this.indices);
        return n;
    }

    static {
        ByteBuffer byteBuffer = ByteBuffer.allocate(MAGIC.length);
        byteBuffer.put(MAGIC);
        byteBuffer.flip();
        MAGIC_NUMBER = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getInt();
    }
}

