/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.tribble.util.ParsingUtils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.GenotypeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.TreeSet;

public abstract class Genotype
implements Comparable<Genotype> {
    public static final Collection<String> PRIMARY_KEYS = Arrays.asList("FT", "GT", "GQ", "DP", "AD", "PL");
    public static final String PHASED_ALLELE_SEPARATOR = "|";
    public static final String UNPHASED_ALLELE_SEPARATOR = "/";
    private final String sampleName;
    private GenotypeType type = null;
    private final String filters;

    protected Genotype(String string, String string2) {
        this.sampleName = string;
        this.filters = string2;
    }

    public abstract List<Allele> getAlleles();

    public int countAllele(Allele allele) {
        int n = 0;
        for (Allele allele2 : this.getAlleles()) {
            if (!allele2.equals(allele)) continue;
            ++n;
        }
        return n;
    }

    public abstract Allele getAllele(int var1);

    public abstract boolean isPhased();

    public int getPloidy() {
        return this.getAlleles().size();
    }

    public abstract int getDP();

    public abstract int[] getAD();

    public String getSampleName() {
        return this.sampleName;
    }

    public abstract int getGQ();

    public boolean hasPL() {
        return this.getPL() != null;
    }

    public boolean hasAD() {
        return this.getAD() != null;
    }

    public boolean hasGQ() {
        return this.getGQ() != -1;
    }

    public boolean hasDP() {
        return this.getDP() != -1;
    }

    public GenotypeType getType() {
        if (this.type == null) {
            this.type = this.determineType();
        }
        return this.type;
    }

    protected GenotypeType determineType() {
        List<Allele> list = this.getAlleles();
        if (list.isEmpty()) {
            return GenotypeType.UNAVAILABLE;
        }
        boolean bl = false;
        boolean bl2 = false;
        Allele allele = null;
        for (Allele allele2 : list) {
            if (allele2.isNoCall()) {
                bl = true;
                continue;
            }
            if (allele == null) {
                allele = allele2;
                continue;
            }
            if (allele2.equals(allele)) continue;
            bl2 = true;
        }
        if (bl) {
            if (allele == null) {
                return GenotypeType.NO_CALL;
            }
            return GenotypeType.MIXED;
        }
        if (allele == null) {
            throw new IllegalStateException("BUG: there are no alleles present in this genotype but the alleles list is not null");
        }
        return bl2 ? GenotypeType.HET : (allele.isReference() ? GenotypeType.HOM_REF : GenotypeType.HOM_VAR);
    }

    public boolean isHom() {
        return this.isHomRef() || this.isHomVar();
    }

    public boolean isHomRef() {
        return this.getType() == GenotypeType.HOM_REF;
    }

    public boolean isHomVar() {
        return this.getType() == GenotypeType.HOM_VAR;
    }

    public boolean isHet() {
        return this.getType() == GenotypeType.HET;
    }

    public boolean isHetNonRef() {
        return this.getType() == GenotypeType.HET && this.getAllele(0).isNonReference() && this.getAllele(1).isNonReference();
    }

    public boolean isNoCall() {
        return this.getType() == GenotypeType.NO_CALL;
    }

    public boolean isCalled() {
        return this.getType() != GenotypeType.NO_CALL && this.getType() != GenotypeType.UNAVAILABLE;
    }

    public boolean isMixed() {
        return this.getType() == GenotypeType.MIXED;
    }

    public boolean isAvailable() {
        return this.getType() != GenotypeType.UNAVAILABLE;
    }

    public boolean hasLikelihoods() {
        return this.getPL() != null;
    }

    public String getLikelihoodsString() {
        return this.hasLikelihoods() ? this.getLikelihoods().toString() : ".";
    }

    public GenotypeLikelihoods getLikelihoods() {
        return this.hasLikelihoods() ? GenotypeLikelihoods.fromPLs(this.getPL()) : null;
    }

    public boolean isNonInformative() {
        if (this.getPL() == null) {
            return true;
        }
        for (int n : this.getPL()) {
            if (n == 0) continue;
            return false;
        }
        return true;
    }

    public abstract int[] getPL();

    public String getGenotypeString() {
        return this.getGenotypeString(true);
    }

    public String getGenotypeString(boolean bl) {
        String string;
        if (this.getPloidy() == 0) {
            return "NA";
        }
        String string2 = string = this.isPhased() ? PHASED_ALLELE_SEPARATOR : UNPHASED_ALLELE_SEPARATOR;
        if (bl) {
            return ParsingUtils.join(string, this.getAlleleStrings());
        }
        List<Allele> list = this.isPhased() ? this.getAlleles() : ParsingUtils.sortList(this.getAlleles());
        return ParsingUtils.join(string, list);
    }

    protected List<String> getAlleleStrings() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getPloidy());
        for (Allele allele : this.getAlleles()) {
            arrayList.add(allele.getBaseString());
        }
        return arrayList;
    }

    public String toString() {
        return String.format("[%s %s%s%s%s%s%s%s]", this.getSampleName(), this.getGenotypeString(false), Genotype.toStringIfExists("GQ", this.getGQ()), Genotype.toStringIfExists("DP", this.getDP()), Genotype.toStringIfExists("AD", this.getAD()), Genotype.toStringIfExists("PL", this.getPL()), Genotype.toStringIfExists("FT", this.getFilters()), Genotype.sortedString(this.getExtendedAttributes()));
    }

    public String toBriefString() {
        return String.format("%s:Q%d", this.getGenotypeString(false), this.getGQ());
    }

    @Override
    public int compareTo(Genotype genotype) {
        return this.getSampleName().compareTo(genotype.getSampleName());
    }

    public boolean sameGenotype(Genotype genotype) {
        return this.sameGenotype(genotype, true);
    }

    public boolean sameGenotype(Genotype genotype, boolean bl) {
        if (this.getPloidy() != genotype.getPloidy()) {
            return false;
        }
        SequencedCollection<Allele> sequencedCollection = this.getAlleles();
        SequencedCollection<Allele> sequencedCollection2 = genotype.getAlleles();
        if (bl) {
            sequencedCollection = new TreeSet<Allele>(sequencedCollection);
            sequencedCollection2 = new TreeSet<Allele>(sequencedCollection2);
        }
        return ((Object)sequencedCollection).equals(sequencedCollection2);
    }

    public abstract Map<String, Object> getExtendedAttributes();

    public boolean hasExtendedAttribute(String string) {
        return this.getExtendedAttributes().containsKey(string);
    }

    public Object getExtendedAttribute(String string, Object object) {
        return this.hasExtendedAttribute(string) ? this.getExtendedAttributes().get(string) : object;
    }

    public Object getExtendedAttribute(String string) {
        return this.getExtendedAttribute(string, null);
    }

    public final String getFilters() {
        return this.filters;
    }

    public final boolean isFiltered() {
        return this.getFilters() != null;
    }

    @Deprecated
    public boolean hasLog10PError() {
        return this.hasGQ();
    }

    @Deprecated
    public double getLog10PError() {
        return (double)this.getGQ() / -10.0;
    }

    @Deprecated
    public int getPhredScaledQual() {
        return this.getGQ();
    }

    @Deprecated
    public String getAttributeAsString(String string, String string2) {
        Object object = this.getExtendedAttribute(string);
        if (object == null) {
            return string2;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    @Deprecated
    public int getAttributeAsInt(String string, int n) {
        Object object = this.getExtendedAttribute(string);
        if (object == null || object == ".") {
            return n;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return Integer.valueOf((String)object);
    }

    @Deprecated
    public double getAttributeAsDouble(String string, double d) {
        Object object = this.getExtendedAttribute(string);
        if (object == null) {
            return d;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        return Double.valueOf((String)object);
    }

    public Object getAnyAttribute(String string) {
        if (string.equals("GT")) {
            return this.getAlleles();
        }
        if (string.equals("GQ")) {
            return this.getGQ();
        }
        if (string.equals("AD")) {
            return Arrays.asList(new int[][]{this.getAD()});
        }
        if (string.equals("PL")) {
            return Arrays.asList(new int[][]{this.getPL()});
        }
        if (string.equals("DP")) {
            return this.getDP();
        }
        return this.getExtendedAttribute(string);
    }

    public boolean hasAnyAttribute(String string) {
        if (string.equals("GT")) {
            return this.isAvailable();
        }
        if (string.equals("GQ")) {
            return this.hasGQ();
        }
        if (string.equals("AD")) {
            return this.hasAD();
        }
        if (string.equals("PL")) {
            return this.hasPL();
        }
        if (string.equals("DP")) {
            return this.hasDP();
        }
        return this.hasExtendedAttribute(string);
    }

    protected static <T extends Comparable<T>, V> String sortedString(Map<T, V> map) {
        ArrayList<T> arrayList = new ArrayList<T>(map.keySet());
        Collections.sort(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Comparable comparable : arrayList) {
            arrayList2.add(comparable + "=" + map.get(comparable));
        }
        return arrayList2.isEmpty() ? "" : " {" + ParsingUtils.join(", ", arrayList2.toArray(new String[arrayList2.size()])) + "}";
    }

    protected static final String toStringIfExists(String string, int n) {
        return n == -1 ? "" : " " + string + " " + n;
    }

    protected static final String toStringIfExists(String string, String string2) {
        return string2 == null ? "" : " " + string + " " + string2;
    }

    protected static final String toStringIfExists(String string, int[] nArray) {
        if (nArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ").append(string).append(" ");
        for (int i = 0; i < nArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(nArray[i]);
        }
        return stringBuilder.toString();
    }

    protected static final boolean hasForbiddenKey(Map<String, Object> map) {
        for (String string : PRIMARY_KEYS) {
            if (!map.containsKey(string)) continue;
            return true;
        }
        return false;
    }

    protected static final boolean isForbiddenKey(String string) {
        return PRIMARY_KEYS.contains(string);
    }
}

