/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.tribble.util.ParsingUtils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.FastGenotype;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GenotypeBuilder {
    private static final List<Allele> HAPLOID_NO_CALL = Arrays.asList(Allele.NO_CALL);
    private static final List<Allele> DIPLOID_NO_CALL = Arrays.asList(Allele.NO_CALL, Allele.NO_CALL);
    private String sampleName = null;
    private List<Allele> alleles = Collections.emptyList();
    private boolean isPhased = false;
    private int GQ = -1;
    private int DP = -1;
    private int[] AD = null;
    private int[] PL = null;
    private Map<String, Object> extendedAttributes = null;
    private String filters = null;
    private int initialAttributeMapSize = 5;
    private static final Map<String, Object> NO_ATTRIBUTES = Collections.unmodifiableMap(new HashMap(0));

    public static Genotype create(String string, List<Allele> list) {
        return new GenotypeBuilder(string, list).make();
    }

    public static Genotype create(String string, List<Allele> list, Map<String, Object> map) {
        return new GenotypeBuilder(string, list).attributes(map).make();
    }

    protected static Genotype create(String string, List<Allele> list, double[] dArray) {
        return new GenotypeBuilder(string, list).PL(dArray).make();
    }

    public static Genotype createMissing(String string, int n) {
        GenotypeBuilder genotypeBuilder = new GenotypeBuilder(string);
        switch (n) {
            case 1: {
                genotypeBuilder.alleles(HAPLOID_NO_CALL);
                break;
            }
            case 2: {
                genotypeBuilder.alleles(DIPLOID_NO_CALL);
                break;
            }
            default: {
                genotypeBuilder.alleles(Collections.nCopies(n, Allele.NO_CALL));
            }
        }
        return genotypeBuilder.make();
    }

    public GenotypeBuilder() {
    }

    public GenotypeBuilder(String string) {
        this.name(string);
    }

    public GenotypeBuilder(String string, List<Allele> list) {
        this.name(string);
        this.alleles(list);
    }

    public GenotypeBuilder(Genotype genotype) {
        this.copy(genotype);
    }

    public GenotypeBuilder copy(Genotype genotype) {
        this.name(genotype.getSampleName());
        this.alleles(genotype.getAlleles());
        this.phased(genotype.isPhased());
        this.GQ(genotype.getGQ());
        this.DP(genotype.getDP());
        this.AD(genotype.getAD());
        this.PL(genotype.getPL());
        this.filter(genotype.getFilters());
        this.attributes(genotype.getExtendedAttributes());
        return this;
    }

    public final void reset(boolean bl) {
        if (!bl) {
            this.sampleName = null;
        }
        this.alleles = Collections.emptyList();
        this.isPhased = false;
        this.GQ = -1;
        this.DP = -1;
        this.AD = null;
        this.PL = null;
        this.filters = null;
        this.extendedAttributes = null;
    }

    public Genotype make() {
        Map<String, Object> map = this.extendedAttributes == null ? NO_ATTRIBUTES : this.extendedAttributes;
        return new FastGenotype(this.sampleName, this.alleles, this.isPhased, this.GQ, this.DP, this.AD, this.PL, this.filters, map);
    }

    public GenotypeBuilder name(String string) {
        this.sampleName = string;
        return this;
    }

    public GenotypeBuilder alleles(List<Allele> list) {
        this.alleles = list == null ? Collections.emptyList() : list;
        return this;
    }

    public GenotypeBuilder phased(boolean bl) {
        this.isPhased = bl;
        return this;
    }

    public GenotypeBuilder GQ(int n) {
        this.GQ = n;
        return this;
    }

    @Deprecated
    public GenotypeBuilder log10PError(double d) {
        if (d == 1.0) {
            return this.GQ(-1);
        }
        return this.GQ((int)Math.round(d * -10.0));
    }

    public GenotypeBuilder noGQ() {
        this.GQ = -1;
        return this;
    }

    public GenotypeBuilder noAD() {
        this.AD = null;
        return this;
    }

    public GenotypeBuilder noDP() {
        this.DP = -1;
        return this;
    }

    public GenotypeBuilder noPL() {
        this.PL = null;
        return this;
    }

    public GenotypeBuilder DP(int n) {
        this.DP = n;
        return this;
    }

    public GenotypeBuilder AD(int[] nArray) {
        this.AD = nArray;
        return this;
    }

    public GenotypeBuilder PL(int[] nArray) {
        this.PL = nArray;
        return this;
    }

    public GenotypeBuilder PL(double[] dArray) {
        this.PL = GenotypeLikelihoods.fromLog10Likelihoods(dArray).getAsPLs();
        return this;
    }

    public GenotypeBuilder attributes(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.attribute(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public GenotypeBuilder noAttributes() {
        this.extendedAttributes = null;
        return this;
    }

    public GenotypeBuilder attribute(String string, Object object) {
        if (this.extendedAttributes == null) {
            this.extendedAttributes = new HashMap<String, Object>(this.initialAttributeMapSize);
        }
        this.extendedAttributes.put(string, object);
        return this;
    }

    public GenotypeBuilder filters(List<String> list) {
        if (list.isEmpty()) {
            return this.filter(null);
        }
        if (list.size() == 1) {
            return this.filter(list.get(0));
        }
        return this.filter(ParsingUtils.join(";", ParsingUtils.sortList(list)));
    }

    public GenotypeBuilder filters(String ... stringArray) {
        return this.filters(Arrays.asList(stringArray));
    }

    public GenotypeBuilder filter(String string) {
        this.filters = "PASS".equals(string) ? null : string;
        return this;
    }

    public GenotypeBuilder unfiltered() {
        return this.filter(null);
    }

    public GenotypeBuilder maxAttributes(int n) {
        this.initialAttributeMapSize = n;
        return this;
    }
}

