/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineTranslator;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFIDHeaderLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class VCFCompoundHeaderLine
extends VCFHeaderLine
implements VCFIDHeaderLine {
    private String name;
    private int count = -1;
    private VCFHeaderLineCount countType;
    private String description;
    private VCFHeaderLineType type;
    private final SupportedHeaderLineType lineType;

    @Override
    public String getID() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public VCFHeaderLineType getType() {
        return this.type;
    }

    public VCFHeaderLineCount getCountType() {
        return this.countType;
    }

    public boolean isFixedCount() {
        return this.countType == VCFHeaderLineCount.INTEGER;
    }

    public int getCount() {
        if (!this.isFixedCount()) {
            throw new TribbleException("Asking for header line count when type is not an integer");
        }
        return this.count;
    }

    public int getCount(VariantContext variantContext) {
        switch (this.countType) {
            case INTEGER: {
                return this.count;
            }
            case UNBOUNDED: {
                return -1;
            }
            case A: {
                return variantContext.getNAlleles() - 1;
            }
            case R: {
                return variantContext.getNAlleles();
            }
            case G: {
                int n = variantContext.getMaxPloidy(2);
                return GenotypeLikelihoods.numLikelihoods(variantContext.getNAlleles(), n);
            }
        }
        throw new TribbleException("Unknown count type: " + (Object)((Object)this.countType));
    }

    public void setNumberToUnbounded() {
        this.countType = VCFHeaderLineCount.UNBOUNDED;
        this.count = -1;
    }

    protected VCFCompoundHeaderLine(String string, int n, VCFHeaderLineType vCFHeaderLineType, String string2, SupportedHeaderLineType supportedHeaderLineType) {
        super(supportedHeaderLineType.toString(), "");
        this.name = string;
        this.countType = VCFHeaderLineCount.INTEGER;
        this.count = n;
        this.type = vCFHeaderLineType;
        this.description = string2;
        this.lineType = supportedHeaderLineType;
        this.validate();
    }

    protected VCFCompoundHeaderLine(String string, VCFHeaderLineCount vCFHeaderLineCount, VCFHeaderLineType vCFHeaderLineType, String string2, SupportedHeaderLineType supportedHeaderLineType) {
        super(supportedHeaderLineType.toString(), "");
        this.name = string;
        this.countType = vCFHeaderLineCount;
        this.type = vCFHeaderLineType;
        this.description = string2;
        this.lineType = supportedHeaderLineType;
        this.validate();
    }

    protected VCFCompoundHeaderLine(String string, VCFHeaderVersion vCFHeaderVersion, SupportedHeaderLineType supportedHeaderLineType) {
        super(supportedHeaderLineType.toString(), "");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("ID", "Number", "Type", "Description"));
        if (vCFHeaderVersion.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_2)) {
            arrayList.add("Version");
        }
        Map<String, String> map = VCFHeaderLineTranslator.parseLine(vCFHeaderVersion, string, arrayList);
        this.name = map.get("ID");
        this.count = -1;
        String string2 = map.get("Number");
        if (string2.equals("A")) {
            this.countType = VCFHeaderLineCount.A;
        } else if (string2.equals("R")) {
            this.countType = VCFHeaderLineCount.R;
        } else if (string2.equals("G")) {
            this.countType = VCFHeaderLineCount.G;
        } else if (vCFHeaderVersion.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_0) && string2.equals(".") || !vCFHeaderVersion.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_0) && string2.equals("-1")) {
            this.countType = VCFHeaderLineCount.UNBOUNDED;
        } else {
            this.countType = VCFHeaderLineCount.INTEGER;
            this.count = Integer.valueOf(string2);
        }
        if (this.count < 0 && this.countType == VCFHeaderLineCount.INTEGER) {
            throw new TribbleException.InvalidHeader("Count < 0 for fixed size VCF header field " + this.name);
        }
        try {
            this.type = VCFHeaderLineType.valueOf(map.get("Type"));
        }
        catch (Exception exception) {
            throw new TribbleException(map.get("Type") + " is not a valid type in the VCF specification (note that types are case-sensitive)");
        }
        if (this.type == VCFHeaderLineType.Flag && !this.allowFlagValues()) {
            throw new IllegalArgumentException("Flag is an unsupported type for this kind of field");
        }
        this.description = map.get("Description");
        if (this.description == null) {
            this.description = "Not provided in original VCF header";
        }
        this.lineType = supportedHeaderLineType;
        this.validate();
    }

    private void validate() {
        if (this.name == null || this.type == null || this.description == null || this.lineType == null) {
            throw new IllegalArgumentException(String.format("Invalid VCFCompoundHeaderLine: key=%s name=%s type=%s desc=%s lineType=%s", new Object[]{super.getKey(), this.name, this.type, this.description, this.lineType}));
        }
        if (this.name.contains("<") || this.name.contains(">")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain angle brackets");
        }
        if (this.name.contains("=")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain an equals sign");
        }
        if (this.type == VCFHeaderLineType.Flag && this.count != 0) {
            this.count = 0;
        }
    }

    @Override
    protected String toStringEncoding() {
        Object object;
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("ID", this.name);
        switch (this.countType) {
            case A: {
                object = "A";
                break;
            }
            case R: {
                object = "R";
                break;
            }
            case G: {
                object = "G";
                break;
            }
            case UNBOUNDED: {
                object = ".";
                break;
            }
            default: {
                object = this.count;
            }
        }
        linkedHashMap.put("Number", object);
        linkedHashMap.put("Type", (Object)this.type);
        linkedHashMap.put("Description", this.description);
        return this.lineType.toString() + "=" + VCFHeaderLine.toStringEncoding(linkedHashMap);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof VCFCompoundHeaderLine)) {
            return false;
        }
        VCFCompoundHeaderLine vCFCompoundHeaderLine = (VCFCompoundHeaderLine)object;
        return this.equalsExcludingDescription(vCFCompoundHeaderLine) && this.description.equals(vCFCompoundHeaderLine.description);
    }

    public boolean equalsExcludingDescription(VCFCompoundHeaderLine vCFCompoundHeaderLine) {
        return this.count == vCFCompoundHeaderLine.count && this.countType == vCFCompoundHeaderLine.countType && this.type == vCFCompoundHeaderLine.type && this.lineType == vCFCompoundHeaderLine.lineType && this.name.equals(vCFCompoundHeaderLine.name);
    }

    public boolean sameLineTypeAndName(VCFCompoundHeaderLine vCFCompoundHeaderLine) {
        return this.lineType == vCFCompoundHeaderLine.lineType && this.name.equals(vCFCompoundHeaderLine.name);
    }

    abstract boolean allowFlagValues();

    public static enum SupportedHeaderLineType {
        INFO(true),
        FORMAT(false);

        public final boolean allowFlagValues;

        private SupportedHeaderLineType(boolean bl) {
            this.allowFlagValues = bl;
        }
    }
}

