/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.example;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import parquet.example.data.Group;
import parquet.example.data.GroupWriter;
import parquet.hadoop.api.WriteSupport;
import parquet.io.api.RecordConsumer;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class GroupWriteSupport
extends WriteSupport<Group> {
    public static final String PARQUET_EXAMPLE_SCHEMA = "parquet.example.schema";
    private MessageType schema;
    private GroupWriter groupWriter;

    public static void setSchema(MessageType schema, Configuration configuration) {
        configuration.set(PARQUET_EXAMPLE_SCHEMA, schema.toString());
    }

    public static MessageType getSchema(Configuration configuration) {
        return MessageTypeParser.parseMessageType((String)configuration.get(PARQUET_EXAMPLE_SCHEMA));
    }

    @Override
    public WriteSupport.WriteContext init(Configuration configuration) {
        this.schema = GroupWriteSupport.getSchema(configuration);
        return new WriteSupport.WriteContext(this.schema, new HashMap<String, String>());
    }

    @Override
    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.groupWriter = new GroupWriter(recordConsumer, (GroupType)this.schema);
    }

    @Override
    public void write(Group record) {
        this.groupWriter.write(record);
    }
}

