/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.BAMRecordReader;
import org.seqdoop.hadoop_bam.BAMSplitGuesser;
import org.seqdoop.hadoop_bam.FileVirtualSplit;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.SplittingBAMIndex;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public class BAMInputFormat
extends FileInputFormat<LongWritable, SAMRecordWritable> {
    public static final boolean DEBUG_BAM_SPLITTER = false;

    private Path getIdxPath(Path path) {
        return path.suffix(".splitting-bai");
    }

    public RecordReader<LongWritable, SAMRecordWritable> createRecordReader(InputSplit split, TaskAttemptContext ctx) throws InterruptedException, IOException {
        BAMRecordReader rr = new BAMRecordReader();
        rr.initialize(split, ctx);
        return rr;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        return this.getSplits(super.getSplits(job), ContextUtil.getConfiguration(job));
    }

    public List<InputSplit> getSplits(List<InputSplit> splits, Configuration cfg) throws IOException {
        Collections.sort(splits, new Comparator<InputSplit>(){

            @Override
            public int compare(InputSplit a, InputSplit b) {
                FileSplit fa = (FileSplit)a;
                FileSplit fb = (FileSplit)b;
                return fa.getPath().compareTo((Object)fb.getPath());
            }
        });
        ArrayList<InputSplit> newSplits = new ArrayList<InputSplit>(splits.size());
        int i = 0;
        while (i < splits.size()) {
            try {
                i = this.addIndexedSplits(splits, i, newSplits, cfg);
            }
            catch (IOException e) {
                i = this.addProbabilisticSplits(splits, i, newSplits, cfg);
            }
        }
        return newSplits;
    }

    private int addIndexedSplits(List<InputSplit> splits, int i, List<InputSplit> newSplits, Configuration cfg) throws IOException {
        int j;
        Path file = ((FileSplit)splits.get(i)).getPath();
        SplittingBAMIndex idx = new SplittingBAMIndex((InputStream)file.getFileSystem(cfg).open(this.getIdxPath(file)));
        int splitsEnd = splits.size();
        for (j = i; j < splitsEnd; ++j) {
            if (file.equals((Object)((FileSplit)splits.get(j)).getPath())) continue;
            splitsEnd = j;
        }
        for (j = i; j < splitsEnd; ++j) {
            FileSplit fileSplit = (FileSplit)splits.get(j);
            long start = fileSplit.getStart();
            long end = start + fileSplit.getLength();
            Long blockStart = idx.nextAlignment(start);
            Long blockEnd = j == splitsEnd - 1 ? idx.prevAlignment(end) | 0xFFFFL : idx.nextAlignment(end);
            if (blockStart == null) {
                throw new RuntimeException("Internal error or invalid index: no block start for " + start);
            }
            if (blockEnd == null) {
                throw new RuntimeException("Internal error or invalid index: no block end for " + end);
            }
            newSplits.add(new FileVirtualSplit(file, blockStart, blockEnd, fileSplit.getLocations()));
        }
        return splitsEnd;
    }

    private int addProbabilisticSplits(List<InputSplit> splits, int i, List<InputSplit> newSplits, Configuration cfg) throws IOException {
        FileSplit fspl;
        Path path = ((FileSplit)splits.get(i)).getPath();
        WrapSeekable<FSDataInputStream> sin = WrapSeekable.openPath(path.getFileSystem(cfg), path);
        BAMSplitGuesser guesser = new BAMSplitGuesser(sin, cfg);
        FileVirtualSplit previousSplit = null;
        while (i < splits.size() && (fspl = (FileSplit)splits.get(i)).getPath().equals((Object)path)) {
            long beg = fspl.getStart();
            long end = beg + fspl.getLength();
            long alignedBeg = guesser.guessNextBAMRecordStart(beg, end);
            long alignedEnd = end << 16 | 0xFFFFL;
            if (alignedBeg == end) {
                if (previousSplit == null) {
                    throw new IOException("'" + path + "': " + "no reads in first split: bad BAM file or tiny split size?");
                }
                previousSplit.setEndVirtualOffset(alignedEnd);
            } else {
                previousSplit = new FileVirtualSplit(path, alignedBeg, alignedEnd, fspl.getLocations());
                newSplits.add(previousSplit);
            }
            ++i;
        }
        sin.close();
        return i;
    }

    public boolean isSplitable(JobContext job, Path path) {
        return true;
    }
}

