/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.samtools.SAMFileHeader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.AnySAMOutputFormat;
import org.seqdoop.hadoop_bam.KeyIgnoringBAMRecordWriter;
import org.seqdoop.hadoop_bam.KeyIgnoringSAMRecordWriter;
import org.seqdoop.hadoop_bam.SAMFormat;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;

public class KeyIgnoringAnySAMOutputFormat<K>
extends AnySAMOutputFormat<K> {
    protected SAMFileHeader header;
    private boolean writeHeader_ = true;
    public static final String WRITE_HEADER_PROPERTY = "hadoopbam.anysam.write-header";

    public KeyIgnoringAnySAMOutputFormat(SAMFormat fmt) {
        super(fmt);
    }

    public KeyIgnoringAnySAMOutputFormat(Configuration conf) {
        super(conf);
        if (this.format == null) {
            throw new IllegalArgumentException("unknown SAM format: OUTPUT_SAM_FORMAT_PROPERTY not set");
        }
    }

    public KeyIgnoringAnySAMOutputFormat(Configuration conf, Path path) {
        super(conf);
        if (this.format == null) {
            this.format = SAMFormat.inferFromFilePath(path);
            if (this.format == null) {
                throw new IllegalArgumentException("unknown SAM format: " + path);
            }
        }
    }

    @Deprecated
    public boolean getWriteHeader() {
        return this.writeHeader_;
    }

    @Deprecated
    public void setWriteHeader(boolean b) {
        this.writeHeader_ = b;
    }

    public SAMFileHeader getSAMHeader() {
        return this.header;
    }

    public void setSAMHeader(SAMFileHeader header) {
        this.header = header;
    }

    public void readSAMHeaderFrom(Path path, Configuration conf) throws IOException {
        this.header = SAMHeaderReader.readSAMHeaderFrom(path, conf);
    }

    public void readSAMHeaderFrom(InputStream in, Configuration conf) {
        this.header = SAMHeaderReader.readSAMHeaderFrom(in, conf);
    }

    public RecordWriter<K, SAMRecordWritable> getRecordWriter(TaskAttemptContext ctx) throws IOException {
        return this.getRecordWriter(ctx, this.getDefaultWorkFile(ctx, ""));
    }

    public RecordWriter<K, SAMRecordWritable> getRecordWriter(TaskAttemptContext ctx, Path out) throws IOException {
        if (this.header == null) {
            throw new IOException("Can't create a RecordWriter without the SAM header");
        }
        boolean writeHeader = ContextUtil.getConfiguration((JobContext)ctx).getBoolean(WRITE_HEADER_PROPERTY, this.writeHeader_);
        switch (this.format) {
            case BAM: {
                return new KeyIgnoringBAMRecordWriter(out, this.header, writeHeader, ctx);
            }
            case SAM: {
                return new KeyIgnoringSAMRecordWriter(out, this.header, writeHeader, ctx);
            }
        }
        assert (false);
        return null;
    }
}

