/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class ReferenceFragment
implements Writable {
    protected Text sequence = new Text();
    protected Integer position;
    protected String indexSequence;

    public void clear() {
        this.sequence.clear();
        this.indexSequence = null;
        this.position = null;
    }

    public Text getSequence() {
        return this.sequence;
    }

    public void setPosition(Integer pos) {
        if (pos == null) {
            throw new IllegalArgumentException("can't have null reference position");
        }
        this.position = pos;
    }

    public void setIndexSequence(String v) {
        if (v == null) {
            throw new IllegalArgumentException("can't have null index sequence");
        }
        this.indexSequence = v;
    }

    public void setSequence(Text seq) {
        if (seq == null) {
            throw new IllegalArgumentException("can't have a null sequence");
        }
        this.sequence = seq;
    }

    public Integer getPosition() {
        return this.position;
    }

    public String getIndexSequence() {
        return this.indexSequence;
    }

    public String toString() {
        String delim = "\t";
        StringBuilder builder = new StringBuilder(800);
        builder.append(this.indexSequence).append(delim);
        builder.append(this.position).append(delim);
        builder.append(this.sequence);
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof ReferenceFragment) {
            ReferenceFragment otherFrag = (ReferenceFragment)other;
            if (this.position == null && otherFrag.position != null || this.position != null && !this.position.equals(otherFrag.position)) {
                return false;
            }
            if (this.indexSequence == null && otherFrag.indexSequence != null || this.indexSequence != null && !this.indexSequence.equals(otherFrag.indexSequence)) {
                return false;
            }
            return this.sequence.equals((Object)otherFrag.sequence);
        }
        return false;
    }

    public void readFields(DataInput in) throws IOException {
        this.clear();
        this.sequence.readFields(in);
        this.indexSequence = WritableUtils.readString((DataInput)in);
        this.position = WritableUtils.readVInt((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        this.sequence.write(out);
        WritableUtils.writeString((DataOutput)out, (String)this.indexSequence);
        WritableUtils.writeVInt((DataOutput)out, (int)this.position);
    }
}

