/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.BCFRecordReader;
import org.seqdoop.hadoop_bam.BCFSplitGuesser;
import org.seqdoop.hadoop_bam.FileVirtualSplit;
import org.seqdoop.hadoop_bam.VCFFormat;
import org.seqdoop.hadoop_bam.VCFRecordReader;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public class VCFInputFormat
extends FileInputFormat<LongWritable, VariantContextWritable> {
    public static final String TRUST_EXTS_PROPERTY = "hadoopbam.vcf.trust-exts";
    private final Map<Path, VCFFormat> formatMap;
    private final boolean givenMap;
    private Configuration conf;
    private boolean trustExts;

    public VCFInputFormat() {
        this.formatMap = new HashMap<Path, VCFFormat>();
        this.givenMap = false;
        this.conf = null;
    }

    public VCFInputFormat(Configuration conf) {
        this.formatMap = new HashMap<Path, VCFFormat>();
        this.conf = conf;
        this.trustExts = conf.getBoolean(TRUST_EXTS_PROPERTY, true);
        this.givenMap = false;
    }

    public VCFInputFormat(Map<Path, VCFFormat> formatMap) {
        this.formatMap = formatMap;
        this.givenMap = true;
        this.conf = null;
        this.trustExts = false;
    }

    public VCFFormat getFormat(Path path) {
        VCFFormat f;
        VCFFormat fmt = this.formatMap.get(path);
        if (fmt != null || this.formatMap.containsKey(path)) {
            return fmt;
        }
        if (this.givenMap) {
            throw new IllegalArgumentException("VCF format for '" + path + "' not in given map");
        }
        if (this.conf == null) {
            throw new IllegalStateException("Don't have a Configuration yet");
        }
        if (this.trustExts && (f = VCFFormat.inferFromFilePath(path)) != null) {
            this.formatMap.put(path, f);
            return f;
        }
        try {
            fmt = VCFFormat.inferFromData((InputStream)path.getFileSystem(this.conf).open(path));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.formatMap.put(path, fmt);
        return fmt;
    }

    public RecordReader<LongWritable, VariantContextWritable> createRecordReader(InputSplit split, TaskAttemptContext ctx) throws InterruptedException, IOException {
        RecordReader rr;
        VCFFormat fmt;
        Path path;
        if (split instanceof FileSplit) {
            path = ((FileSplit)split).getPath();
        } else if (split instanceof FileVirtualSplit) {
            path = ((FileVirtualSplit)split).getPath();
        } else {
            throw new IllegalArgumentException("split '" + split + "' has unknown type: cannot extract path");
        }
        if (this.conf == null) {
            this.conf = ContextUtil.getConfiguration((JobContext)ctx);
        }
        if ((fmt = this.getFormat(path)) == null) {
            throw new IllegalArgumentException("unknown VCF format, cannot create RecordReader: " + path);
        }
        switch (fmt) {
            case VCF: {
                rr = new VCFRecordReader();
                break;
            }
            case BCF: {
                rr = new BCFRecordReader();
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        rr.initialize(split, ctx);
        return rr;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        if (this.conf == null) {
            this.conf = ContextUtil.getConfiguration(job);
        }
        List origSplits = super.getSplits(job);
        ArrayList<FileSplit> bcfOrigSplits = new ArrayList<FileSplit>(origSplits.size());
        ArrayList<InputSplit> newSplits = new ArrayList<InputSplit>(origSplits.size());
        for (InputSplit iSplit : origSplits) {
            FileSplit split = (FileSplit)iSplit;
            if (VCFFormat.BCF.equals((Object)this.getFormat(split.getPath()))) {
                bcfOrigSplits.add(split);
                continue;
            }
            newSplits.add((InputSplit)split);
        }
        this.fixBCFSplits(bcfOrigSplits, newSplits);
        return newSplits;
    }

    private void fixBCFSplits(List<FileSplit> splits, List<InputSplit> newSplits) throws IOException {
        Collections.sort(splits, new Comparator<FileSplit>(){

            @Override
            public int compare(FileSplit a, FileSplit b) {
                return a.getPath().compareTo((Object)b.getPath());
            }
        });
        int i = 0;
        while (i < splits.size()) {
            i = this.addGuessedSplits(splits, i, newSplits);
        }
    }

    private int addGuessedSplits(List<FileSplit> splits, int i, List<InputSplit> newSplits) throws IOException {
        FileSplit fspl;
        Path path = splits.get(i).getPath();
        WrapSeekable<FSDataInputStream> sin = WrapSeekable.openPath(this.conf, path);
        BCFSplitGuesser guesser = new BCFSplitGuesser(sin);
        boolean isBGZF = guesser.isBGZF();
        FileVirtualSplit prevSplit = null;
        while (i < splits.size() && (fspl = splits.get(i)).getPath().equals((Object)path)) {
            block4: {
                block5: {
                    long length;
                    long alignEnd;
                    long alignBeg;
                    String[] locs;
                    block2: {
                        block3: {
                            locs = fspl.getLocations();
                            long beg = fspl.getStart();
                            long end = beg + fspl.getLength();
                            alignBeg = guesser.guessNextBCFRecordStart(beg, end);
                            alignEnd = isBGZF ? end << 16 | 0xFFFFL : end;
                            length = alignEnd - alignBeg;
                            if (alignBeg != end) break block2;
                            if (prevSplit == null) {
                                throw new IOException("'" + path + "': no records in first " + "split: bad BCF file or tiny split size?");
                            }
                            if (!isBGZF) break block3;
                            ((FileVirtualSplit)prevSplit).setEndVirtualOffset(alignEnd);
                            break block4;
                        }
                        prevSplit = new FileSplit(path, alignBeg, length, locs);
                        newSplits.remove(newSplits.size() - 1);
                        break block5;
                    }
                    prevSplit = isBGZF ? new FileVirtualSplit(path, alignBeg, alignEnd, locs) : new FileSplit(path, alignBeg, length, locs);
                }
                newSplits.add(prevSplit);
            }
            ++i;
        }
        sin.close();
        return i;
    }
}

