/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.seqdoop.hadoop_bam.util.MurmurHash3;

public class VCFRecordReader
extends RecordReader<LongWritable, VariantContextWritable> {
    private final LongWritable key = new LongWritable();
    private final VariantContextWritable vc = new VariantContextWritable();
    private VCFCodec codec = new VCFCodec();
    private AsciiLineReaderIterator it;
    private AsciiLineReader reader;
    private long length;
    private final Map<String, Integer> contigDict = new HashMap<String, Integer>();

    public void initialize(InputSplit spl, TaskAttemptContext ctx) throws IOException {
        FileSplit split = (FileSplit)spl;
        this.length = split.getLength();
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(ContextUtil.getConfiguration((JobContext)ctx));
        FSDataInputStream ins = fs.open(file);
        this.reader = new AsciiLineReader((InputStream)ins);
        this.it = new AsciiLineReaderIterator(this.reader);
        FeatureCodecHeader h = this.codec.readHeader((LineIterator)this.it);
        if (!(h instanceof FeatureCodecHeader) || !(h.getHeaderValue() instanceof VCFHeader)) {
            throw new IOException("No VCF header found in " + file);
        }
        VCFHeader header = (VCFHeader)h.getHeaderValue();
        this.contigDict.clear();
        int i = 0;
        for (VCFContigHeaderLine contig : header.getContigLines()) {
            this.contigDict.put(contig.getID(), i++);
        }
        long start = split.getStart();
        if (start != 0L) {
            ins.seek(start - 1L);
            this.reader = new AsciiLineReader((InputStream)ins);
            this.reader.readLine();
            this.it = new AsciiLineReaderIterator(this.reader);
        } else {
            long current_pos = this.it.getPosition();
            ins.seek(0L);
            this.reader = new AsciiLineReader((InputStream)ins);
            this.it = new AsciiLineReaderIterator(this.reader);
            while (this.it.hasNext() && this.it.getPosition() <= current_pos && this.it.peek().startsWith("#")) {
                this.it.next();
            }
            if (!this.it.hasNext() || this.it.getPosition() > current_pos) {
                throw new IOException("Empty VCF file " + file);
            }
        }
    }

    public void close() {
        this.reader.close();
    }

    public float getProgress() {
        return this.length == 0L ? 1.0f : (float)this.reader.getPosition() / (float)this.length;
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public VariantContextWritable getCurrentValue() {
        return this.vc;
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.it.hasNext() || this.it.getPosition() >= this.length) {
            return false;
        }
        String line = this.it.next();
        VariantContext v = this.codec.decode(line);
        Integer chromIdx = this.contigDict.get(v.getChr());
        if (chromIdx == null) {
            chromIdx = (int)MurmurHash3.murmurhash3(v.getChr(), 0);
        }
        this.key.set((long)chromIdx.intValue() << 32 | (long)(v.getStart() - 1));
        this.vc.set(v);
        return true;
    }
}

