/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.seqdoop.hadoop_bam.cli.CLIPlugin;
import org.seqdoop.hadoop_bam.custom.jargs.gnu.CmdLineParser;
import org.seqdoop.hadoop_bam.util.Pair;

public abstract class CLIMRPlugin
extends CLIPlugin {
    protected boolean verbose;
    protected int reduceTasks;
    protected Path outPath;
    private static final List<Pair<CmdLineParser.Option, String>> optionDescs = new ArrayList<Pair<CmdLineParser.Option, String>>();
    protected static final CmdLineParser.Option reducersOpt = new CmdLineParser.Option.IntegerOption('r', "reducers=N");
    protected static final CmdLineParser.Option verboseOpt = new CmdLineParser.Option.BooleanOption('v', "verbose");
    protected static final CmdLineParser.Option outputPathOpt = new CmdLineParser.Option.StringOption('o', "output-merged-path=PATH");

    protected CLIMRPlugin(String commandName, String description, String version, String usageParams, List<Pair<CmdLineParser.Option, String>> optionDescs, String longDescription) {
        super(commandName, description, version, usageParams, optionDescs == null ? CLIMRPlugin.optionDescs : (optionDescs.addAll(CLIMRPlugin.optionDescs) ? optionDescs : optionDescs), longDescription);
    }

    public boolean cacheAndSetProperties(CmdLineParser parser) {
        this.verbose = parser.getBoolean(verboseOpt);
        this.reduceTasks = parser.getInt(reducersOpt, 1);
        String out = (String)parser.getOptionValue(outputPathOpt);
        this.outPath = out == null ? null : new Path(out);
        this.getConf().setInt("mapred.reduce.tasks", this.reduceTasks);
        this.getConf().setInt("mapreduce.job.reduces", this.reduceTasks);
        return true;
    }

    static {
        optionDescs.add(new Pair<CmdLineParser.Option, String>(reducersOpt, "use N reduce tasks (default: 1), i.e. produce N outputs in parallel"));
        optionDescs.add(new Pair<CmdLineParser.Option, String>(verboseOpt, "tell the Hadoop job to be more verbose"));
    }
}

