/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configured;
import org.seqdoop.hadoop_bam.cli.Utils;
import org.seqdoop.hadoop_bam.custom.jargs.gnu.CmdLineParser;
import org.seqdoop.hadoop_bam.util.Pair;

public abstract class CLIPlugin
extends Configured {
    protected final String command;
    protected final String desc;
    protected final String usageTail;
    protected final String version;
    protected final String longDesc;
    protected final List<Pair<CmdLineParser.Option, String>> optionDescriptions;

    protected CLIPlugin(String commandName, String description, String version, String usageParams, List<Pair<CmdLineParser.Option, String>> optionDescriptions, String longDescription) {
        this.command = commandName;
        this.desc = description;
        this.version = version;
        this.usageTail = usageParams;
        this.optionDescriptions = optionDescriptions;
        this.longDesc = longDescription;
    }

    public final String getCommandName() {
        return this.command;
    }

    public final String getDescription() {
        return this.desc;
    }

    public void printUsage(PrintStream out) {
        out.printf("hadoop-bam version %d.%d command line: %s version %s\n", 7, 0, this.command, this.version);
        out.printf("Usage: %s %s ", Utils.getArgv0(), this.command);
        if (this.optionDescriptions != null && !this.optionDescriptions.isEmpty()) {
            out.print("[options] ");
        }
        out.println(this.usageTail);
        if (!this.longDesc.isEmpty()) {
            out.print('\n');
            Utils.printWrapped(out, this.longDesc);
        }
        if (this.optionDescriptions == null || this.optionDescriptions.isEmpty()) {
            return;
        }
        Collections.sort(this.optionDescriptions, new Comparator<Pair<CmdLineParser.Option, String>>(){

            @Override
            public int compare(Pair<CmdLineParser.Option, String> ap, Pair<CmdLineParser.Option, String> bp) {
                CmdLineParser.Option a = (CmdLineParser.Option)ap.fst;
                CmdLineParser.Option b = (CmdLineParser.Option)bp.fst;
                String as = a.shortForm();
                String al = a.longForm();
                String bs = b.shortForm();
                String bl = b.longForm();
                if (as != null && bs != null) {
                    assert (as.length() == 1);
                    assert (bs.length() == 1);
                    char ac = as.charAt(0);
                    char bc = bs.charAt(0);
                    if (Character.toLowerCase(ac) == Character.toLowerCase(bc)) {
                        return Character.isUpperCase(ac) ? 1 : -1;
                    }
                    return as.compareTo(bs);
                }
                if (as == null) {
                    if (bs != null) {
                        return al.compareToIgnoreCase(bs);
                    }
                    return al.compareTo(bl);
                }
                assert (as != null);
                assert (bs == null);
                return as.compareToIgnoreCase(bl);
            }
        });
        int optLen = 0;
        boolean anyShortForms = false;
        for (Pair<CmdLineParser.Option, String> pair : this.optionDescriptions) {
            CmdLineParser.Option opt = (CmdLineParser.Option)pair.fst;
            if (opt.shortForm() != null) {
                anyShortForms = true;
            }
            optLen = Math.max(optLen, opt.longForm().length());
        }
        String optFmt = "--%-" + optLen + "s  ";
        out.print("\nOptions: ");
        int optPos = "Options: ".length();
        int descPos = optPos + 2 + optLen + 2 + (anyShortForms ? "-x, ".length() : 0);
        boolean first = true;
        for (Pair<CmdLineParser.Option, String> pair : this.optionDescriptions) {
            if (first) {
                first = false;
            } else {
                int i = optPos;
                while (i-- > 0) {
                    out.print(' ');
                }
            }
            CmdLineParser.Option opt = (CmdLineParser.Option)pair.fst;
            if (anyShortForms) {
                if (opt.shortForm() == null) {
                    out.print("    ");
                } else {
                    out.printf("-%s, ", opt.shortForm());
                }
            }
            out.printf(optFmt, opt.longForm());
            Utils.printWrapped(out, (String)pair.snd, descPos);
        }
    }

    public final int main(List<String> params) {
        if (params.isEmpty()) {
            this.printUsage(System.err);
            return 2;
        }
        if (params.contains("--help")) {
            this.printUsage(System.out);
            return 0;
        }
        CmdLineParser parser = new CmdLineParser();
        if (this.optionDescriptions != null) {
            for (Pair<CmdLineParser.Option, String> pair : this.optionDescriptions) {
                String lf = ((CmdLineParser.Option)pair.fst).longForm();
                int eq = lf.lastIndexOf(61);
                ((CmdLineParser.Option)pair.fst).setLongForm(eq == -1 ? lf : lf.substring(0, eq));
                parser.addOption((CmdLineParser.Option)pair.fst);
            }
        }
        try {
            parser.parse(params);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.printf("%s :: %s.\n", this.command, e.getMessage());
            return 2;
        }
        return this.run(parser);
    }

    protected abstract int run(CmdLineParser var1);
}

