/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins.chipster;

import hbparquet.hadoop.util.ContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.Range;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.RangeCount;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.Summarize;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.SummaryGroup;

final class SummarizeReducer
extends Reducer<LongWritable, Range, NullWritable, RangeCount> {
    public static final String SUMMARY_LEVELS_PROP = "summarize.summary.levels";
    private MultipleOutputs<NullWritable, RangeCount> mos;
    private final List<SummaryGroup> summaryGroupsR = new ArrayList<SummaryGroup>();
    private final List<SummaryGroup> summaryGroupsF = new ArrayList<SummaryGroup>();
    private final RangeCount summary = new RangeCount();
    private int currentReferenceID = 0;

    SummarizeReducer() {
    }

    public void setup(Reducer.Context ctx) {
        this.mos = new MultipleOutputs((TaskInputOutputContext)ctx);
        for (String s : ContextUtil.getConfiguration((JobContext)ctx).getStrings(SUMMARY_LEVELS_PROP)) {
            int lvl = Integer.parseInt(s);
            this.summaryGroupsR.add(new SummaryGroup(lvl, Summarize.getSummaryName(s, true)));
            this.summaryGroupsF.add(new SummaryGroup(lvl, Summarize.getSummaryName(s, false)));
        }
    }

    protected void reduce(LongWritable key, Iterable<Range> ranges, Reducer.Context context) throws IOException, InterruptedException {
        int referenceID = (int)(key.get() >>> 32);
        if (referenceID != this.currentReferenceID) {
            this.currentReferenceID = referenceID;
            this.doAllSummaries();
        }
        for (Range range : ranges) {
            int beg = range.beg.get();
            int end = range.end.get();
            List<SummaryGroup> summaryGroups = range.reverseStrand.get() ? this.summaryGroupsR : this.summaryGroupsF;
            for (SummaryGroup group : summaryGroups) {
                group.sumBeg += (long)beg;
                group.sumEnd += (long)end;
                if (++group.count != group.level) continue;
                this.doSummary(group);
            }
        }
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        this.doAllSummaries();
        this.mos.close();
    }

    private void doAllSummaries() throws IOException, InterruptedException {
        for (SummaryGroup group : this.summaryGroupsR) {
            if (group.count <= 0) continue;
            this.doSummary(group);
        }
        for (SummaryGroup group : this.summaryGroupsF) {
            if (group.count <= 0) continue;
            this.doSummary(group);
        }
    }

    private void doSummary(SummaryGroup group) throws IOException, InterruptedException {
        this.summary.rid.set(this.currentReferenceID);
        this.summary.range.beg.set((int)(group.sumBeg / (long)group.count));
        this.summary.range.end.set((int)(group.sumEnd / (long)group.count));
        this.summary.count.set(group.count);
        this.mos.write((Object)NullWritable.get(), (Object)this.summary, group.outName);
        group.reset();
    }
}

