/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins.chipster;

import htsjdk.samtools.util.BlockCompressedStreamConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.InputSampler;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.seqdoop.hadoop_bam.cli.CLIMRPlugin;
import org.seqdoop.hadoop_bam.cli.Utils;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.SortInputFormat;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.SortOutputFormat;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.SortReducer;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.Summarize;
import org.seqdoop.hadoop_bam.custom.jargs.gnu.CmdLineParser;
import org.seqdoop.hadoop_bam.util.Pair;
import org.seqdoop.hadoop_bam.util.Timer;

public final class SummarySort
extends CLIMRPlugin {
    private static final List<Pair<CmdLineParser.Option, String>> optionDescs = new ArrayList<Pair<CmdLineParser.Option, String>>();

    public SummarySort() {
        super("summarysort", "sort summary file for zooming", "2.1", "WORKDIR INPATH", optionDescs, "Sorts the summary file in INPATH in a distributed fashion using Hadoop. Output parts are placed in WORKDIR.\n\nThis is equivalent to one of the sorts done by the 'summarize' plugin, if sorting is requested of it.");
    }

    @Override
    protected int run(CmdLineParser parser) {
        List<String> args = parser.getRemainingArgs();
        if (args.isEmpty()) {
            System.err.println("summarysort :: WORKDIR not given.");
            return 3;
        }
        if (args.size() == 1) {
            System.err.println("summarysort :: INPATH not given.");
            return 3;
        }
        if (!this.cacheAndSetProperties(parser)) {
            return 3;
        }
        Path wrkDir = new Path(args.get(0));
        Path in = new Path(args.get(1));
        Configuration conf = this.getConf();
        Timer t = new Timer();
        try {
            Job job = SummarySort.sortOne(conf, in, wrkDir, "summarysort", "");
            System.out.printf("summarysort :: Waiting for job completion...\n", new Object[0]);
            t.start();
            if (!job.waitForCompletion(this.verbose)) {
                System.err.println("summarysort :: Job failed.");
                return 4;
            }
            System.out.printf("summarysort :: Job complete in %d.%03d s.\n", t.stopS(), t.fms());
        }
        catch (IOException e) {
            System.err.printf("summarysort :: Hadoop error: %s\n", e);
            return 4;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.outPath != null) {
            try {
                System.out.println("summarysort :: Merging output...");
                t.start();
                FileSystem dstFS = this.outPath.getFileSystem(conf);
                FSDataOutputStream outs = dstFS.create(this.outPath);
                Utils.mergeInto((OutputStream)outs, wrkDir, "", "", conf, "summarysort");
                outs.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
                outs.close();
                System.out.printf("summarysort :: Merging complete in %d.%03d s.\n", t.stopS(), t.fms());
            }
            catch (IOException e) {
                System.err.printf("summarysort :: Output merging failed: %s\n", e);
                return 5;
            }
        }
        return 0;
    }

    static Job sortOne(Configuration conf, Path inputFile, Path outputDir, String commandName, String samplingInfo) throws IOException, ClassNotFoundException, InterruptedException {
        conf.set("hadoopbam.work.filename", inputFile.getName());
        Utils.configureSampling(outputDir, inputFile.getName(), conf);
        Job job = new Job(conf);
        job.setJarByClass(Summarize.class);
        job.setMapperClass(Mapper.class);
        job.setReducerClass(SortReducer.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(SortInputFormat.class);
        job.setOutputFormatClass(SortOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputFile});
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        Timer t = new Timer();
        System.out.printf("%s :: Sampling%s...\n", commandName, samplingInfo);
        t.start();
        InputSampler.writePartitionFile((Job)job, (InputSampler.Sampler)new InputSampler.SplitSampler(Math.max(65536, conf.getInt("mapred.reduce.tasks", 1)), 10));
        System.out.printf("%s :: Sampling complete in %d.%03d s.\n", commandName, t.stopS(), t.fms());
        job.submit();
        return job;
    }

    static {
        optionDescs.add(new Pair<CmdLineParser.Option, String>(outputPathOpt, "output a complete summary file to the file PATH, removing the parts from WORKDIR"));
    }
}

