/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.Contig;

@AvroGenerated
public class AlignmentRecord
extends SpecificRecordBase
implements SpecificRecord {
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"AlignmentRecord\",\"namespace\":\"org.bdgenomics.formats.avro\",\"fields\":[{\"name\":\"contig\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Contig\",\"doc\":\"Record for describing a reference assembly. Not used for storing the contents\\n of said assembly.\\n\\n @see NucleotideContigFragment\",\"fields\":[{\"name\":\"contigName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this contig in the assembly (e.g., \\\"chr1\\\").\",\"default\":null},{\"name\":\"contigLength\",\"type\":[\"null\",\"long\"],\"doc\":\"The length of this contig.\",\"default\":null},{\"name\":\"contigMD5\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The MD5 checksum of the assembly for this contig.\",\"default\":null},{\"name\":\"referenceURL\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The URL at which this reference assembly can be found.\",\"default\":null},{\"name\":\"assembly\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this assembly (e.g., \\\"hg19\\\").\",\"default\":null},{\"name\":\"species\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The species that this assembly is for.\",\"default\":null}]}],\"doc\":\"The reference sequence details for the reference chromosome that\\n   this read is aligned to. If the read is unaligned, this field should\\n   be null.\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"0 based reference position for the start of this read's alignment.\\n   Should be null if the read is unaligned.\",\"default\":null},{\"name\":\"oldPosition\",\"type\":[\"null\",\"long\"],\"doc\":\"0 based reference position where this read used to start before\\n   local realignment.\\n   Stores the same data as the OP field in the SAM format.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"0 based reference position for the end of this read's alignment.\\n   Should be null if the read is unaligned.\",\"default\":null},{\"name\":\"mapq\",\"type\":[\"null\",\"int\"],\"doc\":\"The global mapping quality of this read.\",\"default\":null},{\"name\":\"readName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this read. This should be unique within the read group\\n   that this read is from, and can be used to identify other reads that\\n   are derived from a single fragment.\",\"default\":null},{\"name\":\"sequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The bases in this alignment. If the read has been hard clipped, this may\\n   not represent all the bases in the original read.\",\"default\":null},{\"name\":\"qual\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The per-base quality scores in this alignment. If the read has been hard\\n   clipped, this may not represent all the bases in the original read.\\n   Additionally, if the error scores have been recalibrated, this field\\n   will not contain the original base quality scores.\\n\\n   @see origQual\",\"default\":null},{\"name\":\"cigar\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The Compact Ideosyncratic Gapped Alignment Report (CIGAR) string that\\n   describes the local alignment of this read. Contains {length, operator}\\n   pairs for all contiguous alignment operations. The operators include:\\n   \\n   * M, ALIGNMENT_MATCH: An alignment match indicates that a sequence can be\\n     aligned to the reference without evidence of an INDEL. Unlike the\\n     SEQUENCE_MATCH and SEQUENCE_MISMATCH operators, the ALIGNMENT_MATCH\\n     operator does not indicate whether the reference and read sequences are an\\n     exact match.\\n   * I, INSERT: The insert operator indicates that the read contains evidence of\\n     bases being inserted into the reference.\\n   * D, DELETE: The delete operator indicates that the read contains evidence of\\n     bases being deleted from the reference.\\n   * N, SKIP: The skip operator indicates that this read skips a long segment of\\n     the reference, but the bases have not been deleted. This operator is\\n     commonly used when working with RNA-seq data, where reads may skip long\\n     segments of the reference between exons.\\n   * S, CLIP_SOFT: The soft clip operator indicates that bases at the start/end\\n     of a read have not been considered during alignment. This may occur if the\\n     majority of a read maps, except for low quality bases at the start/end of\\n     a read. Bases that are soft clipped will still be stored in the read.\\n   * H, CLIP_HARD: The hard clip operator indicates that bases at the start/end of\\n     a read have been omitted from this alignment. This may occur if this linear\\n     alignment is part of a chimeric alignment, or if the read has been trimmed\\n     (e.g., during error correction, or to trim poly-A tails for RNA-seq).\\n   * P, PAD: The pad operator indicates that there is padding in an alignment.\\n   * =, SEQUENCE_MATCH: This operator indicates that this portion of the aligned\\n     sequence exactly matches the reference (e.g., all bases are equal to the\\n     reference bases).\\n   * X, SEQUENCE_MISMATCH: This operator indicates that this portion of the \\n     aligned sequence is an alignment match to the reference, but a sequence\\n     mismatch (e.g., the bases are not equal to the reference). This can\\n     indicate a SNP or a read error.\",\"default\":null},{\"name\":\"oldCigar\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Stores the CIGAR string present before local indel realignment.\\n   Stores the same data as the OC field in the SAM format.\\n\\n   @see cigar\",\"default\":null},{\"name\":\"basesTrimmedFromStart\",\"type\":[\"int\",\"null\"],\"doc\":\"The number of bases in this read/alignment that have been trimmed from the\\n   start of the read. By default, this is equal to 0. If the value is non-zero,\\n   that means that the start of the read has been hard-clipped.\\n\\n   @see cigar\",\"default\":0},{\"name\":\"basesTrimmedFromEnd\",\"type\":[\"int\",\"null\"],\"doc\":\"The number of bases in this read/alignment that have been trimmed from the\\n   end of the read. By default, this is equal to 0. If the value is non-zero,\\n   that means that the end of the read has been hard-clipped.\\n\\n   @see cigar\",\"default\":0},{\"name\":\"readPaired\",\"type\":[\"boolean\",\"null\"],\"default\":false},{\"name\":\"properPair\",\"type\":[\"boolean\",\"null\"],\"default\":false},{\"name\":\"readMapped\",\"type\":[\"boolean\",\"null\"],\"default\":false},{\"name\":\"mateMapped\",\"type\":[\"boolean\",\"null\"],\"default\":false},{\"name\":\"firstOfPair\",\"type\":[\"boolean\",\"null\"],\"default\":false},{\"name\":\"secondOfPair\",\"type\":[\"boolean\",\"null\"],\"default\":false},{\"name\":\"failedVendorQualityChecks\",\"type\":[\"boolean\",\"null\"],\"default\":false},{\"name\":\"duplicateRead\",\"type\":[\"boolean\",\"null\"],\"default\":false},{\"name\":\"readNegativeStrand\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this alignment is mapped as a reverse compliment. This field\\n   defaults to false.\",\"default\":false},{\"name\":\"mateNegativeStrand\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the mate pair of this alignment is mapped as a reverse compliment.\\n   This field defaults to false.\",\"default\":false},{\"name\":\"primaryAlignment\",\"type\":[\"boolean\",\"null\"],\"doc\":\"This field is true if this alignment is either the best linear alignment,\\n   or the first linear alignment in a chimeric alignment. Defaults to false.\\n\\n   @see secondaryAlignment\\n   @see supplementaryAlignment\",\"default\":false},{\"name\":\"secondaryAlignment\",\"type\":[\"boolean\",\"null\"],\"doc\":\"This field is true if this alignment is a lower quality linear alignment\\n   for a multiply-mapped read. Defaults to false.\\n\\n   @see primaryAlignment\\n   @see supplementaryAlignment\",\"default\":false},{\"name\":\"supplementaryAlignment\",\"type\":[\"boolean\",\"null\"],\"doc\":\"This field is true if this alignment is a non-primary linear alignment in\\n   a chimeric alignment. Defaults to false.\\n\\n   @see primaryAlignment\\n   @see secondaryAlignment\",\"default\":false},{\"name\":\"mismatchingPositions\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"origQual\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"attributes\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"recordGroupName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"recordGroupSequencingCenter\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"recordGroupDescription\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"recordGroupRunDateEpoch\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"recordGroupFlowOrder\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"recordGroupKeySequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"recordGroupLibrary\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"recordGroupPredictedMedianInsertSize\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"recordGroupPlatform\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"recordGroupPlatformUnit\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"recordGroupSample\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"mateAlignmentStart\",\"type\":[\"null\",\"long\"],\"doc\":\"The start position of the mate of this read. Should be set to null if the\\n   mate is unaligned, or if the mate does not exist.\",\"default\":null},{\"name\":\"mateAlignmentEnd\",\"type\":[\"null\",\"long\"],\"doc\":\"The end position of the mate of this read. Should be set to null if the\\n   mate is unaligned, or if the mate does not exist.\",\"default\":null},{\"name\":\"mateContig\",\"type\":[\"null\",\"Contig\"],\"doc\":\"The reference contig of the mate of this read. Should be set to null if the\\n   mate is unaligned, or if the mate does not exist.\",\"default\":null}]}");
    @Deprecated
    public Contig contig;
    @Deprecated
    public Long start;
    @Deprecated
    public Long oldPosition;
    @Deprecated
    public Long end;
    @Deprecated
    public Integer mapq;
    @Deprecated
    public String readName;
    @Deprecated
    public String sequence;
    @Deprecated
    public String qual;
    @Deprecated
    public String cigar;
    @Deprecated
    public String oldCigar;
    @Deprecated
    public Integer basesTrimmedFromStart;
    @Deprecated
    public Integer basesTrimmedFromEnd;
    @Deprecated
    public Boolean readPaired;
    @Deprecated
    public Boolean properPair;
    @Deprecated
    public Boolean readMapped;
    @Deprecated
    public Boolean mateMapped;
    @Deprecated
    public Boolean firstOfPair;
    @Deprecated
    public Boolean secondOfPair;
    @Deprecated
    public Boolean failedVendorQualityChecks;
    @Deprecated
    public Boolean duplicateRead;
    @Deprecated
    public Boolean readNegativeStrand;
    @Deprecated
    public Boolean mateNegativeStrand;
    @Deprecated
    public Boolean primaryAlignment;
    @Deprecated
    public Boolean secondaryAlignment;
    @Deprecated
    public Boolean supplementaryAlignment;
    @Deprecated
    public String mismatchingPositions;
    @Deprecated
    public String origQual;
    @Deprecated
    public String attributes;
    @Deprecated
    public String recordGroupName;
    @Deprecated
    public String recordGroupSequencingCenter;
    @Deprecated
    public String recordGroupDescription;
    @Deprecated
    public Long recordGroupRunDateEpoch;
    @Deprecated
    public String recordGroupFlowOrder;
    @Deprecated
    public String recordGroupKeySequence;
    @Deprecated
    public String recordGroupLibrary;
    @Deprecated
    public Integer recordGroupPredictedMedianInsertSize;
    @Deprecated
    public String recordGroupPlatform;
    @Deprecated
    public String recordGroupPlatformUnit;
    @Deprecated
    public String recordGroupSample;
    @Deprecated
    public Long mateAlignmentStart;
    @Deprecated
    public Long mateAlignmentEnd;
    @Deprecated
    public Contig mateContig;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public AlignmentRecord() {
    }

    public AlignmentRecord(Contig contig, Long start, Long oldPosition, Long end, Integer mapq, String readName, String sequence, String qual, String cigar, String oldCigar, Integer basesTrimmedFromStart, Integer basesTrimmedFromEnd, Boolean readPaired, Boolean properPair, Boolean readMapped, Boolean mateMapped, Boolean firstOfPair, Boolean secondOfPair, Boolean failedVendorQualityChecks, Boolean duplicateRead, Boolean readNegativeStrand, Boolean mateNegativeStrand, Boolean primaryAlignment, Boolean secondaryAlignment, Boolean supplementaryAlignment, String mismatchingPositions, String origQual, String attributes, String recordGroupName, String recordGroupSequencingCenter, String recordGroupDescription, Long recordGroupRunDateEpoch, String recordGroupFlowOrder, String recordGroupKeySequence, String recordGroupLibrary, Integer recordGroupPredictedMedianInsertSize, String recordGroupPlatform, String recordGroupPlatformUnit, String recordGroupSample, Long mateAlignmentStart, Long mateAlignmentEnd, Contig mateContig) {
        this.contig = contig;
        this.start = start;
        this.oldPosition = oldPosition;
        this.end = end;
        this.mapq = mapq;
        this.readName = readName;
        this.sequence = sequence;
        this.qual = qual;
        this.cigar = cigar;
        this.oldCigar = oldCigar;
        this.basesTrimmedFromStart = basesTrimmedFromStart;
        this.basesTrimmedFromEnd = basesTrimmedFromEnd;
        this.readPaired = readPaired;
        this.properPair = properPair;
        this.readMapped = readMapped;
        this.mateMapped = mateMapped;
        this.firstOfPair = firstOfPair;
        this.secondOfPair = secondOfPair;
        this.failedVendorQualityChecks = failedVendorQualityChecks;
        this.duplicateRead = duplicateRead;
        this.readNegativeStrand = readNegativeStrand;
        this.mateNegativeStrand = mateNegativeStrand;
        this.primaryAlignment = primaryAlignment;
        this.secondaryAlignment = secondaryAlignment;
        this.supplementaryAlignment = supplementaryAlignment;
        this.mismatchingPositions = mismatchingPositions;
        this.origQual = origQual;
        this.attributes = attributes;
        this.recordGroupName = recordGroupName;
        this.recordGroupSequencingCenter = recordGroupSequencingCenter;
        this.recordGroupDescription = recordGroupDescription;
        this.recordGroupRunDateEpoch = recordGroupRunDateEpoch;
        this.recordGroupFlowOrder = recordGroupFlowOrder;
        this.recordGroupKeySequence = recordGroupKeySequence;
        this.recordGroupLibrary = recordGroupLibrary;
        this.recordGroupPredictedMedianInsertSize = recordGroupPredictedMedianInsertSize;
        this.recordGroupPlatform = recordGroupPlatform;
        this.recordGroupPlatformUnit = recordGroupPlatformUnit;
        this.recordGroupSample = recordGroupSample;
        this.mateAlignmentStart = mateAlignmentStart;
        this.mateAlignmentEnd = mateAlignmentEnd;
        this.mateContig = mateContig;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.contig;
            }
            case 1: {
                return this.start;
            }
            case 2: {
                return this.oldPosition;
            }
            case 3: {
                return this.end;
            }
            case 4: {
                return this.mapq;
            }
            case 5: {
                return this.readName;
            }
            case 6: {
                return this.sequence;
            }
            case 7: {
                return this.qual;
            }
            case 8: {
                return this.cigar;
            }
            case 9: {
                return this.oldCigar;
            }
            case 10: {
                return this.basesTrimmedFromStart;
            }
            case 11: {
                return this.basesTrimmedFromEnd;
            }
            case 12: {
                return this.readPaired;
            }
            case 13: {
                return this.properPair;
            }
            case 14: {
                return this.readMapped;
            }
            case 15: {
                return this.mateMapped;
            }
            case 16: {
                return this.firstOfPair;
            }
            case 17: {
                return this.secondOfPair;
            }
            case 18: {
                return this.failedVendorQualityChecks;
            }
            case 19: {
                return this.duplicateRead;
            }
            case 20: {
                return this.readNegativeStrand;
            }
            case 21: {
                return this.mateNegativeStrand;
            }
            case 22: {
                return this.primaryAlignment;
            }
            case 23: {
                return this.secondaryAlignment;
            }
            case 24: {
                return this.supplementaryAlignment;
            }
            case 25: {
                return this.mismatchingPositions;
            }
            case 26: {
                return this.origQual;
            }
            case 27: {
                return this.attributes;
            }
            case 28: {
                return this.recordGroupName;
            }
            case 29: {
                return this.recordGroupSequencingCenter;
            }
            case 30: {
                return this.recordGroupDescription;
            }
            case 31: {
                return this.recordGroupRunDateEpoch;
            }
            case 32: {
                return this.recordGroupFlowOrder;
            }
            case 33: {
                return this.recordGroupKeySequence;
            }
            case 34: {
                return this.recordGroupLibrary;
            }
            case 35: {
                return this.recordGroupPredictedMedianInsertSize;
            }
            case 36: {
                return this.recordGroupPlatform;
            }
            case 37: {
                return this.recordGroupPlatformUnit;
            }
            case 38: {
                return this.recordGroupSample;
            }
            case 39: {
                return this.mateAlignmentStart;
            }
            case 40: {
                return this.mateAlignmentEnd;
            }
            case 41: {
                return this.mateContig;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.contig = (Contig)((Object)value$);
                break;
            }
            case 1: {
                this.start = (Long)value$;
                break;
            }
            case 2: {
                this.oldPosition = (Long)value$;
                break;
            }
            case 3: {
                this.end = (Long)value$;
                break;
            }
            case 4: {
                this.mapq = (Integer)value$;
                break;
            }
            case 5: {
                this.readName = (String)value$;
                break;
            }
            case 6: {
                this.sequence = (String)value$;
                break;
            }
            case 7: {
                this.qual = (String)value$;
                break;
            }
            case 8: {
                this.cigar = (String)value$;
                break;
            }
            case 9: {
                this.oldCigar = (String)value$;
                break;
            }
            case 10: {
                this.basesTrimmedFromStart = (Integer)value$;
                break;
            }
            case 11: {
                this.basesTrimmedFromEnd = (Integer)value$;
                break;
            }
            case 12: {
                this.readPaired = (Boolean)value$;
                break;
            }
            case 13: {
                this.properPair = (Boolean)value$;
                break;
            }
            case 14: {
                this.readMapped = (Boolean)value$;
                break;
            }
            case 15: {
                this.mateMapped = (Boolean)value$;
                break;
            }
            case 16: {
                this.firstOfPair = (Boolean)value$;
                break;
            }
            case 17: {
                this.secondOfPair = (Boolean)value$;
                break;
            }
            case 18: {
                this.failedVendorQualityChecks = (Boolean)value$;
                break;
            }
            case 19: {
                this.duplicateRead = (Boolean)value$;
                break;
            }
            case 20: {
                this.readNegativeStrand = (Boolean)value$;
                break;
            }
            case 21: {
                this.mateNegativeStrand = (Boolean)value$;
                break;
            }
            case 22: {
                this.primaryAlignment = (Boolean)value$;
                break;
            }
            case 23: {
                this.secondaryAlignment = (Boolean)value$;
                break;
            }
            case 24: {
                this.supplementaryAlignment = (Boolean)value$;
                break;
            }
            case 25: {
                this.mismatchingPositions = (String)value$;
                break;
            }
            case 26: {
                this.origQual = (String)value$;
                break;
            }
            case 27: {
                this.attributes = (String)value$;
                break;
            }
            case 28: {
                this.recordGroupName = (String)value$;
                break;
            }
            case 29: {
                this.recordGroupSequencingCenter = (String)value$;
                break;
            }
            case 30: {
                this.recordGroupDescription = (String)value$;
                break;
            }
            case 31: {
                this.recordGroupRunDateEpoch = (Long)value$;
                break;
            }
            case 32: {
                this.recordGroupFlowOrder = (String)value$;
                break;
            }
            case 33: {
                this.recordGroupKeySequence = (String)value$;
                break;
            }
            case 34: {
                this.recordGroupLibrary = (String)value$;
                break;
            }
            case 35: {
                this.recordGroupPredictedMedianInsertSize = (Integer)value$;
                break;
            }
            case 36: {
                this.recordGroupPlatform = (String)value$;
                break;
            }
            case 37: {
                this.recordGroupPlatformUnit = (String)value$;
                break;
            }
            case 38: {
                this.recordGroupSample = (String)value$;
                break;
            }
            case 39: {
                this.mateAlignmentStart = (Long)value$;
                break;
            }
            case 40: {
                this.mateAlignmentEnd = (Long)value$;
                break;
            }
            case 41: {
                this.mateContig = (Contig)((Object)value$);
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Contig getContig() {
        return this.contig;
    }

    public void setContig(Contig value) {
        this.contig = value;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long value) {
        this.start = value;
    }

    public Long getOldPosition() {
        return this.oldPosition;
    }

    public void setOldPosition(Long value) {
        this.oldPosition = value;
    }

    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long value) {
        this.end = value;
    }

    public Integer getMapq() {
        return this.mapq;
    }

    public void setMapq(Integer value) {
        this.mapq = value;
    }

    public String getReadName() {
        return this.readName;
    }

    public void setReadName(String value) {
        this.readName = value;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String value) {
        this.sequence = value;
    }

    public String getQual() {
        return this.qual;
    }

    public void setQual(String value) {
        this.qual = value;
    }

    public String getCigar() {
        return this.cigar;
    }

    public void setCigar(String value) {
        this.cigar = value;
    }

    public String getOldCigar() {
        return this.oldCigar;
    }

    public void setOldCigar(String value) {
        this.oldCigar = value;
    }

    public Integer getBasesTrimmedFromStart() {
        return this.basesTrimmedFromStart;
    }

    public void setBasesTrimmedFromStart(Integer value) {
        this.basesTrimmedFromStart = value;
    }

    public Integer getBasesTrimmedFromEnd() {
        return this.basesTrimmedFromEnd;
    }

    public void setBasesTrimmedFromEnd(Integer value) {
        this.basesTrimmedFromEnd = value;
    }

    public Boolean getReadPaired() {
        return this.readPaired;
    }

    public void setReadPaired(Boolean value) {
        this.readPaired = value;
    }

    public Boolean getProperPair() {
        return this.properPair;
    }

    public void setProperPair(Boolean value) {
        this.properPair = value;
    }

    public Boolean getReadMapped() {
        return this.readMapped;
    }

    public void setReadMapped(Boolean value) {
        this.readMapped = value;
    }

    public Boolean getMateMapped() {
        return this.mateMapped;
    }

    public void setMateMapped(Boolean value) {
        this.mateMapped = value;
    }

    public Boolean getFirstOfPair() {
        return this.firstOfPair;
    }

    public void setFirstOfPair(Boolean value) {
        this.firstOfPair = value;
    }

    public Boolean getSecondOfPair() {
        return this.secondOfPair;
    }

    public void setSecondOfPair(Boolean value) {
        this.secondOfPair = value;
    }

    public Boolean getFailedVendorQualityChecks() {
        return this.failedVendorQualityChecks;
    }

    public void setFailedVendorQualityChecks(Boolean value) {
        this.failedVendorQualityChecks = value;
    }

    public Boolean getDuplicateRead() {
        return this.duplicateRead;
    }

    public void setDuplicateRead(Boolean value) {
        this.duplicateRead = value;
    }

    public Boolean getReadNegativeStrand() {
        return this.readNegativeStrand;
    }

    public void setReadNegativeStrand(Boolean value) {
        this.readNegativeStrand = value;
    }

    public Boolean getMateNegativeStrand() {
        return this.mateNegativeStrand;
    }

    public void setMateNegativeStrand(Boolean value) {
        this.mateNegativeStrand = value;
    }

    public Boolean getPrimaryAlignment() {
        return this.primaryAlignment;
    }

    public void setPrimaryAlignment(Boolean value) {
        this.primaryAlignment = value;
    }

    public Boolean getSecondaryAlignment() {
        return this.secondaryAlignment;
    }

    public void setSecondaryAlignment(Boolean value) {
        this.secondaryAlignment = value;
    }

    public Boolean getSupplementaryAlignment() {
        return this.supplementaryAlignment;
    }

    public void setSupplementaryAlignment(Boolean value) {
        this.supplementaryAlignment = value;
    }

    public String getMismatchingPositions() {
        return this.mismatchingPositions;
    }

    public void setMismatchingPositions(String value) {
        this.mismatchingPositions = value;
    }

    public String getOrigQual() {
        return this.origQual;
    }

    public void setOrigQual(String value) {
        this.origQual = value;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String value) {
        this.attributes = value;
    }

    public String getRecordGroupName() {
        return this.recordGroupName;
    }

    public void setRecordGroupName(String value) {
        this.recordGroupName = value;
    }

    public String getRecordGroupSequencingCenter() {
        return this.recordGroupSequencingCenter;
    }

    public void setRecordGroupSequencingCenter(String value) {
        this.recordGroupSequencingCenter = value;
    }

    public String getRecordGroupDescription() {
        return this.recordGroupDescription;
    }

    public void setRecordGroupDescription(String value) {
        this.recordGroupDescription = value;
    }

    public Long getRecordGroupRunDateEpoch() {
        return this.recordGroupRunDateEpoch;
    }

    public void setRecordGroupRunDateEpoch(Long value) {
        this.recordGroupRunDateEpoch = value;
    }

    public String getRecordGroupFlowOrder() {
        return this.recordGroupFlowOrder;
    }

    public void setRecordGroupFlowOrder(String value) {
        this.recordGroupFlowOrder = value;
    }

    public String getRecordGroupKeySequence() {
        return this.recordGroupKeySequence;
    }

    public void setRecordGroupKeySequence(String value) {
        this.recordGroupKeySequence = value;
    }

    public String getRecordGroupLibrary() {
        return this.recordGroupLibrary;
    }

    public void setRecordGroupLibrary(String value) {
        this.recordGroupLibrary = value;
    }

    public Integer getRecordGroupPredictedMedianInsertSize() {
        return this.recordGroupPredictedMedianInsertSize;
    }

    public void setRecordGroupPredictedMedianInsertSize(Integer value) {
        this.recordGroupPredictedMedianInsertSize = value;
    }

    public String getRecordGroupPlatform() {
        return this.recordGroupPlatform;
    }

    public void setRecordGroupPlatform(String value) {
        this.recordGroupPlatform = value;
    }

    public String getRecordGroupPlatformUnit() {
        return this.recordGroupPlatformUnit;
    }

    public void setRecordGroupPlatformUnit(String value) {
        this.recordGroupPlatformUnit = value;
    }

    public String getRecordGroupSample() {
        return this.recordGroupSample;
    }

    public void setRecordGroupSample(String value) {
        this.recordGroupSample = value;
    }

    public Long getMateAlignmentStart() {
        return this.mateAlignmentStart;
    }

    public void setMateAlignmentStart(Long value) {
        this.mateAlignmentStart = value;
    }

    public Long getMateAlignmentEnd() {
        return this.mateAlignmentEnd;
    }

    public void setMateAlignmentEnd(Long value) {
        this.mateAlignmentEnd = value;
    }

    public Contig getMateContig() {
        return this.mateContig;
    }

    public void setMateContig(Contig value) {
        this.mateContig = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(AlignmentRecord other) {
        return new Builder(other);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends SpecificRecordBuilderBase<AlignmentRecord>
    implements RecordBuilder<AlignmentRecord> {
        private Contig contig;
        private Long start;
        private Long oldPosition;
        private Long end;
        private Integer mapq;
        private String readName;
        private String sequence;
        private String qual;
        private String cigar;
        private String oldCigar;
        private Integer basesTrimmedFromStart;
        private Integer basesTrimmedFromEnd;
        private Boolean readPaired;
        private Boolean properPair;
        private Boolean readMapped;
        private Boolean mateMapped;
        private Boolean firstOfPair;
        private Boolean secondOfPair;
        private Boolean failedVendorQualityChecks;
        private Boolean duplicateRead;
        private Boolean readNegativeStrand;
        private Boolean mateNegativeStrand;
        private Boolean primaryAlignment;
        private Boolean secondaryAlignment;
        private Boolean supplementaryAlignment;
        private String mismatchingPositions;
        private String origQual;
        private String attributes;
        private String recordGroupName;
        private String recordGroupSequencingCenter;
        private String recordGroupDescription;
        private Long recordGroupRunDateEpoch;
        private String recordGroupFlowOrder;
        private String recordGroupKeySequence;
        private String recordGroupLibrary;
        private Integer recordGroupPredictedMedianInsertSize;
        private String recordGroupPlatform;
        private String recordGroupPlatformUnit;
        private String recordGroupSample;
        private Long mateAlignmentStart;
        private Long mateAlignmentEnd;
        private Contig mateContig;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
        }

        private Builder(AlignmentRecord other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.contig))) {
                this.contig = (Contig)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.contig));
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.start)) {
                this.start = (Long)this.data().deepCopy(this.fields()[1].schema(), (Object)other.start);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.oldPosition)) {
                this.oldPosition = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.oldPosition);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.end)) {
                this.end = (Long)this.data().deepCopy(this.fields()[3].schema(), (Object)other.end);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.mapq)) {
                this.mapq = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.mapq);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.readName)) {
                this.readName = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.readName);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.sequence)) {
                this.sequence = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.sequence);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.qual)) {
                this.qual = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.qual);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.cigar)) {
                this.cigar = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.cigar);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.oldCigar)) {
                this.oldCigar = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.oldCigar);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.basesTrimmedFromStart)) {
                this.basesTrimmedFromStart = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.basesTrimmedFromStart);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.basesTrimmedFromEnd)) {
                this.basesTrimmedFromEnd = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.basesTrimmedFromEnd);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.readPaired)) {
                this.readPaired = (Boolean)this.data().deepCopy(this.fields()[12].schema(), (Object)other.readPaired);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.properPair)) {
                this.properPair = (Boolean)this.data().deepCopy(this.fields()[13].schema(), (Object)other.properPair);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.readMapped)) {
                this.readMapped = (Boolean)this.data().deepCopy(this.fields()[14].schema(), (Object)other.readMapped);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.mateMapped)) {
                this.mateMapped = (Boolean)this.data().deepCopy(this.fields()[15].schema(), (Object)other.mateMapped);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.firstOfPair)) {
                this.firstOfPair = (Boolean)this.data().deepCopy(this.fields()[16].schema(), (Object)other.firstOfPair);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.secondOfPair)) {
                this.secondOfPair = (Boolean)this.data().deepCopy(this.fields()[17].schema(), (Object)other.secondOfPair);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.failedVendorQualityChecks)) {
                this.failedVendorQualityChecks = (Boolean)this.data().deepCopy(this.fields()[18].schema(), (Object)other.failedVendorQualityChecks);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.duplicateRead)) {
                this.duplicateRead = (Boolean)this.data().deepCopy(this.fields()[19].schema(), (Object)other.duplicateRead);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.readNegativeStrand)) {
                this.readNegativeStrand = (Boolean)this.data().deepCopy(this.fields()[20].schema(), (Object)other.readNegativeStrand);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.mateNegativeStrand)) {
                this.mateNegativeStrand = (Boolean)this.data().deepCopy(this.fields()[21].schema(), (Object)other.mateNegativeStrand);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.primaryAlignment)) {
                this.primaryAlignment = (Boolean)this.data().deepCopy(this.fields()[22].schema(), (Object)other.primaryAlignment);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.secondaryAlignment)) {
                this.secondaryAlignment = (Boolean)this.data().deepCopy(this.fields()[23].schema(), (Object)other.secondaryAlignment);
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.supplementaryAlignment)) {
                this.supplementaryAlignment = (Boolean)this.data().deepCopy(this.fields()[24].schema(), (Object)other.supplementaryAlignment);
                this.fieldSetFlags()[24] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)other.mismatchingPositions)) {
                this.mismatchingPositions = (String)this.data().deepCopy(this.fields()[25].schema(), (Object)other.mismatchingPositions);
                this.fieldSetFlags()[25] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)other.origQual)) {
                this.origQual = (String)this.data().deepCopy(this.fields()[26].schema(), (Object)other.origQual);
                this.fieldSetFlags()[26] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)other.attributes)) {
                this.attributes = (String)this.data().deepCopy(this.fields()[27].schema(), (Object)other.attributes);
                this.fieldSetFlags()[27] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.recordGroupName)) {
                this.recordGroupName = (String)this.data().deepCopy(this.fields()[28].schema(), (Object)other.recordGroupName);
                this.fieldSetFlags()[28] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)other.recordGroupSequencingCenter)) {
                this.recordGroupSequencingCenter = (String)this.data().deepCopy(this.fields()[29].schema(), (Object)other.recordGroupSequencingCenter);
                this.fieldSetFlags()[29] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[30], (Object)other.recordGroupDescription)) {
                this.recordGroupDescription = (String)this.data().deepCopy(this.fields()[30].schema(), (Object)other.recordGroupDescription);
                this.fieldSetFlags()[30] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[31], (Object)other.recordGroupRunDateEpoch)) {
                this.recordGroupRunDateEpoch = (Long)this.data().deepCopy(this.fields()[31].schema(), (Object)other.recordGroupRunDateEpoch);
                this.fieldSetFlags()[31] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[32], (Object)other.recordGroupFlowOrder)) {
                this.recordGroupFlowOrder = (String)this.data().deepCopy(this.fields()[32].schema(), (Object)other.recordGroupFlowOrder);
                this.fieldSetFlags()[32] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[33], (Object)other.recordGroupKeySequence)) {
                this.recordGroupKeySequence = (String)this.data().deepCopy(this.fields()[33].schema(), (Object)other.recordGroupKeySequence);
                this.fieldSetFlags()[33] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[34], (Object)other.recordGroupLibrary)) {
                this.recordGroupLibrary = (String)this.data().deepCopy(this.fields()[34].schema(), (Object)other.recordGroupLibrary);
                this.fieldSetFlags()[34] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[35], (Object)other.recordGroupPredictedMedianInsertSize)) {
                this.recordGroupPredictedMedianInsertSize = (Integer)this.data().deepCopy(this.fields()[35].schema(), (Object)other.recordGroupPredictedMedianInsertSize);
                this.fieldSetFlags()[35] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[36], (Object)other.recordGroupPlatform)) {
                this.recordGroupPlatform = (String)this.data().deepCopy(this.fields()[36].schema(), (Object)other.recordGroupPlatform);
                this.fieldSetFlags()[36] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[37], (Object)other.recordGroupPlatformUnit)) {
                this.recordGroupPlatformUnit = (String)this.data().deepCopy(this.fields()[37].schema(), (Object)other.recordGroupPlatformUnit);
                this.fieldSetFlags()[37] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[38], (Object)other.recordGroupSample)) {
                this.recordGroupSample = (String)this.data().deepCopy(this.fields()[38].schema(), (Object)other.recordGroupSample);
                this.fieldSetFlags()[38] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[39], (Object)other.mateAlignmentStart)) {
                this.mateAlignmentStart = (Long)this.data().deepCopy(this.fields()[39].schema(), (Object)other.mateAlignmentStart);
                this.fieldSetFlags()[39] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[40], (Object)other.mateAlignmentEnd)) {
                this.mateAlignmentEnd = (Long)this.data().deepCopy(this.fields()[40].schema(), (Object)other.mateAlignmentEnd);
                this.fieldSetFlags()[40] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[41], (Object)((Object)other.mateContig))) {
                this.mateContig = (Contig)((Object)this.data().deepCopy(this.fields()[41].schema(), (Object)other.mateContig));
                this.fieldSetFlags()[41] = true;
            }
        }

        public Contig getContig() {
            return this.contig;
        }

        public Builder setContig(Contig value) {
            this.validate(this.fields()[0], (Object)value);
            this.contig = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasContig() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearContig() {
            this.contig = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Long getStart() {
            return this.start;
        }

        public Builder setStart(Long value) {
            this.validate(this.fields()[1], value);
            this.start = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasStart() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearStart() {
            this.start = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Long getOldPosition() {
            return this.oldPosition;
        }

        public Builder setOldPosition(Long value) {
            this.validate(this.fields()[2], value);
            this.oldPosition = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasOldPosition() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearOldPosition() {
            this.oldPosition = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Long getEnd() {
            return this.end;
        }

        public Builder setEnd(Long value) {
            this.validate(this.fields()[3], value);
            this.end = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasEnd() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearEnd() {
            this.end = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getMapq() {
            return this.mapq;
        }

        public Builder setMapq(Integer value) {
            this.validate(this.fields()[4], value);
            this.mapq = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasMapq() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearMapq() {
            this.mapq = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getReadName() {
            return this.readName;
        }

        public Builder setReadName(String value) {
            this.validate(this.fields()[5], value);
            this.readName = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasReadName() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearReadName() {
            this.readName = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getSequence() {
            return this.sequence;
        }

        public Builder setSequence(String value) {
            this.validate(this.fields()[6], value);
            this.sequence = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasSequence() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearSequence() {
            this.sequence = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getQual() {
            return this.qual;
        }

        public Builder setQual(String value) {
            this.validate(this.fields()[7], value);
            this.qual = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasQual() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearQual() {
            this.qual = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public String getCigar() {
            return this.cigar;
        }

        public Builder setCigar(String value) {
            this.validate(this.fields()[8], value);
            this.cigar = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasCigar() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearCigar() {
            this.cigar = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public String getOldCigar() {
            return this.oldCigar;
        }

        public Builder setOldCigar(String value) {
            this.validate(this.fields()[9], value);
            this.oldCigar = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasOldCigar() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearOldCigar() {
            this.oldCigar = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Integer getBasesTrimmedFromStart() {
            return this.basesTrimmedFromStart;
        }

        public Builder setBasesTrimmedFromStart(Integer value) {
            this.validate(this.fields()[10], value);
            this.basesTrimmedFromStart = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasBasesTrimmedFromStart() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearBasesTrimmedFromStart() {
            this.basesTrimmedFromStart = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Integer getBasesTrimmedFromEnd() {
            return this.basesTrimmedFromEnd;
        }

        public Builder setBasesTrimmedFromEnd(Integer value) {
            this.validate(this.fields()[11], value);
            this.basesTrimmedFromEnd = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasBasesTrimmedFromEnd() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearBasesTrimmedFromEnd() {
            this.basesTrimmedFromEnd = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Boolean getReadPaired() {
            return this.readPaired;
        }

        public Builder setReadPaired(Boolean value) {
            this.validate(this.fields()[12], value);
            this.readPaired = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasReadPaired() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearReadPaired() {
            this.readPaired = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Boolean getProperPair() {
            return this.properPair;
        }

        public Builder setProperPair(Boolean value) {
            this.validate(this.fields()[13], value);
            this.properPair = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasProperPair() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearProperPair() {
            this.properPair = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Boolean getReadMapped() {
            return this.readMapped;
        }

        public Builder setReadMapped(Boolean value) {
            this.validate(this.fields()[14], value);
            this.readMapped = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasReadMapped() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearReadMapped() {
            this.readMapped = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Boolean getMateMapped() {
            return this.mateMapped;
        }

        public Builder setMateMapped(Boolean value) {
            this.validate(this.fields()[15], value);
            this.mateMapped = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasMateMapped() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearMateMapped() {
            this.mateMapped = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Boolean getFirstOfPair() {
            return this.firstOfPair;
        }

        public Builder setFirstOfPair(Boolean value) {
            this.validate(this.fields()[16], value);
            this.firstOfPair = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasFirstOfPair() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearFirstOfPair() {
            this.firstOfPair = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public Boolean getSecondOfPair() {
            return this.secondOfPair;
        }

        public Builder setSecondOfPair(Boolean value) {
            this.validate(this.fields()[17], value);
            this.secondOfPair = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasSecondOfPair() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearSecondOfPair() {
            this.secondOfPair = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public Boolean getFailedVendorQualityChecks() {
            return this.failedVendorQualityChecks;
        }

        public Builder setFailedVendorQualityChecks(Boolean value) {
            this.validate(this.fields()[18], value);
            this.failedVendorQualityChecks = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasFailedVendorQualityChecks() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearFailedVendorQualityChecks() {
            this.failedVendorQualityChecks = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public Boolean getDuplicateRead() {
            return this.duplicateRead;
        }

        public Builder setDuplicateRead(Boolean value) {
            this.validate(this.fields()[19], value);
            this.duplicateRead = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasDuplicateRead() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearDuplicateRead() {
            this.duplicateRead = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public Boolean getReadNegativeStrand() {
            return this.readNegativeStrand;
        }

        public Builder setReadNegativeStrand(Boolean value) {
            this.validate(this.fields()[20], value);
            this.readNegativeStrand = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasReadNegativeStrand() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearReadNegativeStrand() {
            this.readNegativeStrand = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public Boolean getMateNegativeStrand() {
            return this.mateNegativeStrand;
        }

        public Builder setMateNegativeStrand(Boolean value) {
            this.validate(this.fields()[21], value);
            this.mateNegativeStrand = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasMateNegativeStrand() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearMateNegativeStrand() {
            this.mateNegativeStrand = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public Boolean getPrimaryAlignment() {
            return this.primaryAlignment;
        }

        public Builder setPrimaryAlignment(Boolean value) {
            this.validate(this.fields()[22], value);
            this.primaryAlignment = value;
            this.fieldSetFlags()[22] = true;
            return this;
        }

        public boolean hasPrimaryAlignment() {
            return this.fieldSetFlags()[22];
        }

        public Builder clearPrimaryAlignment() {
            this.primaryAlignment = null;
            this.fieldSetFlags()[22] = false;
            return this;
        }

        public Boolean getSecondaryAlignment() {
            return this.secondaryAlignment;
        }

        public Builder setSecondaryAlignment(Boolean value) {
            this.validate(this.fields()[23], value);
            this.secondaryAlignment = value;
            this.fieldSetFlags()[23] = true;
            return this;
        }

        public boolean hasSecondaryAlignment() {
            return this.fieldSetFlags()[23];
        }

        public Builder clearSecondaryAlignment() {
            this.secondaryAlignment = null;
            this.fieldSetFlags()[23] = false;
            return this;
        }

        public Boolean getSupplementaryAlignment() {
            return this.supplementaryAlignment;
        }

        public Builder setSupplementaryAlignment(Boolean value) {
            this.validate(this.fields()[24], value);
            this.supplementaryAlignment = value;
            this.fieldSetFlags()[24] = true;
            return this;
        }

        public boolean hasSupplementaryAlignment() {
            return this.fieldSetFlags()[24];
        }

        public Builder clearSupplementaryAlignment() {
            this.supplementaryAlignment = null;
            this.fieldSetFlags()[24] = false;
            return this;
        }

        public String getMismatchingPositions() {
            return this.mismatchingPositions;
        }

        public Builder setMismatchingPositions(String value) {
            this.validate(this.fields()[25], value);
            this.mismatchingPositions = value;
            this.fieldSetFlags()[25] = true;
            return this;
        }

        public boolean hasMismatchingPositions() {
            return this.fieldSetFlags()[25];
        }

        public Builder clearMismatchingPositions() {
            this.mismatchingPositions = null;
            this.fieldSetFlags()[25] = false;
            return this;
        }

        public String getOrigQual() {
            return this.origQual;
        }

        public Builder setOrigQual(String value) {
            this.validate(this.fields()[26], value);
            this.origQual = value;
            this.fieldSetFlags()[26] = true;
            return this;
        }

        public boolean hasOrigQual() {
            return this.fieldSetFlags()[26];
        }

        public Builder clearOrigQual() {
            this.origQual = null;
            this.fieldSetFlags()[26] = false;
            return this;
        }

        public String getAttributes() {
            return this.attributes;
        }

        public Builder setAttributes(String value) {
            this.validate(this.fields()[27], value);
            this.attributes = value;
            this.fieldSetFlags()[27] = true;
            return this;
        }

        public boolean hasAttributes() {
            return this.fieldSetFlags()[27];
        }

        public Builder clearAttributes() {
            this.attributes = null;
            this.fieldSetFlags()[27] = false;
            return this;
        }

        public String getRecordGroupName() {
            return this.recordGroupName;
        }

        public Builder setRecordGroupName(String value) {
            this.validate(this.fields()[28], value);
            this.recordGroupName = value;
            this.fieldSetFlags()[28] = true;
            return this;
        }

        public boolean hasRecordGroupName() {
            return this.fieldSetFlags()[28];
        }

        public Builder clearRecordGroupName() {
            this.recordGroupName = null;
            this.fieldSetFlags()[28] = false;
            return this;
        }

        public String getRecordGroupSequencingCenter() {
            return this.recordGroupSequencingCenter;
        }

        public Builder setRecordGroupSequencingCenter(String value) {
            this.validate(this.fields()[29], value);
            this.recordGroupSequencingCenter = value;
            this.fieldSetFlags()[29] = true;
            return this;
        }

        public boolean hasRecordGroupSequencingCenter() {
            return this.fieldSetFlags()[29];
        }

        public Builder clearRecordGroupSequencingCenter() {
            this.recordGroupSequencingCenter = null;
            this.fieldSetFlags()[29] = false;
            return this;
        }

        public String getRecordGroupDescription() {
            return this.recordGroupDescription;
        }

        public Builder setRecordGroupDescription(String value) {
            this.validate(this.fields()[30], value);
            this.recordGroupDescription = value;
            this.fieldSetFlags()[30] = true;
            return this;
        }

        public boolean hasRecordGroupDescription() {
            return this.fieldSetFlags()[30];
        }

        public Builder clearRecordGroupDescription() {
            this.recordGroupDescription = null;
            this.fieldSetFlags()[30] = false;
            return this;
        }

        public Long getRecordGroupRunDateEpoch() {
            return this.recordGroupRunDateEpoch;
        }

        public Builder setRecordGroupRunDateEpoch(Long value) {
            this.validate(this.fields()[31], value);
            this.recordGroupRunDateEpoch = value;
            this.fieldSetFlags()[31] = true;
            return this;
        }

        public boolean hasRecordGroupRunDateEpoch() {
            return this.fieldSetFlags()[31];
        }

        public Builder clearRecordGroupRunDateEpoch() {
            this.recordGroupRunDateEpoch = null;
            this.fieldSetFlags()[31] = false;
            return this;
        }

        public String getRecordGroupFlowOrder() {
            return this.recordGroupFlowOrder;
        }

        public Builder setRecordGroupFlowOrder(String value) {
            this.validate(this.fields()[32], value);
            this.recordGroupFlowOrder = value;
            this.fieldSetFlags()[32] = true;
            return this;
        }

        public boolean hasRecordGroupFlowOrder() {
            return this.fieldSetFlags()[32];
        }

        public Builder clearRecordGroupFlowOrder() {
            this.recordGroupFlowOrder = null;
            this.fieldSetFlags()[32] = false;
            return this;
        }

        public String getRecordGroupKeySequence() {
            return this.recordGroupKeySequence;
        }

        public Builder setRecordGroupKeySequence(String value) {
            this.validate(this.fields()[33], value);
            this.recordGroupKeySequence = value;
            this.fieldSetFlags()[33] = true;
            return this;
        }

        public boolean hasRecordGroupKeySequence() {
            return this.fieldSetFlags()[33];
        }

        public Builder clearRecordGroupKeySequence() {
            this.recordGroupKeySequence = null;
            this.fieldSetFlags()[33] = false;
            return this;
        }

        public String getRecordGroupLibrary() {
            return this.recordGroupLibrary;
        }

        public Builder setRecordGroupLibrary(String value) {
            this.validate(this.fields()[34], value);
            this.recordGroupLibrary = value;
            this.fieldSetFlags()[34] = true;
            return this;
        }

        public boolean hasRecordGroupLibrary() {
            return this.fieldSetFlags()[34];
        }

        public Builder clearRecordGroupLibrary() {
            this.recordGroupLibrary = null;
            this.fieldSetFlags()[34] = false;
            return this;
        }

        public Integer getRecordGroupPredictedMedianInsertSize() {
            return this.recordGroupPredictedMedianInsertSize;
        }

        public Builder setRecordGroupPredictedMedianInsertSize(Integer value) {
            this.validate(this.fields()[35], value);
            this.recordGroupPredictedMedianInsertSize = value;
            this.fieldSetFlags()[35] = true;
            return this;
        }

        public boolean hasRecordGroupPredictedMedianInsertSize() {
            return this.fieldSetFlags()[35];
        }

        public Builder clearRecordGroupPredictedMedianInsertSize() {
            this.recordGroupPredictedMedianInsertSize = null;
            this.fieldSetFlags()[35] = false;
            return this;
        }

        public String getRecordGroupPlatform() {
            return this.recordGroupPlatform;
        }

        public Builder setRecordGroupPlatform(String value) {
            this.validate(this.fields()[36], value);
            this.recordGroupPlatform = value;
            this.fieldSetFlags()[36] = true;
            return this;
        }

        public boolean hasRecordGroupPlatform() {
            return this.fieldSetFlags()[36];
        }

        public Builder clearRecordGroupPlatform() {
            this.recordGroupPlatform = null;
            this.fieldSetFlags()[36] = false;
            return this;
        }

        public String getRecordGroupPlatformUnit() {
            return this.recordGroupPlatformUnit;
        }

        public Builder setRecordGroupPlatformUnit(String value) {
            this.validate(this.fields()[37], value);
            this.recordGroupPlatformUnit = value;
            this.fieldSetFlags()[37] = true;
            return this;
        }

        public boolean hasRecordGroupPlatformUnit() {
            return this.fieldSetFlags()[37];
        }

        public Builder clearRecordGroupPlatformUnit() {
            this.recordGroupPlatformUnit = null;
            this.fieldSetFlags()[37] = false;
            return this;
        }

        public String getRecordGroupSample() {
            return this.recordGroupSample;
        }

        public Builder setRecordGroupSample(String value) {
            this.validate(this.fields()[38], value);
            this.recordGroupSample = value;
            this.fieldSetFlags()[38] = true;
            return this;
        }

        public boolean hasRecordGroupSample() {
            return this.fieldSetFlags()[38];
        }

        public Builder clearRecordGroupSample() {
            this.recordGroupSample = null;
            this.fieldSetFlags()[38] = false;
            return this;
        }

        public Long getMateAlignmentStart() {
            return this.mateAlignmentStart;
        }

        public Builder setMateAlignmentStart(Long value) {
            this.validate(this.fields()[39], value);
            this.mateAlignmentStart = value;
            this.fieldSetFlags()[39] = true;
            return this;
        }

        public boolean hasMateAlignmentStart() {
            return this.fieldSetFlags()[39];
        }

        public Builder clearMateAlignmentStart() {
            this.mateAlignmentStart = null;
            this.fieldSetFlags()[39] = false;
            return this;
        }

        public Long getMateAlignmentEnd() {
            return this.mateAlignmentEnd;
        }

        public Builder setMateAlignmentEnd(Long value) {
            this.validate(this.fields()[40], value);
            this.mateAlignmentEnd = value;
            this.fieldSetFlags()[40] = true;
            return this;
        }

        public boolean hasMateAlignmentEnd() {
            return this.fieldSetFlags()[40];
        }

        public Builder clearMateAlignmentEnd() {
            this.mateAlignmentEnd = null;
            this.fieldSetFlags()[40] = false;
            return this;
        }

        public Contig getMateContig() {
            return this.mateContig;
        }

        public Builder setMateContig(Contig value) {
            this.validate(this.fields()[41], (Object)value);
            this.mateContig = value;
            this.fieldSetFlags()[41] = true;
            return this;
        }

        public boolean hasMateContig() {
            return this.fieldSetFlags()[41];
        }

        public Builder clearMateContig() {
            this.mateContig = null;
            this.fieldSetFlags()[41] = false;
            return this;
        }

        public AlignmentRecord build() {
            try {
                AlignmentRecord record = new AlignmentRecord();
                record.contig = this.fieldSetFlags()[0] ? this.contig : (Contig)((Object)this.defaultValue(this.fields()[0]));
                record.start = this.fieldSetFlags()[1] ? this.start : (Long)this.defaultValue(this.fields()[1]);
                record.oldPosition = this.fieldSetFlags()[2] ? this.oldPosition : (Long)this.defaultValue(this.fields()[2]);
                record.end = this.fieldSetFlags()[3] ? this.end : (Long)this.defaultValue(this.fields()[3]);
                record.mapq = this.fieldSetFlags()[4] ? this.mapq : (Integer)this.defaultValue(this.fields()[4]);
                record.readName = this.fieldSetFlags()[5] ? this.readName : (String)this.defaultValue(this.fields()[5]);
                record.sequence = this.fieldSetFlags()[6] ? this.sequence : (String)this.defaultValue(this.fields()[6]);
                record.qual = this.fieldSetFlags()[7] ? this.qual : (String)this.defaultValue(this.fields()[7]);
                record.cigar = this.fieldSetFlags()[8] ? this.cigar : (String)this.defaultValue(this.fields()[8]);
                record.oldCigar = this.fieldSetFlags()[9] ? this.oldCigar : (String)this.defaultValue(this.fields()[9]);
                record.basesTrimmedFromStart = this.fieldSetFlags()[10] ? this.basesTrimmedFromStart : (Integer)this.defaultValue(this.fields()[10]);
                record.basesTrimmedFromEnd = this.fieldSetFlags()[11] ? this.basesTrimmedFromEnd : (Integer)this.defaultValue(this.fields()[11]);
                record.readPaired = this.fieldSetFlags()[12] ? this.readPaired : (Boolean)this.defaultValue(this.fields()[12]);
                record.properPair = this.fieldSetFlags()[13] ? this.properPair : (Boolean)this.defaultValue(this.fields()[13]);
                record.readMapped = this.fieldSetFlags()[14] ? this.readMapped : (Boolean)this.defaultValue(this.fields()[14]);
                record.mateMapped = this.fieldSetFlags()[15] ? this.mateMapped : (Boolean)this.defaultValue(this.fields()[15]);
                record.firstOfPair = this.fieldSetFlags()[16] ? this.firstOfPair : (Boolean)this.defaultValue(this.fields()[16]);
                record.secondOfPair = this.fieldSetFlags()[17] ? this.secondOfPair : (Boolean)this.defaultValue(this.fields()[17]);
                record.failedVendorQualityChecks = this.fieldSetFlags()[18] ? this.failedVendorQualityChecks : (Boolean)this.defaultValue(this.fields()[18]);
                record.duplicateRead = this.fieldSetFlags()[19] ? this.duplicateRead : (Boolean)this.defaultValue(this.fields()[19]);
                record.readNegativeStrand = this.fieldSetFlags()[20] ? this.readNegativeStrand : (Boolean)this.defaultValue(this.fields()[20]);
                record.mateNegativeStrand = this.fieldSetFlags()[21] ? this.mateNegativeStrand : (Boolean)this.defaultValue(this.fields()[21]);
                record.primaryAlignment = this.fieldSetFlags()[22] ? this.primaryAlignment : (Boolean)this.defaultValue(this.fields()[22]);
                record.secondaryAlignment = this.fieldSetFlags()[23] ? this.secondaryAlignment : (Boolean)this.defaultValue(this.fields()[23]);
                record.supplementaryAlignment = this.fieldSetFlags()[24] ? this.supplementaryAlignment : (Boolean)this.defaultValue(this.fields()[24]);
                record.mismatchingPositions = this.fieldSetFlags()[25] ? this.mismatchingPositions : (String)this.defaultValue(this.fields()[25]);
                record.origQual = this.fieldSetFlags()[26] ? this.origQual : (String)this.defaultValue(this.fields()[26]);
                record.attributes = this.fieldSetFlags()[27] ? this.attributes : (String)this.defaultValue(this.fields()[27]);
                record.recordGroupName = this.fieldSetFlags()[28] ? this.recordGroupName : (String)this.defaultValue(this.fields()[28]);
                record.recordGroupSequencingCenter = this.fieldSetFlags()[29] ? this.recordGroupSequencingCenter : (String)this.defaultValue(this.fields()[29]);
                record.recordGroupDescription = this.fieldSetFlags()[30] ? this.recordGroupDescription : (String)this.defaultValue(this.fields()[30]);
                record.recordGroupRunDateEpoch = this.fieldSetFlags()[31] ? this.recordGroupRunDateEpoch : (Long)this.defaultValue(this.fields()[31]);
                record.recordGroupFlowOrder = this.fieldSetFlags()[32] ? this.recordGroupFlowOrder : (String)this.defaultValue(this.fields()[32]);
                record.recordGroupKeySequence = this.fieldSetFlags()[33] ? this.recordGroupKeySequence : (String)this.defaultValue(this.fields()[33]);
                record.recordGroupLibrary = this.fieldSetFlags()[34] ? this.recordGroupLibrary : (String)this.defaultValue(this.fields()[34]);
                record.recordGroupPredictedMedianInsertSize = this.fieldSetFlags()[35] ? this.recordGroupPredictedMedianInsertSize : (Integer)this.defaultValue(this.fields()[35]);
                record.recordGroupPlatform = this.fieldSetFlags()[36] ? this.recordGroupPlatform : (String)this.defaultValue(this.fields()[36]);
                record.recordGroupPlatformUnit = this.fieldSetFlags()[37] ? this.recordGroupPlatformUnit : (String)this.defaultValue(this.fields()[37]);
                record.recordGroupSample = this.fieldSetFlags()[38] ? this.recordGroupSample : (String)this.defaultValue(this.fields()[38]);
                record.mateAlignmentStart = this.fieldSetFlags()[39] ? this.mateAlignmentStart : (Long)this.defaultValue(this.fields()[39]);
                record.mateAlignmentEnd = this.fieldSetFlags()[40] ? this.mateAlignmentEnd : (Long)this.defaultValue(this.fields()[40]);
                record.mateContig = this.fieldSetFlags()[41] ? this.mateContig : (Contig)((Object)this.defaultValue(this.fields()[41]));
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

