/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.Contig;
import org.bdgenomics.formats.avro.Dbxref;
import org.bdgenomics.formats.avro.Strand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AvroGenerated
public class Feature
extends SpecificRecordBase
implements SpecificRecord {
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Feature\",\"namespace\":\"org.bdgenomics.formats.avro\",\"fields\":[{\"name\":\"featureId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Preferably unique ID for this Feature object\",\"default\":null},{\"name\":\"featureType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The type of feature this is (aka, \\\"track\\\").\\n   \\n   Examples are \\\"conservation\\\", \\\"centipede\\\", \\\"gene\\\"\",\"default\":null},{\"name\":\"source\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The original source for this feature.\\n   \\n   Path/filename/URL and/or the file type (e.g., BED, GFF, etc.)\",\"default\":null},{\"name\":\"contig\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Contig\",\"doc\":\"Record for describing a reference assembly. Not used for storing the contents\\n of said assembly.\\n\\n @see NucleotideContigFragment\",\"fields\":[{\"name\":\"contigName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this contig in the assembly (e.g., \\\"chr1\\\").\",\"default\":null},{\"name\":\"contigLength\",\"type\":[\"null\",\"long\"],\"doc\":\"The length of this contig.\",\"default\":null},{\"name\":\"contigMD5\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The MD5 checksum of the assembly for this contig.\",\"default\":null},{\"name\":\"referenceURL\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The URL at which this reference assembly can be found.\",\"default\":null},{\"name\":\"assembly\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this assembly (e.g., \\\"hg19\\\").\",\"default\":null},{\"name\":\"species\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The species that this assembly is for.\",\"default\":null}]}],\"doc\":\"The contig this feature is located on\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"Start coordinate on the contig\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"End coordinate on the contig\",\"default\":null},{\"name\":\"strand\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Strand\",\"symbols\":[\"Forward\",\"Reverse\",\"Independent\"]}],\"doc\":\"Strand information for this feature\",\"default\":null},{\"name\":\"value\",\"type\":[\"null\",\"double\"],\"doc\":\"The value associated with this feature (if double)\",\"default\":null},{\"name\":\"dbxrefs\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Dbxref\",\"fields\":[{\"name\":\"accession\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"db\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]}},\"doc\":\"Cross-references into other databases.\",\"default\":[]},{\"name\":\"parentIds\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"List of parent featureIds, for implementing feature hierachies/graphs.\",\"default\":[]},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Additional feature info that doesn't fit into the standard fields above.\\n   \\n   They are all encoded as (string, string) key-value pairs.\",\"default\":{}}]}");
    @Deprecated
    public String featureId;
    @Deprecated
    public String featureType;
    @Deprecated
    public String source;
    @Deprecated
    public Contig contig;
    @Deprecated
    public Long start;
    @Deprecated
    public Long end;
    @Deprecated
    public Strand strand;
    @Deprecated
    public Double value;
    @Deprecated
    public List<Dbxref> dbxrefs;
    @Deprecated
    public List<String> parentIds;
    @Deprecated
    public Map<String, String> attributes;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public Feature() {
    }

    public Feature(String featureId, String featureType, String source, Contig contig, Long start, Long end, Strand strand, Double value, List<Dbxref> dbxrefs, List<String> parentIds, Map<String, String> attributes) {
        this.featureId = featureId;
        this.featureType = featureType;
        this.source = source;
        this.contig = contig;
        this.start = start;
        this.end = end;
        this.strand = strand;
        this.value = value;
        this.dbxrefs = dbxrefs;
        this.parentIds = parentIds;
        this.attributes = attributes;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.featureId;
            }
            case 1: {
                return this.featureType;
            }
            case 2: {
                return this.source;
            }
            case 3: {
                return this.contig;
            }
            case 4: {
                return this.start;
            }
            case 5: {
                return this.end;
            }
            case 6: {
                return this.strand;
            }
            case 7: {
                return this.value;
            }
            case 8: {
                return this.dbxrefs;
            }
            case 9: {
                return this.parentIds;
            }
            case 10: {
                return this.attributes;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.featureId = (String)value$;
                break;
            }
            case 1: {
                this.featureType = (String)value$;
                break;
            }
            case 2: {
                this.source = (String)value$;
                break;
            }
            case 3: {
                this.contig = (Contig)((Object)value$);
                break;
            }
            case 4: {
                this.start = (Long)value$;
                break;
            }
            case 5: {
                this.end = (Long)value$;
                break;
            }
            case 6: {
                this.strand = (Strand)((Object)value$);
                break;
            }
            case 7: {
                this.value = (Double)value$;
                break;
            }
            case 8: {
                this.dbxrefs = (List)value$;
                break;
            }
            case 9: {
                this.parentIds = (List)value$;
                break;
            }
            case 10: {
                this.attributes = (Map)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(String value) {
        this.featureId = value;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(String value) {
        this.featureType = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    public Contig getContig() {
        return this.contig;
    }

    public void setContig(Contig value) {
        this.contig = value;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long value) {
        this.start = value;
    }

    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long value) {
        this.end = value;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public void setStrand(Strand value) {
        this.strand = value;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public List<Dbxref> getDbxrefs() {
        return this.dbxrefs;
    }

    public void setDbxrefs(List<Dbxref> value) {
        this.dbxrefs = value;
    }

    public List<String> getParentIds() {
        return this.parentIds;
    }

    public void setParentIds(List<String> value) {
        this.parentIds = value;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> value) {
        this.attributes = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Feature other) {
        return new Builder(other);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends SpecificRecordBuilderBase<Feature>
    implements RecordBuilder<Feature> {
        private String featureId;
        private String featureType;
        private String source;
        private Contig contig;
        private Long start;
        private Long end;
        private Strand strand;
        private Double value;
        private List<Dbxref> dbxrefs;
        private List<String> parentIds;
        private Map<String, String> attributes;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
        }

        private Builder(Feature other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.featureId)) {
                this.featureId = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.featureId);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.featureType)) {
                this.featureType = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.featureType);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.source)) {
                this.source = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.source);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.contig))) {
                this.contig = (Contig)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.contig));
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.start)) {
                this.start = (Long)this.data().deepCopy(this.fields()[4].schema(), (Object)other.start);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.end)) {
                this.end = (Long)this.data().deepCopy(this.fields()[5].schema(), (Object)other.end);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.strand))) {
                this.strand = (Strand)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.strand));
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.value)) {
                this.value = (Double)this.data().deepCopy(this.fields()[7].schema(), (Object)other.value);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], other.dbxrefs)) {
                this.dbxrefs = (List)this.data().deepCopy(this.fields()[8].schema(), other.dbxrefs);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], other.parentIds)) {
                this.parentIds = (List)this.data().deepCopy(this.fields()[9].schema(), other.parentIds);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], other.attributes)) {
                this.attributes = (Map)this.data().deepCopy(this.fields()[10].schema(), other.attributes);
                this.fieldSetFlags()[10] = true;
            }
        }

        public String getFeatureId() {
            return this.featureId;
        }

        public Builder setFeatureId(String value) {
            this.validate(this.fields()[0], value);
            this.featureId = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasFeatureId() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearFeatureId() {
            this.featureId = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getFeatureType() {
            return this.featureType;
        }

        public Builder setFeatureType(String value) {
            this.validate(this.fields()[1], value);
            this.featureType = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasFeatureType() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearFeatureType() {
            this.featureType = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setSource(String value) {
            this.validate(this.fields()[2], value);
            this.source = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSource() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSource() {
            this.source = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Contig getContig() {
            return this.contig;
        }

        public Builder setContig(Contig value) {
            this.validate(this.fields()[3], (Object)value);
            this.contig = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasContig() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearContig() {
            this.contig = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Long getStart() {
            return this.start;
        }

        public Builder setStart(Long value) {
            this.validate(this.fields()[4], value);
            this.start = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasStart() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearStart() {
            this.start = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Long getEnd() {
            return this.end;
        }

        public Builder setEnd(Long value) {
            this.validate(this.fields()[5], value);
            this.end = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasEnd() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearEnd() {
            this.end = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Strand getStrand() {
            return this.strand;
        }

        public Builder setStrand(Strand value) {
            this.validate(this.fields()[6], (Object)value);
            this.strand = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasStrand() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearStrand() {
            this.strand = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Double getValue() {
            return this.value;
        }

        public Builder setValue(Double value) {
            this.validate(this.fields()[7], value);
            this.value = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasValue() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearValue() {
            this.value = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public List<Dbxref> getDbxrefs() {
            return this.dbxrefs;
        }

        public Builder setDbxrefs(List<Dbxref> value) {
            this.validate(this.fields()[8], value);
            this.dbxrefs = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasDbxrefs() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearDbxrefs() {
            this.dbxrefs = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public List<String> getParentIds() {
            return this.parentIds;
        }

        public Builder setParentIds(List<String> value) {
            this.validate(this.fields()[9], value);
            this.parentIds = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasParentIds() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearParentIds() {
            this.parentIds = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public Builder setAttributes(Map<String, String> value) {
            this.validate(this.fields()[10], value);
            this.attributes = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasAttributes() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearAttributes() {
            this.attributes = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Feature build() {
            try {
                Feature record = new Feature();
                record.featureId = this.fieldSetFlags()[0] ? this.featureId : (String)this.defaultValue(this.fields()[0]);
                record.featureType = this.fieldSetFlags()[1] ? this.featureType : (String)this.defaultValue(this.fields()[1]);
                record.source = this.fieldSetFlags()[2] ? this.source : (String)this.defaultValue(this.fields()[2]);
                record.contig = this.fieldSetFlags()[3] ? this.contig : (Contig)((Object)this.defaultValue(this.fields()[3]));
                record.start = this.fieldSetFlags()[4] ? this.start : (Long)this.defaultValue(this.fields()[4]);
                record.end = this.fieldSetFlags()[5] ? this.end : (Long)this.defaultValue(this.fields()[5]);
                record.strand = this.fieldSetFlags()[6] ? this.strand : (Strand)((Object)this.defaultValue(this.fields()[6]));
                record.value = this.fieldSetFlags()[7] ? this.value : (Double)this.defaultValue(this.fields()[7]);
                record.dbxrefs = this.fieldSetFlags()[8] ? this.dbxrefs : (List)this.defaultValue(this.fields()[8]);
                record.parentIds = this.fieldSetFlags()[9] ? this.parentIds : (List)this.defaultValue(this.fields()[9]);
                record.attributes = this.fieldSetFlags()[10] ? this.attributes : (Map)this.defaultValue(this.fields()[10]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

