/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.Contig;

@AvroGenerated
public class NucleotideContigFragment
extends SpecificRecordBase
implements SpecificRecord {
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"NucleotideContigFragment\",\"namespace\":\"org.bdgenomics.formats.avro\",\"doc\":\"Stores a contig of nucleotides; this may be a reference chromosome, may be an\\n assembly, may be a BAC. Very long contigs (>1Mbp) need to be split into fragments.\\n It seems that they are too long to load in a single go. For best performance,\\n it seems like 10kbp is a good point at which to start splitting contigs into\\n fragments.\",\"fields\":[{\"name\":\"contig\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Contig\",\"doc\":\"Record for describing a reference assembly. Not used for storing the contents\\n of said assembly.\\n\\n @see NucleotideContigFragment\",\"fields\":[{\"name\":\"contigName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this contig in the assembly (e.g., \\\"chr1\\\").\",\"default\":null},{\"name\":\"contigLength\",\"type\":[\"null\",\"long\"],\"doc\":\"The length of this contig.\",\"default\":null},{\"name\":\"contigMD5\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The MD5 checksum of the assembly for this contig.\",\"default\":null},{\"name\":\"referenceURL\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The URL at which this reference assembly can be found.\",\"default\":null},{\"name\":\"assembly\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this assembly (e.g., \\\"hg19\\\").\",\"default\":null},{\"name\":\"species\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The species that this assembly is for.\",\"default\":null}]}],\"doc\":\"The contig identification descriptor for this contig.\",\"default\":null},{\"name\":\"description\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A description for this contig. When importing from FASTA, the FASTA header\\n   description line should be stored here.\",\"default\":null},{\"name\":\"fragmentSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The sequence of bases in this fragment.\",\"default\":null},{\"name\":\"fragmentNumber\",\"type\":[\"null\",\"int\"],\"doc\":\"In a fragmented contig, the position of this fragment in the set of fragments.\\n   Can be null if the contig is not fragmented.\",\"default\":null},{\"name\":\"fragmentStartPosition\",\"type\":[\"null\",\"long\"],\"doc\":\"The position of the first base of this fragment in the overall contig. E.g.,\\n   if all fragments are 10kbp and this is the third fragment in the contig,\\n   the start position would be 20000L.\",\"default\":null},{\"name\":\"numberOfFragmentsInContig\",\"type\":[\"null\",\"int\"],\"doc\":\"The total count of fragments that this contig has been broken into. Can be\\n   null if the contig is not fragmented.\",\"default\":null}]}");
    @Deprecated
    public Contig contig;
    @Deprecated
    public String description;
    @Deprecated
    public String fragmentSequence;
    @Deprecated
    public Integer fragmentNumber;
    @Deprecated
    public Long fragmentStartPosition;
    @Deprecated
    public Integer numberOfFragmentsInContig;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public NucleotideContigFragment() {
    }

    public NucleotideContigFragment(Contig contig, String description, String fragmentSequence, Integer fragmentNumber, Long fragmentStartPosition, Integer numberOfFragmentsInContig) {
        this.contig = contig;
        this.description = description;
        this.fragmentSequence = fragmentSequence;
        this.fragmentNumber = fragmentNumber;
        this.fragmentStartPosition = fragmentStartPosition;
        this.numberOfFragmentsInContig = numberOfFragmentsInContig;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.contig;
            }
            case 1: {
                return this.description;
            }
            case 2: {
                return this.fragmentSequence;
            }
            case 3: {
                return this.fragmentNumber;
            }
            case 4: {
                return this.fragmentStartPosition;
            }
            case 5: {
                return this.numberOfFragmentsInContig;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.contig = (Contig)((Object)value$);
                break;
            }
            case 1: {
                this.description = (String)value$;
                break;
            }
            case 2: {
                this.fragmentSequence = (String)value$;
                break;
            }
            case 3: {
                this.fragmentNumber = (Integer)value$;
                break;
            }
            case 4: {
                this.fragmentStartPosition = (Long)value$;
                break;
            }
            case 5: {
                this.numberOfFragmentsInContig = (Integer)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Contig getContig() {
        return this.contig;
    }

    public void setContig(Contig value) {
        this.contig = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getFragmentSequence() {
        return this.fragmentSequence;
    }

    public void setFragmentSequence(String value) {
        this.fragmentSequence = value;
    }

    public Integer getFragmentNumber() {
        return this.fragmentNumber;
    }

    public void setFragmentNumber(Integer value) {
        this.fragmentNumber = value;
    }

    public Long getFragmentStartPosition() {
        return this.fragmentStartPosition;
    }

    public void setFragmentStartPosition(Long value) {
        this.fragmentStartPosition = value;
    }

    public Integer getNumberOfFragmentsInContig() {
        return this.numberOfFragmentsInContig;
    }

    public void setNumberOfFragmentsInContig(Integer value) {
        this.numberOfFragmentsInContig = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(NucleotideContigFragment other) {
        return new Builder(other);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends SpecificRecordBuilderBase<NucleotideContigFragment>
    implements RecordBuilder<NucleotideContigFragment> {
        private Contig contig;
        private String description;
        private String fragmentSequence;
        private Integer fragmentNumber;
        private Long fragmentStartPosition;
        private Integer numberOfFragmentsInContig;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
        }

        private Builder(NucleotideContigFragment other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.contig))) {
                this.contig = (Contig)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.contig));
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.description)) {
                this.description = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.description);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.fragmentSequence)) {
                this.fragmentSequence = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.fragmentSequence);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.fragmentNumber)) {
                this.fragmentNumber = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.fragmentNumber);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.fragmentStartPosition)) {
                this.fragmentStartPosition = (Long)this.data().deepCopy(this.fields()[4].schema(), (Object)other.fragmentStartPosition);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.numberOfFragmentsInContig)) {
                this.numberOfFragmentsInContig = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.numberOfFragmentsInContig);
                this.fieldSetFlags()[5] = true;
            }
        }

        public Contig getContig() {
            return this.contig;
        }

        public Builder setContig(Contig value) {
            this.validate(this.fields()[0], (Object)value);
            this.contig = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasContig() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearContig() {
            this.contig = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String value) {
            this.validate(this.fields()[1], value);
            this.description = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasDescription() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearDescription() {
            this.description = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getFragmentSequence() {
            return this.fragmentSequence;
        }

        public Builder setFragmentSequence(String value) {
            this.validate(this.fields()[2], value);
            this.fragmentSequence = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasFragmentSequence() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearFragmentSequence() {
            this.fragmentSequence = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getFragmentNumber() {
            return this.fragmentNumber;
        }

        public Builder setFragmentNumber(Integer value) {
            this.validate(this.fields()[3], value);
            this.fragmentNumber = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasFragmentNumber() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearFragmentNumber() {
            this.fragmentNumber = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Long getFragmentStartPosition() {
            return this.fragmentStartPosition;
        }

        public Builder setFragmentStartPosition(Long value) {
            this.validate(this.fields()[4], value);
            this.fragmentStartPosition = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasFragmentStartPosition() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearFragmentStartPosition() {
            this.fragmentStartPosition = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getNumberOfFragmentsInContig() {
            return this.numberOfFragmentsInContig;
        }

        public Builder setNumberOfFragmentsInContig(Integer value) {
            this.validate(this.fields()[5], value);
            this.numberOfFragmentsInContig = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasNumberOfFragmentsInContig() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearNumberOfFragmentsInContig() {
            this.numberOfFragmentsInContig = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public NucleotideContigFragment build() {
            try {
                NucleotideContigFragment record = new NucleotideContigFragment();
                record.contig = this.fieldSetFlags()[0] ? this.contig : (Contig)((Object)this.defaultValue(this.fields()[0]));
                record.description = this.fieldSetFlags()[1] ? this.description : (String)this.defaultValue(this.fields()[1]);
                record.fragmentSequence = this.fieldSetFlags()[2] ? this.fragmentSequence : (String)this.defaultValue(this.fields()[2]);
                record.fragmentNumber = this.fieldSetFlags()[3] ? this.fragmentNumber : (Integer)this.defaultValue(this.fields()[3]);
                record.fragmentStartPosition = this.fieldSetFlags()[4] ? this.fragmentStartPosition : (Long)this.defaultValue(this.fields()[4]);
                record.numberOfFragmentsInContig = this.fieldSetFlags()[5] ? this.numberOfFragmentsInContig : (Integer)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

