/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.Contig;
import org.bdgenomics.formats.avro.StructuralVariant;

@AvroGenerated
public class Variant
extends SpecificRecordBase
implements SpecificRecord {
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Variant\",\"namespace\":\"org.bdgenomics.formats.avro\",\"fields\":[{\"name\":\"contig\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Contig\",\"doc\":\"Record for describing a reference assembly. Not used for storing the contents\\n of said assembly.\\n\\n @see NucleotideContigFragment\",\"fields\":[{\"name\":\"contigName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this contig in the assembly (e.g., \\\"chr1\\\").\",\"default\":null},{\"name\":\"contigLength\",\"type\":[\"null\",\"long\"],\"doc\":\"The length of this contig.\",\"default\":null},{\"name\":\"contigMD5\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The MD5 checksum of the assembly for this contig.\",\"default\":null},{\"name\":\"referenceURL\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The URL at which this reference assembly can be found.\",\"default\":null},{\"name\":\"assembly\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this assembly (e.g., \\\"hg19\\\").\",\"default\":null},{\"name\":\"species\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The species that this assembly is for.\",\"default\":null}]}],\"doc\":\"The reference contig that this variant exists on.\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"The 0-based start position of this variant on the reference contig.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"The 0-based, exclusive end position of this variant on the reference contig.\",\"default\":null},{\"name\":\"referenceAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A string describing the reference allele at this site.\",\"default\":null},{\"name\":\"alternateAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A string describing the variant allele at this site. Should be left null if\\n   the site is a structural variant.\",\"default\":null},{\"name\":\"svAllele\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"StructuralVariant\",\"fields\":[{\"name\":\"type\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"StructuralVariantType\",\"doc\":\"Descriptors for the type of a structural variant. The most specific descriptor\\n should be used, if possible. E.g., duplication should be used instead of\\n insertion if the inserted sequence is not novel. Tandem duplication should\\n be used instead of duplication if the duplication is known to follow the\\n duplicated sequence.\",\"symbols\":[\"DELETION\",\"INSERTION\",\"INVERSION\",\"MOBILE_INSERTION\",\"MOBILE_DELETION\",\"DUPLICATION\",\"TANDEM_DUPLICATION\"]}],\"doc\":\"The type of this structural variant.\",\"default\":null},{\"name\":\"assembly\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The URL of the FASTA/NucleotideContig assembly for this structural variant,\\n   if one is available.\",\"default\":null},{\"name\":\"precise\",\"type\":[\"boolean\",\"null\"],\"doc\":\"Whether this structural variant call has precise breakpoints or not. Default\\n   value is true. If the call is imprecise, confidence intervals should be provided.\",\"default\":true},{\"name\":\"startWindow\",\"type\":[\"null\",\"int\"],\"doc\":\"The size of the confidence window around the start of the structural variant.\",\"default\":null},{\"name\":\"endWindow\",\"type\":[\"null\",\"int\"],\"doc\":\"The size of the confidence window around the end of the structural variant.\",\"default\":null}]}],\"doc\":\"The structural variant at this site, if the alternate allele is a structural\\n   variant. If the site is not a structural variant, this field should be left \\n   null.\",\"default\":null}]}");
    @Deprecated
    public Contig contig;
    @Deprecated
    public Long start;
    @Deprecated
    public Long end;
    @Deprecated
    public String referenceAllele;
    @Deprecated
    public String alternateAllele;
    @Deprecated
    public StructuralVariant svAllele;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public Variant() {
    }

    public Variant(Contig contig, Long start, Long end, String referenceAllele, String alternateAllele, StructuralVariant svAllele) {
        this.contig = contig;
        this.start = start;
        this.end = end;
        this.referenceAllele = referenceAllele;
        this.alternateAllele = alternateAllele;
        this.svAllele = svAllele;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.contig;
            }
            case 1: {
                return this.start;
            }
            case 2: {
                return this.end;
            }
            case 3: {
                return this.referenceAllele;
            }
            case 4: {
                return this.alternateAllele;
            }
            case 5: {
                return this.svAllele;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.contig = (Contig)((Object)value$);
                break;
            }
            case 1: {
                this.start = (Long)value$;
                break;
            }
            case 2: {
                this.end = (Long)value$;
                break;
            }
            case 3: {
                this.referenceAllele = (String)value$;
                break;
            }
            case 4: {
                this.alternateAllele = (String)value$;
                break;
            }
            case 5: {
                this.svAllele = (StructuralVariant)((Object)value$);
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Contig getContig() {
        return this.contig;
    }

    public void setContig(Contig value) {
        this.contig = value;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long value) {
        this.start = value;
    }

    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long value) {
        this.end = value;
    }

    public String getReferenceAllele() {
        return this.referenceAllele;
    }

    public void setReferenceAllele(String value) {
        this.referenceAllele = value;
    }

    public String getAlternateAllele() {
        return this.alternateAllele;
    }

    public void setAlternateAllele(String value) {
        this.alternateAllele = value;
    }

    public StructuralVariant getSvAllele() {
        return this.svAllele;
    }

    public void setSvAllele(StructuralVariant value) {
        this.svAllele = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Variant other) {
        return new Builder(other);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends SpecificRecordBuilderBase<Variant>
    implements RecordBuilder<Variant> {
        private Contig contig;
        private Long start;
        private Long end;
        private String referenceAllele;
        private String alternateAllele;
        private StructuralVariant svAllele;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
        }

        private Builder(Variant other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.contig))) {
                this.contig = (Contig)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.contig));
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.start)) {
                this.start = (Long)this.data().deepCopy(this.fields()[1].schema(), (Object)other.start);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.end)) {
                this.end = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.end);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.referenceAllele)) {
                this.referenceAllele = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.referenceAllele);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.alternateAllele)) {
                this.alternateAllele = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.alternateAllele);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.svAllele))) {
                this.svAllele = (StructuralVariant)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.svAllele));
                this.fieldSetFlags()[5] = true;
            }
        }

        public Contig getContig() {
            return this.contig;
        }

        public Builder setContig(Contig value) {
            this.validate(this.fields()[0], (Object)value);
            this.contig = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasContig() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearContig() {
            this.contig = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Long getStart() {
            return this.start;
        }

        public Builder setStart(Long value) {
            this.validate(this.fields()[1], value);
            this.start = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasStart() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearStart() {
            this.start = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Long getEnd() {
            return this.end;
        }

        public Builder setEnd(Long value) {
            this.validate(this.fields()[2], value);
            this.end = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasEnd() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearEnd() {
            this.end = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getReferenceAllele() {
            return this.referenceAllele;
        }

        public Builder setReferenceAllele(String value) {
            this.validate(this.fields()[3], value);
            this.referenceAllele = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasReferenceAllele() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearReferenceAllele() {
            this.referenceAllele = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getAlternateAllele() {
            return this.alternateAllele;
        }

        public Builder setAlternateAllele(String value) {
            this.validate(this.fields()[4], value);
            this.alternateAllele = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasAlternateAllele() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearAlternateAllele() {
            this.alternateAllele = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public StructuralVariant getSvAllele() {
            return this.svAllele;
        }

        public Builder setSvAllele(StructuralVariant value) {
            this.validate(this.fields()[5], (Object)value);
            this.svAllele = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasSvAllele() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearSvAllele() {
            this.svAllele = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Variant build() {
            try {
                Variant record = new Variant();
                record.contig = this.fieldSetFlags()[0] ? this.contig : (Contig)((Object)this.defaultValue(this.fields()[0]));
                record.start = this.fieldSetFlags()[1] ? this.start : (Long)this.defaultValue(this.fields()[1]);
                record.end = this.fieldSetFlags()[2] ? this.end : (Long)this.defaultValue(this.fields()[2]);
                record.referenceAllele = this.fieldSetFlags()[3] ? this.referenceAllele : (String)this.defaultValue(this.fields()[3]);
                record.alternateAllele = this.fieldSetFlags()[4] ? this.alternateAllele : (String)this.defaultValue(this.fields()[4]);
                record.svAllele = this.fieldSetFlags()[5] ? this.svAllele : (StructuralVariant)((Object)this.defaultValue(this.fields()[5]));
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

