/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.LineReader;

public class SingleFastqInputFormat
extends FileInputFormat<Void, Text> {
    public RecordReader<Void, Text> createRecordReader(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        context.setStatus(genericSplit.toString());
        return new SingleFastqRecordReader(context.getConfiguration(), (FileSplit)genericSplit);
    }

    public static class SingleFastqRecordReader
    extends RecordReader<Void, Text> {
        private long start;
        private long end;
        private long pos;
        private Path file;
        private LineReader lineReader;
        private InputStream inputStream;
        private Text currentValue;
        private byte[] newline = "\n".getBytes();
        private static final int MAX_LINE_LENGTH = 10000;

        public SingleFastqRecordReader(Configuration conf, FileSplit split) throws IOException {
            this.file = split.getPath();
            this.start = split.getStart();
            this.end = this.start + split.getLength();
            FileSystem fs = this.file.getFileSystem(conf);
            FSDataInputStream fileIn = fs.open(this.file);
            CompressionCodecFactory codecFactory = new CompressionCodecFactory(conf);
            CompressionCodec codec = codecFactory.getCodec(this.file);
            if (codec == null) {
                this.positionAtFirstRecord(fileIn);
                this.inputStream = fileIn;
            } else {
                if (this.start != 0L) {
                    throw new RuntimeException("Start position for compressed file is not 0! (found " + this.start + ")");
                }
                this.inputStream = codec.createInputStream((InputStream)fileIn);
                this.end = Long.MAX_VALUE;
            }
            this.lineReader = new LineReader(this.inputStream);
        }

        private void positionAtFirstRecord(FSDataInputStream stream) throws IOException {
            Text buffer = new Text();
            stream.seek(this.start);
            LineReader reader = new LineReader((InputStream)stream);
            int bytesRead = 0;
            do {
                bytesRead = reader.readLine(buffer, (int)Math.min(10000L, this.end - this.start));
                int bufferLength = buffer.getLength();
                if (bytesRead > 0 && (bufferLength <= 0 || buffer.getBytes()[0] != 64)) {
                    this.start += (long)bytesRead;
                    continue;
                }
                long backtrackPosition = this.start + (long)bytesRead;
                bytesRead = reader.readLine(buffer, (int)Math.min(10000L, this.end - this.start));
                bytesRead = reader.readLine(buffer, (int)Math.min(10000L, this.end - this.start));
                if (bytesRead > 0 && buffer.getLength() > 0 && buffer.getBytes()[0] == 43) break;
                this.start = backtrackPosition;
                stream.seek(this.start);
                reader = new LineReader((InputStream)stream);
            } while (bytesRead > 0);
            stream.seek(this.start);
            this.pos = this.start;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public Void getCurrentKey() {
            return null;
        }

        public Text getCurrentValue() {
            return this.currentValue;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            this.currentValue = new Text();
            return this.next(this.currentValue);
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public Text createKey() {
            return new Text();
        }

        public Text createValue() {
            return new Text();
        }

        public long getPos() {
            return this.pos;
        }

        public float getProgress() {
            if (this.start == this.end) {
                return 1.0f;
            }
            return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
        }

        public String makePositionMessage() {
            return this.file.toString() + ":" + this.pos;
        }

        protected boolean lowLevelFastqRead(Text readName, Text value) throws IOException {
            readName.clear();
            long skipped = this.appendLineInto(readName, true);
            if (skipped == 0L) {
                return false;
            }
            if (readName.getBytes()[0] != 64) {
                throw new RuntimeException("unexpected fastq record didn't start with '@' at " + this.makePositionMessage() + ". Line: " + readName + ". \n");
            }
            value.append(readName.getBytes(), 0, readName.getLength());
            this.appendLineInto(value, false);
            this.appendLineInto(value, false);
            this.appendLineInto(value, false);
            return true;
        }

        public boolean next(Text value) throws IOException {
            if (this.pos >= this.end) {
                return false;
            }
            try {
                Text readName = new Text();
                value.clear();
                boolean gotData = this.lowLevelFastqRead(readName, value);
                return gotData;
            }
            catch (EOFException e) {
                throw new RuntimeException("unexpected end of file in fastq record at " + this.makePositionMessage());
            }
        }

        private int appendLineInto(Text dest, boolean eofOk) throws EOFException, IOException {
            Text buf = new Text();
            int bytesRead = this.lineReader.readLine(buf, 10000);
            if (bytesRead < 0 || bytesRead == 0 && !eofOk) {
                throw new EOFException();
            }
            dest.append(buf.getBytes(), 0, buf.getLength());
            dest.append(this.newline, 0, 1);
            this.pos += (long)bytesRead;
            return bytesRead;
        }
    }
}

