/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.StatsMonitor;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.TimedStopwatch;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.stats.StatsConfig;
import com.netflix.servo.tag.Tags;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class StatsTimer
extends StatsMonitor
implements Timer {
    private final TimeUnit timeUnit;
    private static final String UNIT = "unit";

    public StatsTimer(MonitorConfig baseConfig, StatsConfig statsConfig) {
        this(baseConfig, statsConfig, TimeUnit.MILLISECONDS, defaultExecutor);
    }

    public StatsTimer(MonitorConfig baseConfig, StatsConfig statsConfig, TimeUnit unit) {
        this(baseConfig, statsConfig, unit, defaultExecutor);
    }

    public StatsTimer(MonitorConfig config, StatsConfig statsConfig, TimeUnit unit, ScheduledExecutorService executor) {
        super(config, statsConfig, executor, "totalTime", false, Tags.newTag(UNIT, unit.name()));
        this.timeUnit = unit;
        this.startComputingStats();
    }

    @Override
    public Stopwatch start() {
        TimedStopwatch s = new TimedStopwatch(this);
        s.start();
        return s;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public void record(long duration, TimeUnit timeUnit) {
        this.record(this.timeUnit.convert(duration, timeUnit));
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("StatsMonitor", (Object)super.toString()).add("timeUnit", (Object)this.timeUnit).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof StatsTimer)) {
            return false;
        }
        StatsTimer m = (StatsTimer)obj;
        return super.equals(obj) && this.timeUnit.equals((Object)m.timeUnit);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.timeUnit});
    }

    @Override
    public long getCount() {
        return ((Number)this.count.getValue()).longValue();
    }

    public long getTotalTime() {
        return this.getTotalMeasurement();
    }
}

