/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Clock;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Datapoint;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.StepLong;

public final class StepCounter
extends AbstractMonitor<Number>
implements Counter {
    private final double stepSeconds;
    private final StepLong count;

    public StepCounter(MonitorConfig config, long step) {
        this(config, step, Clock.WALL);
    }

    StepCounter(MonitorConfig config, long step, Clock clock) {
        super(config.withAdditionalTag(DataSourceType.RATE));
        this.stepSeconds = (double)step / 1000.0;
        this.count = new StepLong(step, 0L, clock);
    }

    @Override
    public void increment() {
        this.count.current().incrementAndGet();
    }

    @Override
    public void increment(long amount) {
        if (amount > 0L) {
            this.count.current().addAndGet(amount);
        }
    }

    @Override
    public Number getValue() {
        Datapoint dp = this.count.poll();
        return dp.isUnknown() ? Double.NaN : (double)dp.getValue() / this.stepSeconds;
    }

    public long getCount() {
        return this.count.poll().getValue();
    }

    long getCurrentCount() {
        return this.count.current().get();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("count", (Object)this.getValue()).toString();
    }
}

