/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.Metric;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.ResettableMonitor;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonitorRegistryMetricPoller
implements MetricPoller {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorRegistryMetricPoller.class);
    private final MonitorRegistry registry;
    private final long cacheTTL;
    private final AtomicReference<List<Monitor<?>>> cachedMonitors = new AtomicReference();
    private final AtomicLong cacheLastUpdateTime = new AtomicLong(0L);
    private final TimeLimiter limiter;
    private final ExecutorService service;

    public MonitorRegistryMetricPoller() {
        this(DefaultMonitorRegistry.getInstance(), 0L, TimeUnit.MILLISECONDS, true);
    }

    public MonitorRegistryMetricPoller(MonitorRegistry registry) {
        this(registry, 0L, TimeUnit.MILLISECONDS, true);
    }

    public MonitorRegistryMetricPoller(MonitorRegistry registry, long cacheTTL, TimeUnit unit) {
        this(registry, cacheTTL, unit, true);
    }

    public MonitorRegistryMetricPoller(MonitorRegistry registry, long cacheTTL, TimeUnit unit, boolean useLimiter) {
        this.registry = registry;
        this.cacheTTL = TimeUnit.MILLISECONDS.convert(cacheTTL, unit);
        if (useLimiter) {
            ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ServoMonitorGetValueLimiter-%d").build();
            this.service = Executors.newSingleThreadExecutor(factory);
            this.limiter = new SimpleTimeLimiter(this.service);
        } else {
            this.service = null;
            this.limiter = null;
        }
    }

    private Object getValue(Monitor<?> monitor, boolean reset) {
        try {
            if (reset && monitor instanceof ResettableMonitor) {
                return ((ResettableMonitor)monitor).getAndResetValue();
            }
            if (this.limiter != null) {
                MonitorValueCallable c = new MonitorValueCallable(monitor);
                return this.limiter.callWithTimeout((Callable)c, 1L, TimeUnit.SECONDS, true);
            }
            return monitor.getValue();
        }
        catch (UncheckedTimeoutException e) {
            LOGGER.warn("timeout trying to get value for {}", (Object)monitor.getConfig());
        }
        catch (Exception e) {
            LOGGER.warn("failed to get value for " + monitor.getConfig(), (Throwable)e);
        }
        return null;
    }

    private void getMonitors(List<Monitor<?>> monitors, MetricFilter filter, Monitor<?> monitor) {
        if (monitor instanceof CompositeMonitor) {
            for (Monitor<?> m : ((CompositeMonitor)monitor).getMonitors()) {
                this.getMonitors(monitors, filter, m);
            }
        } else if (filter.matches(monitor.getConfig())) {
            monitors.add(monitor);
        }
    }

    private void refreshMonitorCache(MetricFilter filter) {
        long age = System.currentTimeMillis() - this.cacheLastUpdateTime.get();
        if (age > this.cacheTTL) {
            ArrayList monitors = Lists.newArrayList();
            for (Monitor<?> monitor : this.registry.getRegisteredMonitors()) {
                try {
                    this.getMonitors(monitors, filter, monitor);
                }
                catch (Exception e) {
                    LOGGER.warn("failed to get monitors for composite " + monitor.getConfig(), (Throwable)e);
                }
            }
            this.cacheLastUpdateTime.set(System.currentTimeMillis());
            this.cachedMonitors.set(monitors);
            LOGGER.debug("cache refreshed, {} monitors matched filter, previous age {} seconds", (Object)monitors.size(), (Object)(age / 1000L));
        } else {
            LOGGER.debug("cache age of {} seconds is within ttl of {} seconds", (Object)(age / 1000L), (Object)(this.cacheTTL / 1000L));
        }
    }

    @Override
    public List<Metric> poll(MetricFilter filter) {
        return this.poll(filter, false);
    }

    @Override
    public List<Metric> poll(MetricFilter filter, boolean reset) {
        this.refreshMonitorCache(filter);
        List<Monitor<?>> monitors = this.cachedMonitors.get();
        ArrayList metrics = Lists.newArrayListWithCapacity((int)monitors.size());
        for (Monitor<?> monitor : monitors) {
            Object v = this.getValue(monitor, reset);
            if (v == null) continue;
            long now = System.currentTimeMillis();
            metrics.add(new Metric(monitor.getConfig(), now, v));
        }
        return metrics;
    }

    public void shutdown() {
        if (this.service != null) {
            this.service.shutdownNow();
        }
    }

    private static class MonitorValueCallable
    implements Callable<Object> {
        private final Monitor<?> monitor;

        public MonitorValueCallable(Monitor<?> monitor) {
            this.monitor = monitor;
        }

        @Override
        public Object call() throws Exception {
            return this.monitor.getValue();
        }
    }
}

