/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.hibernate;

import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.hibernate.ConfigurationBuilder$;
import org.beangle.data.hibernate.cfg.MappingService;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.engine.Engines$;
import org.beangle.data.jdbc.meta.Database;
import org.beangle.data.orm.Mappings;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConfigurationBuilder
implements Logging {
    private Logger logger;
    private final DataSource dataSource;
    private Seq configLocations;
    private Seq ormLocations;
    private Properties properties;
    private Option engine;

    public static Configuration default() {
        return ConfigurationBuilder$.MODULE$.default();
    }

    public ConfigurationBuilder(DataSource dataSource) {
        this.dataSource = dataSource;
        Logging.$init$((Logging)this);
        this.properties = new Properties();
        this.engine = None$.MODULE$;
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public Seq<URL> configLocations() {
        return this.configLocations;
    }

    public void configLocations_$eq(Seq<URL> x$1) {
        this.configLocations = x$1;
    }

    public Seq<URL> ormLocations() {
        return this.ormLocations;
    }

    public void ormLocations_$eq(Seq<URL> x$1) {
        this.ormLocations = x$1;
    }

    public Properties properties() {
        return this.properties;
    }

    public void properties_$eq(Properties x$1) {
        this.properties = x$1;
    }

    public Option<String> engine() {
        return this.engine;
    }

    public void engine_$eq(Option<String> x$1) {
        this.engine = x$1;
    }

    public void importSysProperties() {
        Properties sysProps = System.getProperties();
        Enumeration<?> keys = sysProps.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("hibernate.")) continue;
            String value = sysProps.getProperty(key);
            boolean overrided = this.properties().containsKey(key);
            this.properties().put(key, value);
            if (!overrided) continue;
            Logger$.MODULE$.info$extension(this.logger(), () -> ConfigurationBuilder.importSysProperties$$anonfun$1(key, value));
        }
    }

    public void customProperties() {
        String useJdbcMetaName = "hibernate.temp.use_jdbc_metadata_defaults";
        Object object = this.properties().containsKey("hibernate.dialect") && !this.properties().containsKey(useJdbcMetaName) ? this.properties().put(useJdbcMetaName, "false") : this.properties().put(useJdbcMetaName, "true");
        if (this.dataSource() != null) {
            this.properties().put("hibernate.connection.datasource", this.dataSource());
        }
        this.properties().put("hibernate.connection.handling_mode", "DELAYED_ACQUISITION_AND_HOLD");
        this.properties().put("hibernate.ejb.metamodel.population", "disabled");
    }

    public Configuration build() {
        this.importSysProperties();
        this.customProperties();
        StandardServiceRegistryBuilder standardRegistryBuilder = new StandardServiceRegistryBuilder();
        Mappings mappings = this.getMappings();
        standardRegistryBuilder.addService(MappingService.class, (Service)new MappingService(mappings));
        if (this.configLocations() != null) {
            this.configLocations().foreach((Function1 & Serializable)resource -> standardRegistryBuilder.configure(resource));
        }
        standardRegistryBuilder.applySettings((Map)this.properties());
        StandardServiceRegistry standardRegistry = standardRegistryBuilder.build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)standardRegistry);
        Configuration configuration = new Configuration(metadataSources);
        configuration.addProperties(this.properties());
        return configuration;
    }

    private Mappings getMappings() {
        Engine engine;
        Option<String> option = this.engine();
        if (option instanceof Some) {
            String e = (String)((Some)option).value();
            engine = Engines$.MODULE$.forName(e);
        } else if (None$.MODULE$.equals(option)) {
            Connection connection = this.dataSource().getConnection();
            String dbProductName = connection.getMetaData().getDatabaseProductName();
            connection.close();
            engine = Engines$.MODULE$.forName(dbProductName);
        } else {
            throw new MatchError(option);
        }
        Engine eng = engine;
        Mappings mappings = new Mappings(new Database(eng), this.ormLocations().toList());
        mappings.autobind();
        return mappings;
    }

    private static final String importSysProperties$$anonfun$1(String key$1, String value$1) {
        return "Override hibernate property " + key$1 + "=" + value$1;
    }
}

