/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.hibernate;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Collection;
import org.beangle.commons.collection.page.Page;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.collection.page.SinglePage;
import org.beangle.commons.lang.Assert$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.annotation.description;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.LimitQuery;
import org.beangle.data.dao.Operation;
import org.beangle.data.dao.OperationType;
import org.beangle.data.dao.OperationType$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.hibernate.DomainFactory$;
import org.beangle.data.hibernate.QuerySupport$;
import org.beangle.data.model.Entity;
import org.beangle.data.model.meta.Domain;
import org.beangle.data.model.meta.EntityType;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.StreamUtils;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.jdk.javaapi.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

@description(value="\u57fa\u4e8eHibernate\u63d0\u4f9b\u7684\u901a\u7528\u5b9e\u4f53DAO")
public class HibernateEntityDao
implements EntityDao,
Logging {
    private Logger logger;
    private final SessionFactory sessionFactory;
    private final Domain domain;

    public HibernateEntityDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        Logging.$init$((Logging)this);
        this.domain = DomainFactory$.MODULE$.build(sessionFactory);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public SessionFactory sessionFactory() {
        return this.sessionFactory;
    }

    public Domain domain() {
        return this.domain;
    }

    public Session currentSession() {
        return this.sessionFactory().getCurrentSession();
    }

    private Query<?> createQuery(String hql) {
        return (Query)this.currentSession().createQuery(hql);
    }

    public String entityNameOf(Class<?> clazz) {
        String string;
        Option option = this.domain().getEntity(clazz);
        if (option instanceof Some) {
            EntityType e = (EntityType)((Some)option).value();
            string = e.entityName();
        } else if (None$.MODULE$.equals(option)) {
            string = clazz.getName();
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    public <T extends Entity<ID>, ID> T get(Class<T> clazz, ID id) {
        return (T)((Entity)this.find(this.entityNameOf(clazz), id).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public <T> scala.collection.immutable.Seq<T> getAll(Class<T> clazz) {
        String hql = "from " + this.entityNameOf(clazz);
        Query<?> query = this.createQuery(hql);
        query.setCacheable(true);
        return CollectionConverters$.MODULE$.asScala(query.list()).toList();
    }

    public <T extends Entity<ID>, ID> Option<T> find(String entityName, ID id) {
        Object object;
        if (Strings$.MODULE$.contains((CharSequence)entityName, 46)) {
            Object obj = this.currentSession().get(entityName, (Serializable)id);
            object = obj == null ? None$.MODULE$ : Some$.MODULE$.apply((Object)((Entity)obj));
        } else {
            String hql = "from " + entityName + " where id =:id";
            Query<?> query = this.createQuery(hql);
            query.setParameter("id", id);
            java.util.List rs = query.list();
            object = rs.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply((Object)((Entity)rs.get(0)));
        }
        return object;
    }

    public <T extends Entity<ID>, ID> Option<T> find(Class<T> clazz, ID id) {
        return this.find(this.entityNameOf(clazz), id);
    }

    public <T extends Entity<ID>, ID> scala.collection.immutable.Seq<T> find(Class<T> clazz, Iterable<ID> ids) {
        return this.findBy(this.entityNameOf(clazz), "id", ids);
    }

    public <T extends Entity<?>> scala.collection.immutable.Seq<T> findBy(Class<T> clazz, String keyName, Iterable<?> values) {
        return this.findBy(this.entityNameOf(clazz), keyName, values);
    }

    public <T extends Entity<?>> scala.collection.immutable.Seq<T> findBy(String entityName, String keyName, Iterable<?> values) {
        List list;
        if (values.isEmpty()) {
            return package$.MODULE$.List().empty();
        }
        StringBuilder hql = new StringBuilder();
        hql.append("select entity from ").append(entityName).append(" as entity where entity.").append(keyName).append(" in (:keyName)");
        HashMap parameterMap = new HashMap();
        if (values.size() < 500) {
            parameterMap.put((Object)"keyName", values);
            OqlBuilder query = OqlBuilder$.MODULE$.oql(hql.toString());
            list = this.search(query.params((Map)parameterMap).build());
        } else {
            OqlBuilder query = OqlBuilder$.MODULE$.oql(hql.toString());
            ListBuffer rs = new ListBuffer();
            for (int i = 0; i < values.size(); i += 500) {
                int end = i + 500;
                if (end > values.size()) {
                    end = values.size();
                }
                parameterMap.put((Object)"keyName", values.slice(i, end));
                rs.$plus$plus$eq(this.search(query.params((Map)parameterMap).build()));
            }
            list = rs.toList();
        }
        return list;
    }

    public <T extends Entity<?>> scala.collection.immutable.Seq<T> find(Class<T> clazz, Map<String, ?> parameterMap) {
        if (clazz == null || parameterMap == null || parameterMap.isEmpty()) {
            return package$.MODULE$.List().empty();
        }
        StringBuilder hql = new StringBuilder();
        hql.append("select entity from ").append(this.entityNameOf(clazz)).append(" as entity ").append(" where ");
        HashMap m = new HashMap();
        IntRef i = IntRef.create((int)0);
        parameterMap.withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String keyName = (String)tuple2._1();
                Object keyValue = tuple2._2();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String keyName = (String)tuple2._1();
            Object keyValue = tuple2._2();
            return Strings$.MODULE$.isNotEmpty((CharSequence)keyName);
        }).foreach((Function1 & Serializable)x$1 -> {
            String name;
            Object keyValue;
            String keyName;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int n;
                keyName = (String)tuple2._1();
                keyValue = tuple2._2();
                i$1.elem = n = i$1.elem + 1;
                String[] tempName = Strings$.MODULE$.split(keyName, "\\.");
                name = tempName[tempName.length - 1] + i$1.elem;
                m.put((Object)name, keyValue);
            } else {
                throw new MatchError((Object)tuple2);
            }
            return keyValue != null && this.isCollectionType(keyValue.getClass()) ? hql.append("entity.").append(keyName).append(" in (:").append(name).append(") and ") : hql.append("entity.").append(keyName).append(" = :").append(name).append(" and ");
        });
        if (i.elem > 0) {
            hql.delete(hql.length() - " and ".length(), hql.length());
        }
        return this.search(hql.toString(), (Map<String, ?>)m);
    }

    public long count(String entityName, String keyName, Object value) {
        String hql = "select count(*) from " + entityName + " where " + keyName + "=:value";
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, value);
        scala.collection.immutable.Seq rs = this.search(hql, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        return rs.isEmpty() ? 0L : ((Number)rs.head()).longValue();
    }

    public long count(Class<?> entityClass, String keyName, Object value) {
        return this.count(entityClass.getName(), keyName, value);
    }

    public long count(Class<?> entityClass, Iterable<String> attrs, Iterable<?> values, String countAttr) {
        Assert$.MODULE$.isTrue(attrs != null && values != null && attrs.size() == values.size());
        String entityName = entityClass.getName();
        StringBuilder hql = new StringBuilder();
        StringBuilder stringBuilder = Strings$.MODULE$.isNotEmpty((CharSequence)countAttr) ? hql.append("select count(distinct ").append(countAttr).append(") from ") : hql.append("select count(*) from ");
        hql.append(entityName).append(" as entity where ");
        HashMap params = new HashMap();
        Iterator attrIter = attrs.iterator();
        Iterator valueIter = values.iterator();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), attrs.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String attr = (String)attrIter.next();
            if (Strings$.MODULE$.isNotEmpty((CharSequence)attr)) {
                String keyName = Strings$.MODULE$.replace(attr, ".", "_");
                Object keyValue = valueIter.next();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)keyName);
                params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, keyValue));
                StringBuilder stringBuilder = keyValue != null && this.isCollectionType(keyValue.getClass()) ? hql.append("entity.").append(attr).append(" in (:").append(keyName).append(')') : hql.append("entity.").append(attr).append(" = :").append(keyName);
                if (i < attrs.size() - 1) {
                    hql.append(" and ");
                }
            }
        });
        return ((Number)this.search(hql.toString(), (Map<String, ?>)params).head()).longValue();
    }

    public boolean exists(Class<?> entityClass, String attr, Object value) {
        return this.count(entityClass, attr, value) > 0L;
    }

    public boolean exists(String entityName, String attr, Object value) {
        return this.count(entityName, attr, value) > 0L;
    }

    public boolean exists(Class<?> entityClass, Iterable<String> attrs, Iterable<?> values) {
        return this.count(entityClass, attrs, values, null) > 0L;
    }

    public boolean duplicate(Class<?> clazz, Object id, Map<String, ?> params) {
        return this.duplicate(this.entityNameOf(clazz), id, params);
    }

    public boolean duplicate(String entityName, Object id, Map<String, ?> params) {
        StringBuilder b = new StringBuilder("from ");
        b.append(entityName).append(" where ");
        HashMap paramsMap = new HashMap();
        IntRef i = IntRef.create((int)0);
        params.withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int n;
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                b.append(key).append('=').append(":param" + i$2.elem);
                paramsMap.put((Object)("param" + i$2.elem), value);
                i$2.elem = n = i$2.elem + 1;
                if (i$2.elem < params.size()) {
                    b.append(" and ");
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
        });
        scala.collection.immutable.Seq list = this.search(b.toString(), (Map<String, ?>)paramsMap);
        return list.isEmpty() ? false : (id == null ? true : list.exists((Function1 & Serializable)e -> !BoxesRunTime.equals((Object)e.id(), (Object)id)));
    }

    public <T extends Entity<?>> boolean duplicate(Class<T> clazz, Object id, String codeName, Object codeValue) {
        scala.collection.immutable.Seq<T> list = this.findBy(clazz, codeName, (Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{codeValue})));
        return list.isEmpty() ? false : (id == null ? true : list.exists((Function1 & Serializable)e -> !BoxesRunTime.equals((Object)e.id(), (Object)id)));
    }

    public <T> scala.collection.immutable.Seq<T> search(org.beangle.data.dao.Query<T> query) {
        LimitQuery limitQuery;
        org.beangle.data.dao.Query<T> query2 = query;
        return query2 instanceof LimitQuery ? ((limitQuery = (LimitQuery)query2).limit() == null ? QuerySupport$.MODULE$.doFind(limitQuery, this.currentSession()) : new SinglePage(limitQuery.limit().pageIndex(), limitQuery.limit().pageSize(), QuerySupport$.MODULE$.doCount(limitQuery, this.currentSession()), QuerySupport$.MODULE$.doFind(query, this.currentSession()))) : QuerySupport$.MODULE$.doFind(query, this.currentSession());
    }

    public <T> scala.collection.immutable.Seq<T> search(QueryBuilder<T> builder) {
        return this.search(builder.build());
    }

    public <T> T uniqueResult(QueryBuilder<T> builder) {
        Object object;
        scala.collection.immutable.Seq<T> list = this.search(builder.build());
        if (list.isEmpty()) {
            object = null;
        } else if (list.size() == 1) {
            object = list.head();
        } else {
            throw new RuntimeException("not unique query" + builder);
        }
        return (T)object;
    }

    public <T> scala.collection.immutable.Seq<T> search(String query, scala.collection.immutable.Seq<Object> params) {
        return QuerySupport$.MODULE$.list(QuerySupport$.MODULE$.setParameters(this.getNamedOrCreateQuery(query), (Iterable<?>)params));
    }

    public <T> scala.collection.immutable.Seq<T> search(String queryString, Map<String, ?> params) {
        return QuerySupport$.MODULE$.list(QuerySupport$.MODULE$.setParameters(this.getNamedOrCreateQuery(queryString), params));
    }

    public <T> scala.collection.immutable.Seq<T> search(String queryString, Map<String, ?> params, PageLimit limit, boolean cacheable) {
        Query<T> query = this.getNamedOrCreateQuery(queryString);
        query.setCacheable(cacheable);
        return limit == null ? QuerySupport$.MODULE$.list(QuerySupport$.MODULE$.setParameters(query, params)) : this.paginateQuery(query, params, limit);
    }

    private <T> Page<T> paginateQuery(Query<T> query, Map<String, ?> params, PageLimit limit) {
        QuerySupport$.MODULE$.setParameters(query, params);
        query.setFirstResult((limit.pageIndex() - 1) * limit.pageSize()).setMaxResults(limit.pageSize());
        java.util.List targetList = query.list();
        String queryStr = this.buildCountQueryStr(query);
        Query countQuery = null;
        countQuery = query instanceof NativeQuery ? (Query)this.currentSession().createNativeQuery(queryStr) : this.createQuery(queryStr);
        QuerySupport$.MODULE$.setParameters(countQuery, params);
        return new SinglePage(limit.pageIndex(), limit.pageSize(), ((Number)countQuery.uniqueResult()).intValue(), (Seq)CollectionConverters$.MODULE$.asScala(targetList));
    }

    public void evict(Entity<?> entity) {
        Class clazz;
        Entity<?> entity2 = entity;
        if (entity2 instanceof HibernateProxy) {
            Entity hp = (Entity)((HibernateProxy)entity2);
            clazz = ((HibernateProxy)hp).getHibernateLazyInitializer().getPersistentClass();
        } else {
            clazz = entity.getClass();
        }
        Class clazz2 = clazz;
        this.sessionFactory().getCache().evict(clazz2, entity.id());
    }

    public <A extends Entity<?>> void evict(Class<A> clazz) {
        this.sessionFactory().getCache().evict(clazz);
    }

    public <T> T refresh(T entity) {
        this.currentSession().refresh(entity);
        return entity;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T initialize(T proxy) {
        void var2_2;
        Object rs = proxy;
        T t = proxy;
        if (t instanceof HibernateProxy) {
            HibernateProxy hp = (HibernateProxy)t;
            LazyInitializer initer = hp.getHibernateLazyInitializer();
            if (initer.getSession() == null || initer.getSession().isClosed()) {
                rs = this.currentSession().get(initer.getEntityName(), initer.getIdentifier());
            } else {
                Hibernate.initialize(proxy);
            }
        } else if (t instanceof PersistentCollection) {
            PersistentCollection pc = (PersistentCollection)t;
            Hibernate.initialize((Object)pc);
        } else {
            throw new MatchError(t);
        }
        return var2_2;
    }

    public <E> void remove(Iterable<E> entities) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        Session session = this.currentSession();
        entities.withFilter((Function1 & Serializable)entity -> entity != null).foreach((Function1)(JProcedure1 & Serializable)entity -> {
            Object object = entity;
            if (object instanceof Iterable) {
                Iterable seq = (Iterable)object;
                ((IterableOnceOps)seq).foreach((Function1)(JProcedure1 & Serializable)x$0 -> session.delete(x$0));
            } else {
                session.delete(entity);
            }
        });
    }

    public <E> void remove(E first, scala.collection.immutable.Seq<E> entities) {
        this.remove((Iterable<E>)entities.toList().$colon$colon(first));
    }

    public <T extends Entity<ID>, ID> void remove(Class<T> clazz, ID id, scala.collection.immutable.Seq<ID> ids) {
        this.removeBy(clazz, "id", (Iterable<?>)ids.toList().$colon$colon(id));
    }

    public boolean removeBy(Class<?> clazz, String attr, Object first, scala.collection.immutable.Seq<Object> values) {
        return this.removeBy(clazz, attr, (Iterable<?>)values.toList().$colon$colon(first));
    }

    public boolean removeBy(Class<?> clazz, String attr, Iterable<?> values) {
        if (clazz == null || Strings$.MODULE$.isEmpty((CharSequence)attr) || values.isEmpty()) {
            return false;
        }
        StringBuilder hql = new StringBuilder();
        hql.append("delete from ").append(this.entityNameOf(clazz)).append(" where ").append(attr).append(" in (:ids)");
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"ids");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, values);
        return this.executeUpdate(hql.toString(), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))) > 0;
    }

    public boolean remove(Class<?> clazz, Map<String, ?> keyMap) {
        if (clazz == null || keyMap == null || keyMap.isEmpty()) {
            return false;
        }
        StringBuilder hql = new StringBuilder();
        hql.append("delete from ").append(this.entityNameOf(clazz)).append(" where ");
        HashMap params = new HashMap();
        keyMap.withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String keyName = (String)tuple2._1();
                Object keyValue = tuple2._2();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1 & Serializable)x$1 -> {
            String paramName;
            Object keyValue;
            String keyName;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                keyName = (String)tuple2._1();
                keyValue = tuple2._2();
                paramName = keyName.replace('.', '_');
                params.put((Object)paramName, keyValue);
            } else {
                throw new MatchError((Object)tuple2);
            }
            return this.isCollectionType(keyValue.getClass()) ? hql.append(keyName).append(" in (:").append(paramName).append(") and ") : hql.append(keyName).append(" = :").append(paramName).append(" and ");
        });
        hql.append(" (1=1) ");
        return this.executeUpdate(hql.toString(), (Map<String, ?>)params) > 0;
    }

    public int executeUpdate(String queryString, Map<String, ?> parameterMap) {
        return QuerySupport$.MODULE$.setParameters(this.getNamedOrCreateQuery(queryString), parameterMap).executeUpdate();
    }

    public int executeUpdate(String queryString, scala.collection.immutable.Seq<Object> arguments) {
        return QuerySupport$.MODULE$.setParameters(this.getNamedOrCreateQuery(queryString), (Iterable<?>)arguments).executeUpdate();
    }

    public List<Object> executeUpdateRepeatly(String queryString, Iterable<Iterable<?>> arguments) {
        Query query = this.getNamedOrCreateQuery(queryString);
        ListBuffer updates = new ListBuffer();
        arguments.foreach((Function1 & Serializable)params -> (ListBuffer)updates.$plus$eq((Object)BoxesRunTime.boxToInteger((int)QuerySupport$.MODULE$.setParameters(query, (Iterable<?>)params).executeUpdate())));
        return updates.toList();
    }

    public void execute(scala.collection.immutable.Seq<Operation> opts) {
        opts.foreach((Function1)(JProcedure1 & Serializable)operation -> {
            OperationType operationType = operation.typ();
            OperationType operationType2 = OperationType$.SaveUpdate;
            OperationType operationType3 = operationType;
            if (!(operationType2 != null ? !operationType2.equals(operationType3) : operationType3 != null)) {
                this.persistEntity(operation.data(), null);
            } else {
                OperationType operationType4 = OperationType$.Remove;
                OperationType operationType5 = operationType;
                if (!(operationType4 != null ? !operationType4.equals(operationType5) : operationType5 != null)) {
                    this.remove((Object)operation.data(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                } else {
                    throw new MatchError((Object)operationType);
                }
            }
        });
    }

    public void execute(Operation.Builder builder) {
        builder.build().foreach((Function1)(JProcedure1 & Serializable)operation -> {
            OperationType operationType = operation.typ();
            OperationType operationType2 = OperationType$.SaveUpdate;
            OperationType operationType3 = operationType;
            if (!(operationType2 != null ? !operationType2.equals(operationType3) : operationType3 != null)) {
                this.persistEntity(operation.data(), null);
            } else {
                OperationType operationType4 = OperationType$.Remove;
                OperationType operationType5 = operationType;
                if (!(operationType4 != null ? !operationType4.equals(operationType5) : operationType5 != null)) {
                    this.remove((Object)operation.data(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                } else {
                    throw new MatchError((Object)operationType);
                }
            }
        });
    }

    public <E> void saveOrUpdate(E first, scala.collection.immutable.Seq<E> entities) {
        this.saveOrUpdate((Iterable<E>)entities.toList().$colon$colon(first));
    }

    public <E> void saveOrUpdate(Iterable<E> entities) {
        if (entities.nonEmpty()) {
            entities.foreach((Function1)(JProcedure1 & Serializable)entity -> {
                Object object = entity;
                if (object instanceof Iterable) {
                    Iterable col = (Iterable)object;
                    ((IterableOnceOps)col).foreach((Function1)(JProcedure1 & Serializable)elementEntry -> this.persistEntity(elementEntry, null));
                } else {
                    this.persistEntity(entity, null);
                }
            });
        }
    }

    private void persistEntity(Object entity, String entityName) {
        if (entity == null) {
            return;
        }
        Session session = this.currentSession();
        Object object = entity;
        if (object instanceof HibernateProxy) {
            HibernateProxy hp = (HibernateProxy)object;
            session.update((Object)hp);
        } else if (object instanceof Entity) {
            String en;
            Entity e = (Entity)object;
            String string = en = entityName == null ? this.entityNameOf(entity.getClass()) : entityName;
            if (e.id() == null) {
                session.save(en, entity);
            } else {
                SessionImplementor si = (SessionImplementor)session;
                if (si.getContextEntityIdentifier(entity) == null) {
                    session.save(en, entity);
                } else {
                    session.update(en, entity);
                }
            }
        } else {
            String en = entityName == null ? this.entityNameOf(entity.getClass()) : entityName;
            session.saveOrUpdate(en, entity);
        }
    }

    public <T extends Entity<?>> void saveOrUpdate(String entityName, Seq<T> entities) {
        if (entities.nonEmpty()) {
            entities.foreach((Function1)(JProcedure1 & Serializable)entity -> this.persistEntity(entity, entityName));
        }
    }

    public <T extends Entity<?>> void saveOrUpdate(String entityName, T first, scala.collection.immutable.Seq<T> entities) {
        this.saveOrUpdate(entityName, (Seq<T>)entities.toList().$colon$colon(first));
    }

    public int batchUpdate(Class<?> entityClass, String attr, Iterable<?> values, Iterable<String> argumentNames, Iterable<Object> argumentValues) {
        if (values.isEmpty()) {
            return 0;
        }
        HashMap updateParams = new HashMap();
        Iterator valueIter = argumentValues.iterator();
        argumentNames.foreach((Function1 & Serializable)n -> updateParams.put(n, valueIter.next()));
        return this.batchUpdate(entityClass, attr, values, (Map<String, ?>)updateParams);
    }

    public int batchUpdate(Class<?> entityClass, String attr, Iterable<?> values, Map<String, ?> updateParams) {
        if (values.isEmpty() || updateParams.isEmpty()) {
            return 0;
        }
        StringBuilder hql = new StringBuilder();
        hql.append("update ").append(this.entityNameOf(entityClass)).append(" set ");
        HashMap newParams = new HashMap();
        updateParams.withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String parameterName = (String)tuple2._1();
                Object value = tuple2._2();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).withFilter((Function1 & Serializable)x$1 -> {
            String parameterName;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                parameterName = (String)tuple2._1();
                Object value = tuple2._2();
            } else {
                throw new MatchError((Object)tuple2);
            }
            return parameterName != null;
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String parameterName = (String)tuple2._1();
            Object value = tuple2._2();
            String locateParamName = Strings$.MODULE$.replace(parameterName, ".", "_");
            hql.append(parameterName).append(" = ").append(":").append(locateParamName).append(",");
            return newParams.put((Object)locateParamName, value);
        });
        hql.deleteCharAt(hql.length() - 1);
        hql.append(" where ").append(attr).append(" in (:ids)");
        newParams.put((Object)"ids", values);
        return this.executeUpdate(hql.toString(), (Map<String, ?>)newParams);
    }

    public Blob createBlob(InputStream inputStream, int length) {
        return Hibernate.getLobCreator((Session)this.currentSession()).createBlob(inputStream, Int$.MODULE$.int2long(length));
    }

    public Blob createBlob(InputStream inputStream) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(inputStream.available());
        StreamUtils.copy((InputStream)inputStream, (OutputStream)buffer);
        return Hibernate.getLobCreator((Session)this.currentSession()).createBlob(buffer.toByteArray());
    }

    public Clob createClob(String str) {
        return Hibernate.getLobCreator((Session)this.currentSession()).createClob(str);
    }

    public boolean isCollectionType(Class<?> clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Iterable.class.isAssignableFrom(clazz);
    }

    private <T> Query<T> getNamedOrCreateQuery(String queryString) {
        return queryString.charAt(0) == '@' ? this.currentSession().getNamedQuery(queryString.substring(1)) : (Query)this.currentSession().createQuery(queryString);
    }

    /*
     * WARNING - void declaration
     */
    private String buildCountQueryStr(Query<?> query) {
        void var2_2;
        String queryStr = "select count(*) ";
        if (query instanceof NativeQuery) {
            queryStr = queryStr + ("from (" + query.getQueryString() + ")");
        } else {
            String lowerCaseQueryStr = query.getQueryString().toLowerCase();
            String selectWhich = lowerCaseQueryStr.substring(0, query.getQueryString().indexOf("from"));
            int indexOfDistinct = selectWhich.indexOf("distinct");
            int indexOfFrom = lowerCaseQueryStr.indexOf("from");
            if (-1 != indexOfDistinct) {
                queryStr = Strings$.MODULE$.contains((CharSequence)selectWhich, (CharSequence)",") ? "select count(" + query.getQueryString().substring(indexOfDistinct, query.getQueryString().indexOf(",")) + ")" : "select count(" + query.getQueryString().substring(indexOfDistinct, indexOfFrom) + ")";
            }
            queryStr = queryStr + query.getQueryString().substring(indexOfFrom);
        }
        return var2_2;
    }
}

