/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.hibernate;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.beangle.commons.lang.Throwables$;
import org.beangle.data.hibernate.PropertyAccessor$;
import org.hibernate.PropertyAccessException;
import org.hibernate.PropertySetterAccessException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.Setter;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;

public final class PropertyAccessor {
    public static Getter createGetter(Class<?> clazz, String string) {
        return PropertyAccessor$.MODULE$.createGetter(clazz, string);
    }

    public static Setter createSetter(Class<?> clazz, String string) {
        return PropertyAccessor$.MODULE$.createSetter(clazz, string);
    }

    public static final class BasicGetter
    implements Getter {
        private final Class clazz;
        private final Method method;
        private final Class returnType;
        private final String propertyName;
        private final boolean optional;

        public BasicGetter(Class<?> clazz, Method method, Class<?> returnType, String propertyName, boolean optional) {
            this.clazz = clazz;
            this.method = method;
            this.returnType = returnType;
            this.propertyName = propertyName;
            this.optional = optional;
        }

        public Class<?> clazz() {
            return this.clazz;
        }

        public Method method() {
            return this.method;
        }

        public Class<?> returnType() {
            return this.returnType;
        }

        public String propertyName() {
            return this.propertyName;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object get(Object target) {
            Object object;
            Object result;
            Object object2;
            Object object3 = target;
            if (None$.MODULE$.equals(object3)) {
                object2 = null;
            } else if (object3 instanceof Some) {
                Object t = ((Some)object3).value();
                object2 = this.method().invoke(t, new Object[0]);
            } else {
                object2 = result = this.method().invoke(target, new Object[0]);
            }
            if (this.optional) {
                Object r;
                Object object4 = result;
                if (object4 == null) {
                    return null;
                }
                if (None$.MODULE$.equals(object4)) {
                    return null;
                }
                if (!(object4 instanceof Some)) throw new MatchError(object4);
                object = r = ((Some)object4).value();
                return object;
            } else {
                void var2_4;
                object = var2_4;
            }
            return object;
        }

        public Object getForInsert(Object target, Map<?, ?> mergeMap, SharedSessionContractImplementor session) {
            return this.get(target);
        }

        public Class<?> getReturnType() {
            return this.returnType();
        }

        public Member getMember() {
            return this.method();
        }

        public Method getMethod() {
            return this.method();
        }

        public String getMethodName() {
            return this.method().getName();
        }

        public String toString() {
            return "BasicGetter(" + this.clazz().getName() + '.' + this.propertyName() + ')';
        }

        public Object readResolve() {
            return PropertyAccessor$.MODULE$.createGetter(this.clazz(), this.propertyName());
        }
    }

    public static final class BasicSetter
    implements Setter {
        private final Class clazz;
        private final Method method;
        private final String propertyName;
        private final boolean optional;

        public BasicSetter(Class<?> clazz, Method method, String propertyName, boolean optional) {
            this.clazz = clazz;
            this.method = method;
            this.propertyName = propertyName;
            this.optional = optional;
        }

        public Class<?> clazz() {
            return this.clazz;
        }

        public Method method() {
            return this.method;
        }

        public String propertyName() {
            return this.propertyName;
        }

        public void set(Object target, Object value, SessionFactoryImplementor factory) {
            try {
                Object arg = this.optional ? (value instanceof Option ? value : Option$.MODULE$.apply(value)) : value;
                this.method().invoke(target, arg);
            }
            catch (NullPointerException npe) {
                if (value == null && this.method().getParameterTypes()[0].isPrimitive()) {
                    throw new PropertyAccessException((Throwable)npe, "Null value was assigned to a property of primitive type", true, this.clazz(), this.propertyName());
                }
                throw new PropertyAccessException((Throwable)npe, "NullPointerException occurred while calling", true, this.clazz(), this.propertyName());
            }
            catch (IllegalArgumentException iae) {
                if (value == null && this.method().getParameterTypes()[0].isPrimitive()) {
                    throw new PropertyAccessException((Throwable)iae, "Null value was assigned to a property of primitive type", true, this.clazz(), this.propertyName());
                }
                Class<?> expectedType = this.method().getParameterTypes()[0];
                throw new PropertySetterAccessException((Throwable)iae, this.clazz(), this.propertyName(), expectedType, target, value.getClass());
            }
            catch (Exception e) {
                Throwables$.MODULE$.propagate((Throwable)e);
            }
        }

        public Method getMethod() {
            return this.method();
        }

        public String getMethodName() {
            return this.method().getName();
        }

        public Object readResolve() {
            return PropertyAccessor$.MODULE$.createSetter(this.clazz(), this.propertyName());
        }

        public String toString() {
            return "BasicSetter(" + this.clazz().getName() + '.' + this.propertyName() + ')';
        }
    }
}

