/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.hibernate.id;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.Properties;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.hibernate.cfg.MappingService;
import org.beangle.data.jdbc.meta.Table$;
import org.beangle.data.orm.OrmEntityType;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.Type;
import scala.MatchError;

public class AutoIncrementGenerator
implements IdentifierGenerator,
Configurable {
    private Type identifierType;
    private final String sql;
    private String tableName;

    public AutoIncrementGenerator() {
        this.sql = "{? = call next_id(?)}";
    }

    public Type identifierType() {
        return this.identifierType;
    }

    public void identifierType_$eq(Type x$1) {
        this.identifierType = x$1;
    }

    public String sql() {
        return this.sql;
    }

    public String tableName() {
        return this.tableName;
    }

    public void tableName_$eq(String x$1) {
        this.tableName = x$1;
    }

    public void configure(Type t, Properties params, ServiceRegistry serviceRegistry) {
        this.identifierType_$eq(t);
        OrmEntityType em = (OrmEntityType)((MappingService)serviceRegistry.getService(MappingService.class)).mappings().entityTypes().apply((Object)params.getProperty("entity_name"));
        String ownerSchema = em.table().schema().name().toString();
        String schema = Strings$.MODULE$.isEmpty((CharSequence)ownerSchema) ? params.getProperty("schema") : ownerSchema;
        this.tableName_$eq(Table$.MODULE$.qualify(schema, params.getProperty("target_table")).toLowerCase());
    }

    public Serializable generate(SharedSessionContractImplementor session, Object obj) {
        return (Serializable)session.getTransactionCoordinator().createIsolationDelegate().delegateWork((WorkExecutorVisitable)new AbstractReturningWork<Number>(this){
            private final AutoIncrementGenerator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Number execute(Connection connection) {
                Number number;
                try (CallableStatement st = connection.prepareCall(this.$outer.sql());){
                    Number number2;
                    st.registerOutParameter(1, -5);
                    st.setString(2, this.$outer.tableName());
                    st.execute();
                    Long id = st.getLong(1);
                    Type type = this.$outer.identifierType();
                    if (type instanceof LongType) {
                        number2 = id;
                    } else if (type instanceof IntegerType) {
                        number2 = id.intValue();
                    } else if (type instanceof ShortType) {
                        number2 = id.shortValue();
                    } else {
                        throw new MatchError((Object)type);
                    }
                    number = number2;
                }
                return number;
            }
        }, true);
    }
}

