/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.hibernate.spring;

import java.sql.Connection;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.beangle.commons.lang.annotation.description;
import org.beangle.data.hibernate.spring.SessionHolder;
import org.beangle.data.hibernate.spring.SessionUtils$;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.spi.SessionImplementor;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import scala.None$;
import scala.Option;
import scala.runtime.BoxedUnit;

@description(value="Beangle\u63d0\u4f9b\u7684Hibernate\u4e8b\u52a1\u7ba1\u7406\u5668")
public class HibernateTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager {
    private final SessionFactory sessionFactory;
    private final DataSource dataSource;
    private Option entityInterceptor;
    private Option sessionInitializer;

    public HibernateTransactionManager(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.dataSource = SessionUtils$.MODULE$.getDataSource(sessionFactory);
        this.entityInterceptor = None$.MODULE$;
        this.sessionInitializer = None$.MODULE$;
    }

    public SessionFactory sessionFactory() {
        return this.sessionFactory;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public Option<Interceptor> entityInterceptor() {
        return this.entityInterceptor;
    }

    public void entityInterceptor_$eq(Option<Interceptor> x$1) {
        this.entityInterceptor = x$1;
    }

    public Option<Consumer<Session>> sessionInitializer() {
        return this.sessionInitializer;
    }

    public void sessionInitializer_$eq(Option<Consumer<Session>> x$1) {
        this.sessionInitializer = x$1;
    }

    public Object getResourceFactory() {
        return this.sessionFactory();
    }

    /*
     * WARNING - void declaration
     */
    public Object doGetTransaction() {
        void var1_1;
        HibernateTransactionObject txObject = new HibernateTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.sessionFactory()));
        if (sessionHolder != null) {
            txObject.setSessionHolder(sessionHolder);
        } else if (SessionUtils$.MODULE$.isEnableBinding(this.sessionFactory())) {
            txObject.setSessionHolder(SessionUtils$.MODULE$.openSession(this.sessionFactory(), SessionUtils$.MODULE$.openSession$default$2(), SessionUtils$.MODULE$.openSession$default$3()));
        }
        txObject.setConnectionHolder((ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.dataSource()));
        return var1_1;
    }

    public boolean isExistingTransaction(Object transaction) {
        return ((HibernateTransactionObject)((Object)transaction)).hasTransaction();
    }

    public void doBegin(Object transaction, TransactionDefinition definition) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)transaction);
        if (txObject.hasConnectionHolder() && !txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! HibernateTransactionManager does not support.");
        }
        SessionImplementor session = null;
        try {
            boolean isolationLevelNeeded;
            if (txObject.sessionHolder() == null || txObject.sessionHolder().isSynchronizedWithTransaction()) {
                txObject.setSession(SessionUtils$.MODULE$.doOpenSession(this.sessionFactory(), this.entityInterceptor(), this.sessionInitializer()));
            }
            session = (SessionImplementor)txObject.sessionHolder().session().unwrap(SessionImplementor.class);
            boolean bl = isolationLevelNeeded = definition.getIsolationLevel() != -1;
            if (isolationLevelNeeded || definition.isReadOnly()) {
                if (ConnectionReleaseMode.ON_CLOSE.equals((Object)session.getJdbcCoordinator().getLogicalConnection().getConnectionHandlingMode().getReleaseMode())) {
                    Connection con = session.connection();
                    Integer previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction((Connection)con, (TransactionDefinition)definition);
                    txObject.setPreviousIsolationLevel(previousIsolationLevel);
                    txObject.setReadOnly(definition.isReadOnly());
                } else if (isolationLevelNeeded) {
                    throw new InvalidIsolationLevelException("HibernateTransactionManager is not allowed to support custom isolation levels.");
                }
            }
            if (definition.isReadOnly() && txObject.isNewSession()) {
                session.setHibernateFlushMode(FlushMode.MANUAL);
                session.setDefaultReadOnly(true);
            }
            if (!definition.isReadOnly() && !txObject.isNewSession()) {
                FlushMode flushMode = session.getHibernateFlushMode();
                FlushMode flushMode2 = session.getHibernateFlushMode();
                FlushMode flushMode3 = FlushMode.MANUAL;
                if (!(flushMode2 != null ? !flushMode2.equals(flushMode3) : flushMode3 != null)) {
                    session.setHibernateFlushMode(FlushMode.AUTO);
                    txObject.sessionHolder().previousFlushMode_$eq(flushMode);
                }
            }
            Transaction hibTx = null;
            int timeout = this.determineTimeout(definition);
            if (timeout != -1) {
                hibTx = session.getTransaction();
                hibTx.setTimeout(timeout);
                hibTx.begin();
            } else {
                hibTx = session.beginTransaction();
            }
            txObject.sessionHolder().transaction_$eq(hibTx);
            Connection con = session.connection();
            ConnectionHolder conHolder = new ConnectionHolder(con);
            if (timeout != -1) {
                conHolder.setTimeoutInSeconds(timeout);
            }
            TransactionSynchronizationManager.bindResource((Object)this.dataSource(), (Object)conHolder);
            txObject.setConnectionHolder(conHolder);
            if (txObject.isNewSession()) {
                TransactionSynchronizationManager.bindResource((Object)this.sessionFactory(), (Object)((Object)txObject.sessionHolder()));
            }
            txObject.sessionHolder().setSynchronizedWithTransaction(true);
        }
        catch (Throwable ex) {
            if (txObject.isNewSession()) {
                try {
                    try {
                        if (session != null && session.getTransaction().isActive()) {
                            session.getTransaction().rollback();
                        }
                    }
                    catch (Throwable throwable) {
                        this.logger.debug((Object)"Could not rollback Session after failed transaction begin", ex);
                    }
                }
                finally {
                    SessionUtils$.MODULE$.closeSession((Session)session);
                    txObject.setSessionHolder(null);
                }
            }
            throw new CannotCreateTransactionException("Could not open Hibernate Session for transaction", ex);
        }
    }

    public Object doSuspend(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)transaction);
        txObject.setSessionHolder(null);
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory()));
        txObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource((Object)this.dataSource());
        return new SuspendedResourcesHolder(sessionHolder, connectionHolder);
    }

    public void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory())) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory());
        }
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory(), (Object)((Object)resourcesHolder.sessionHolder()));
        TransactionSynchronizationManager.bindResource((Object)this.dataSource(), (Object)resourcesHolder.connectionHolder());
    }

    public void doCommit(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)status.getTransaction());
        try {
            txObject.sessionHolder().transaction().commit();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not commit transaction", (Throwable)ex);
        }
        catch (HibernateException ex2) {
            throw ex2;
        }
        catch (Exception ex3) {
            throw new RuntimeException(ex3);
        }
    }

    public void doRollback(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)status.getTransaction());
        try {
            try {
                txObject.sessionHolder().transaction().rollback();
            }
            catch (TransactionException ex) {
                throw new TransactionSystemException("Could not roll back transaction", (Throwable)ex);
            }
            catch (HibernateException ex2) {
                throw ex2;
            }
        }
        finally {
            if (!txObject.isNewSession()) {
                txObject.sessionHolder().session().clear();
            }
        }
    }

    public void doSetRollbackOnly(DefaultTransactionStatus status) {
        ((HibernateTransactionObject)((Object)status.getTransaction())).setRollbackOnly();
    }

    public void doCleanupAfterCompletion(Object transaction) {
        Object object;
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)transaction);
        if (txObject.isNewSession()) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory());
        }
        TransactionSynchronizationManager.unbindResource((Object)this.dataSource());
        SessionHolder holder = txObject.sessionHolder();
        SessionImplementor session = (SessionImplementor)holder.session().unwrap(SessionImplementor.class);
        if (session.getJdbcCoordinator().getLogicalConnection().isPhysicallyConnected()) {
            try {
                Connection con = session.connection();
                DataSourceUtils.resetConnectionAfterTransaction((Connection)con, (Integer)txObject.getPreviousIsolationLevel(), (boolean)txObject.isReadOnly());
            }
            catch (HibernateException ex) {
                this.logger.debug((Object)"Could not access JDBC Connection of Hibernate Session", (Throwable)ex);
            }
        }
        if (txObject.isNewSession()) {
            SessionUtils$.MODULE$.closeSession((Session)session);
            object = BoxedUnit.UNIT;
        } else {
            if (holder.previousFlushMode() != null) {
                session.setHibernateFlushMode(holder.previousFlushMode());
            }
            object = session.disconnect();
        }
        holder.clear();
    }

    public boolean isSameConnectionForEntireSession(Session session) {
        boolean bl;
        Session session2 = session;
        if (session2 instanceof SessionImplementor) {
            SessionImplementor tc = (SessionImplementor)session2;
            ConnectionReleaseMode connectionReleaseMode = ConnectionReleaseMode.ON_CLOSE;
            ConnectionReleaseMode connectionReleaseMode2 = tc.getJdbcSessionContext().getPhysicalConnectionHandlingMode().getReleaseMode();
            bl = !(connectionReleaseMode != null ? !connectionReleaseMode.equals(connectionReleaseMode2) : connectionReleaseMode2 != null);
        } else {
            bl = true;
        }
        return bl;
    }

    private class HibernateTransactionObject
    extends JdbcTransactionObjectSupport {
        private SessionHolder sessionHolder;
        private boolean isNewSession = false;

        public SessionHolder sessionHolder() {
            return this.sessionHolder;
        }

        public void sessionHolder_$eq(SessionHolder x$1) {
            this.sessionHolder = x$1;
        }

        public boolean isNewSession() {
            return this.isNewSession;
        }

        public void isNewSession_$eq(boolean x$1) {
            this.isNewSession = x$1;
        }

        public void setSession(Session session) {
            this.sessionHolder_$eq(new SessionHolder(session));
            this.isNewSession_$eq(true);
        }

        public void setSessionHolder(SessionHolder sessionHolder) {
            this.sessionHolder_$eq(sessionHolder);
            this.isNewSession_$eq(false);
        }

        public boolean hasTransaction() {
            return this.sessionHolder() != null && this.sessionHolder().transaction() != null;
        }

        public void setRollbackOnly() {
            this.sessionHolder().setRollbackOnly();
            if (this.hasConnectionHolder()) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        public boolean isRollbackOnly() {
            return this.sessionHolder().isRollbackOnly() || this.hasConnectionHolder() && this.getConnectionHolder().isRollbackOnly();
        }

        public void flush() {
            this.sessionHolder().session().flush();
        }
    }

    private class SuspendedResourcesHolder {
        private final SessionHolder sessionHolder;
        private final ConnectionHolder connectionHolder;

        public SuspendedResourcesHolder(SessionHolder sessionHolder, ConnectionHolder connectionHolder) {
            this.sessionHolder = sessionHolder;
            this.connectionHolder = connectionHolder;
        }

        public SessionHolder sessionHolder() {
            return this.sessionHolder;
        }

        public ConnectionHolder connectionHolder() {
            return this.connectionHolder;
        }
    }
}

