/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.hibernate.spring;

import org.beangle.data.hibernate.spring.SessionHolder;
import org.beangle.data.hibernate.spring.SessionSynchronization$;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SessionSynchronization
implements TransactionSynchronization {
    private final SessionHolder sessionHolder;
    private final SessionFactory sessionFactory;
    private final boolean newSession;
    private boolean holderActive;

    public static boolean $lessinit$greater$default$3() {
        return SessionSynchronization$.MODULE$.$lessinit$greater$default$3();
    }

    public SessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory, boolean newSession) {
        this.sessionHolder = sessionHolder;
        this.sessionFactory = sessionFactory;
        this.newSession = newSession;
        this.holderActive = true;
    }

    public SessionHolder sessionHolder() {
        return this.sessionHolder;
    }

    public SessionFactory sessionFactory() {
        return this.sessionFactory;
    }

    public boolean newSession() {
        return this.newSession;
    }

    public boolean holderActive() {
        return this.holderActive;
    }

    public void holderActive_$eq(boolean x$1) {
        this.holderActive = x$1;
    }

    private Session currentSession() {
        return this.sessionHolder().session();
    }

    public int getOrder() {
        return 900;
    }

    public void suspend() {
        if (this.holderActive()) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory());
            this.currentSession().disconnect();
        }
    }

    public void resume() {
        if (this.holderActive()) {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory(), (Object)((Object)this.sessionHolder()));
        }
    }

    public void flush() {
        this.currentSession().flush();
    }

    public void beforeCommit(boolean readOnly) {
        if (!readOnly) {
            Session session = this.currentSession();
            FlushMode flushMode = FlushMode.MANUAL;
            FlushMode flushMode2 = session.getHibernateFlushMode();
            if (flushMode == null ? flushMode2 != null : !flushMode.equals(flushMode2)) {
                session.flush();
            }
        }
    }

    public void beforeCompletion() {
        try {
            Session session = this.sessionHolder().session();
            if (this.sessionHolder().previousFlushMode() != null) {
                session.setHibernateFlushMode(this.sessionHolder().previousFlushMode());
            }
            session.disconnect();
        }
        finally {
            if (this.newSession()) {
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory());
                this.holderActive_$eq(false);
            }
        }
    }

    public void afterCommit() {
    }

    public void afterCompletion(int status) {
        try {
            if (status != 0) {
                this.sessionHolder().session().clear();
            }
        }
        finally {
            this.sessionHolder().setSynchronizedWithTransaction(false);
            if (this.newSession()) {
                this.currentSession().close();
            }
        }
    }
}

