/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.hibernate.spring;

import java.io.Serializable;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.hibernate.spring.SessionHolder;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.spi.Wrapped;
import org.slf4j.Logger;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class SessionUtils$
implements Logging,
Serializable {
    private static Logger logger;
    private static final ThreadLocal<HashMap<SessionFactory, Object>> threadBinding;
    public static final SessionUtils$ MODULE$;

    private SessionUtils$() {
    }

    static {
        MODULE$ = new SessionUtils$();
        Logging.$init$((Logging)MODULE$);
        threadBinding = new ThreadLocal();
        Statics.releaseFence();
    }

    public Logger logger() {
        return logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SessionUtils$.class);
    }

    public DataSource getDataSource(SessionFactory factory) {
        SessionFactoryImplementor factoryImpl = (SessionFactoryImplementor)factory;
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.NONE;
        MultiTenancyStrategy multiTenancyStrategy2 = factoryImpl.getSessionFactoryOptions().getMultiTenancyStrategy();
        return !(multiTenancyStrategy != null ? !multiTenancyStrategy.equals(multiTenancyStrategy2) : multiTenancyStrategy2 != null) ? (DataSource)((Wrapped)factoryImpl.getServiceRegistry().getService(ConnectionProvider.class)).unwrap(DataSource.class) : (DataSource)((Wrapped)factoryImpl.getServiceRegistry().getService(MultiTenantConnectionProvider.class)).unwrap(DataSource.class);
    }

    public void enableBinding(SessionFactory factory) {
        HashMap maps = threadBinding.get();
        if (maps == null) {
            maps = new HashMap();
            threadBinding.set((HashMap<SessionFactory, Object>)maps);
        }
        maps.put((Object)factory, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public boolean isEnableBinding(SessionFactory factory) {
        HashMap<SessionFactory, Object> maps = threadBinding.get();
        return maps == null ? false : maps.contains((Object)factory);
    }

    public void disableBinding(SessionFactory factory) {
        HashMap<SessionFactory, Object> maps = threadBinding.get();
        if (maps != null) {
            maps.remove((Object)factory);
        }
    }

    public Session doOpenSession(SessionFactory factory, Option<Interceptor> interceptor, Option<Consumer<Session>> initializer) {
        Session session;
        Option<Interceptor> option = interceptor;
        if (option instanceof Some) {
            Interceptor i = (Interceptor)((Some)option).value();
            SessionBuilder builder = factory.withOptions();
            builder.interceptor(i);
            session = builder.openSession();
        } else if (None$.MODULE$.equals(option)) {
            session = factory.openSession();
        } else {
            throw new MatchError(option);
        }
        Session s = session;
        initializer.foreach((Function1)(JProcedure1 & Serializable)iz -> iz.accept(s));
        return s;
    }

    public SessionHolder openSession(SessionFactory factory, Option<Interceptor> interceptor, Option<Consumer<Session>> initializer) {
        SessionHolder holder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)factory));
        Session session = null;
        if (holder == null) {
            session = this.doOpenSession(factory, interceptor, initializer);
            session.setHibernateFlushMode(FlushMode.MANUAL);
            holder = new SessionHolder(session);
            if (this.isEnableBinding(factory)) {
                TransactionSynchronizationManager.bindResource((Object)factory, (Object)((Object)holder));
            }
        }
        return holder;
    }

    public Option<Interceptor> openSession$default$2() {
        return None$.MODULE$;
    }

    public Option<Consumer<Session>> openSession$default$3() {
        return None$.MODULE$;
    }

    public SessionHolder currentSession(SessionFactory factory) {
        return (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)factory));
    }

    public void closeSession(SessionFactory factory) {
        try {
            SessionHolder holder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)factory));
            if (holder != null) {
                TransactionSynchronizationManager.unbindResource((Object)factory);
                holder.session().close();
            }
        }
        catch (HibernateException ex) {
            Logger$.MODULE$.debug$extension(this.logger(), this::closeSession$$anonfun$1, () -> this.closeSession$$anonfun$2(ex));
        }
        catch (Throwable e) {
            Logger$.MODULE$.debug$extension(this.logger(), this::closeSession$$anonfun$3, () -> this.closeSession$$anonfun$4(e));
        }
    }

    public void closeSession(Session session) {
        try {
            SessionHolder holder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)session.getSessionFactory()));
            if (holder != null) {
                TransactionSynchronizationManager.unbindResource((Object)session.getSessionFactory());
            }
            session.close();
        }
        catch (HibernateException ex) {
            Logger$.MODULE$.debug$extension(this.logger(), this::closeSession$$anonfun$5, () -> this.closeSession$$anonfun$6(ex));
        }
        catch (Throwable e) {
            Logger$.MODULE$.debug$extension(this.logger(), this::closeSession$$anonfun$7, () -> this.closeSession$$anonfun$8(e));
        }
    }

    public String toString(Session session) {
        return session.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(session));
    }

    private final String closeSession$$anonfun$1() {
        return "Could not close Hibernate Session";
    }

    private final HibernateException closeSession$$anonfun$2(HibernateException ex$1) {
        return ex$1;
    }

    private final String closeSession$$anonfun$3() {
        return "Unexpected exception on closing Hibernate Session";
    }

    private final Throwable closeSession$$anonfun$4(Throwable e$1) {
        return e$1;
    }

    private final String closeSession$$anonfun$5() {
        return "Could not close Hibernate Session";
    }

    private final HibernateException closeSession$$anonfun$6(HibernateException ex$2) {
        return ex$2;
    }

    private final String closeSession$$anonfun$7() {
        return "Unexpected exception on closing Hibernate Session";
    }

    private final Throwable closeSession$$anonfun$8(Throwable e$2) {
        return e$2;
    }
}

