/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.inject.spring;

import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.inject.Container;
import org.beangle.commons.lang.Option;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class SpringContainer
implements Container {
    final ApplicationContext context;

    public SpringContainer(ApplicationContext context) {
        this.context = context;
    }

    public Option<Class<?>> getType(Object key) {
        try {
            Class type = this.context.getType(key.toString());
            if (type == null) {
                return Option.none();
            }
            return Option.some((Object)type);
        }
        catch (NoSuchBeanDefinitionException e) {
            return Option.none();
        }
    }

    public boolean contains(Object key) {
        return this.context.containsBean(key.toString());
    }

    public <T> Option<T> getBean(Object key) {
        try {
            return Option.some((Object)this.context.getBean(key.toString()));
        }
        catch (NoSuchBeanDefinitionException e) {
            return Option.none();
        }
    }

    public <T> Option<T> getBean(Class<T> type) {
        try {
            return Option.some((Object)this.context.getBean(type));
        }
        catch (NoSuchBeanDefinitionException e) {
            return Option.none();
        }
    }

    public <T> Option<T> getBean(Object key, Class<T> type) {
        try {
            return Option.some((Object)this.context.getBean(key.toString(), type));
        }
        catch (BeansException e) {
            return Option.none();
        }
    }

    public <T> Map<?, T> getBeans(Class<T> type) {
        return this.context.getBeansOfType(type);
    }

    public Set<?> keys() {
        return CollectUtils.newHashSet((Object[])this.context.getBeanDefinitionNames());
    }

    public ApplicationContext getContext() {
        return this.context;
    }
}

