/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.inject.spring.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.beangle.inject.spring.config.ReconfigBeanDefinitionHolder;
import org.beangle.inject.spring.config.ReconfigType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.BeanMetadataAttributeAccessor;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanNameReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.parsing.BeanEntry;
import org.springframework.beans.factory.parsing.ConstructorArgumentEntry;
import org.springframework.beans.factory.parsing.ParseState;
import org.springframework.beans.factory.parsing.PropertyEntry;
import org.springframework.beans.factory.parsing.QualifierEntry;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.ManagedArray;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.beans.factory.support.MethodOverrides;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class BeanDefinitionParser {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ParseState parseState = new ParseState();
    private final Set<String> usedNames = new HashSet<String>();

    BeanDefinitionParser() {
    }

    protected Object extractSource(Element ele) {
        return null;
    }

    protected void error(String message, Node source) {
        this.logger.error(message);
    }

    protected void error(String message, Element source) {
        this.logger.error(message);
    }

    protected void error(String message, Element source, Throwable cause) {
        this.logger.error(message);
    }

    public ReconfigBeanDefinitionHolder parseBeanDefinitionElement(Element ele) {
        return this.parseBeanDefinitionElement(ele, null);
    }

    public ReconfigBeanDefinitionHolder parseBeanDefinitionElement(Element ele, BeanDefinition containingBean) {
        AbstractBeanDefinition beanDefinition;
        String beanName;
        String id = ele.getAttribute("id");
        String nameAttr = ele.getAttribute("name");
        ArrayList<String> aliases = new ArrayList<String>();
        if (StringUtils.hasLength((String)nameAttr)) {
            String[] nameArr = StringUtils.tokenizeToStringArray((String)nameAttr, (String)",; ");
            aliases.addAll(Arrays.asList(nameArr));
        }
        if (!StringUtils.hasText((String)(beanName = id)) && !aliases.isEmpty()) {
            beanName = (String)aliases.remove(0);
            this.logger.debug("No XML 'id' specified - using '{}' as bean name and {} as aliases", (Object)beanName, aliases);
        }
        if (containingBean == null) {
            this.checkNameUniqueness(beanName, aliases, ele);
        }
        if ((beanDefinition = this.parseBeanDefinitionElement(ele, beanName, containingBean)) != null) {
            String primary;
            String[] aliasesArray = StringUtils.toStringArray(aliases);
            ReconfigBeanDefinitionHolder bdh = new ReconfigBeanDefinitionHolder((BeanDefinition)beanDefinition, beanName, aliasesArray);
            String override = ele.getAttribute("override");
            if (override != null && override.equals("remove")) {
                bdh.setConfigType(ReconfigType.REMOVE);
            }
            if ((primary = ele.getAttribute("primary")) != null && primary.equals("true")) {
                bdh.setConfigType(ReconfigType.PRIMARY);
            }
            return bdh;
        }
        return null;
    }

    protected void checkNameUniqueness(String beanName, List<String> aliases, Element beanElement) {
        String foundName = null;
        if (StringUtils.hasText((String)beanName) && this.usedNames.contains(beanName)) {
            foundName = beanName;
        }
        if (foundName == null) {
            foundName = (String)CollectionUtils.findFirstMatch(this.usedNames, aliases);
        }
        if (foundName != null) {
            this.error("Bean name '" + foundName + "' is already used in this file", beanElement);
        }
        this.usedNames.add(beanName);
        this.usedNames.addAll(aliases);
    }

    public AbstractBeanDefinition parseBeanDefinitionElement(Element ele, String beanName, BeanDefinition containingBean) {
        this.parseState.push((ParseState.Entry)new BeanEntry(beanName));
        String className = null;
        if (ele.hasAttribute("class")) {
            className = ele.getAttribute("class").trim();
        }
        try {
            String parent = null;
            if (ele.hasAttribute("parent")) {
                parent = ele.getAttribute("parent");
            }
            AbstractBeanDefinition bd = this.createBeanDefinition(className, parent);
            this.parseBeanDefinitionAttributes(ele, beanName, containingBean, bd);
            bd.setDescription(DomUtils.getChildElementValueByTagName((Element)ele, (String)"description"));
            this.parseMetaElements(ele, (BeanMetadataAttributeAccessor)bd);
            this.parseLookupOverrideSubElements(ele, bd.getMethodOverrides());
            this.parseReplacedMethodSubElements(ele, bd.getMethodOverrides());
            this.parseConstructorArgElements(ele, (BeanDefinition)bd);
            this.parsePropertyElements(ele, (BeanDefinition)bd);
            this.parseQualifierElements(ele, bd);
            bd.setSource(this.extractSource(ele));
            AbstractBeanDefinition abstractBeanDefinition = bd;
            return abstractBeanDefinition;
        }
        catch (ClassNotFoundException ex) {
            this.error("Bean class [" + className + "] not found", ele, ex);
        }
        catch (NoClassDefFoundError err) {
            this.error("Class that bean class [" + className + "] depends on not found", ele, err);
        }
        catch (Throwable ex) {
            this.error("Unexpected failure during bean definition parsing", ele, ex);
        }
        finally {
            this.parseState.pop();
        }
        return null;
    }

    public AbstractBeanDefinition parseBeanDefinitionAttributes(Element ele, String beanName, BeanDefinition containingBean, AbstractBeanDefinition bd) {
        String destroyMethodName;
        String initMethodName;
        if (ele.hasAttribute("scope")) {
            bd.setScope(ele.getAttribute("scope"));
            if (ele.hasAttribute("singleton")) {
                this.error("Specify either 'scope' or 'singleton', not both", ele);
            }
        } else if (ele.hasAttribute("singleton")) {
            bd.setScope("true".equals(ele.getAttribute("singleton")) ? "singleton" : "prototype");
        } else if (containingBean != null) {
            bd.setScope(containingBean.getScope());
        }
        if (ele.hasAttribute("abstract")) {
            bd.setAbstract("true".equals(ele.getAttribute("abstract")));
        }
        String lazyInit = ele.getAttribute("lazy-init");
        bd.setLazyInit("true".equals(lazyInit));
        String autowire = ele.getAttribute("autowire");
        bd.setAutowireMode(this.getAutowireMode(autowire));
        if (ele.hasAttribute("depends-on")) {
            String dependsOn = ele.getAttribute("depends-on");
            bd.setDependsOn(StringUtils.tokenizeToStringArray((String)dependsOn, (String)",; "));
        }
        if (ele.hasAttribute("primary")) {
            bd.setPrimary("true".equals(ele.getAttribute("primary")));
        }
        if (ele.hasAttribute("init-method") && !"".equals(initMethodName = ele.getAttribute("init-method"))) {
            bd.setInitMethodName(initMethodName);
        }
        if (ele.hasAttribute("destroy-method") && !"".equals(destroyMethodName = ele.getAttribute("destroy-method"))) {
            bd.setDestroyMethodName(destroyMethodName);
        }
        if (ele.hasAttribute("factory-method")) {
            bd.setFactoryMethodName(ele.getAttribute("factory-method"));
        }
        if (ele.hasAttribute("factory-bean")) {
            bd.setFactoryBeanName(ele.getAttribute("factory-bean"));
        }
        return bd;
    }

    protected AbstractBeanDefinition createBeanDefinition(String className, String parentName) throws ClassNotFoundException {
        return BeanDefinitionReaderUtils.createBeanDefinition((String)parentName, (String)className, null);
    }

    public void parseMetaElements(Element ele, BeanMetadataAttributeAccessor attributeAccessor) {
        NodeList nl = ele.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element && this.nodeNameEquals(node, "meta")) {
                Element metaElement = (Element)node;
                String key = metaElement.getAttribute("key");
                String value = metaElement.getAttribute("value");
                BeanMetadataAttribute attribute = new BeanMetadataAttribute(key, (Object)value);
                attribute.setSource(this.extractSource(metaElement));
                attributeAccessor.addMetadataAttribute(attribute);
            }
            ++i;
        }
    }

    public int getAutowireMode(String attValue) {
        String att = attValue;
        int autowire = 0;
        if ("byName".equals(att)) {
            autowire = 1;
        } else if ("byType".equals(att)) {
            autowire = 2;
        } else if ("constructor".equals(att)) {
            autowire = 3;
        }
        return autowire;
    }

    public void parseConstructorArgElements(Element beanEle, BeanDefinition bd) {
        NodeList nl = beanEle.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element && this.nodeNameEquals(node, "constructor-arg")) {
                this.parseConstructorArgElement((Element)node, bd);
            }
            ++i;
        }
    }

    public void parsePropertyElements(Element beanEle, BeanDefinition bd) {
        NodeList nl = beanEle.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element && this.nodeNameEquals(node, "property")) {
                this.parsePropertyElement((Element)node, bd);
            }
            ++i;
        }
    }

    public void parseQualifierElements(Element beanEle, AbstractBeanDefinition bd) {
        NodeList nl = beanEle.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element && this.nodeNameEquals(node, "qualifier")) {
                this.parseQualifierElement((Element)node, bd);
            }
            ++i;
        }
    }

    public void parseLookupOverrideSubElements(Element beanEle, MethodOverrides overrides) {
        NodeList nl = beanEle.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element && this.nodeNameEquals(node, "lookup-method")) {
                Element ele = (Element)node;
                String methodName = ele.getAttribute("name");
                String beanRef = ele.getAttribute("bean");
                LookupOverride override = new LookupOverride(methodName, beanRef);
                override.setSource(this.extractSource(ele));
                overrides.addOverride((MethodOverride)override);
            }
            ++i;
        }
    }

    public void parseReplacedMethodSubElements(Element beanEle, MethodOverrides overrides) {
        NodeList nl = beanEle.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element && this.nodeNameEquals(node, "replaced-method")) {
                Element replacedMethodEle = (Element)node;
                String name = replacedMethodEle.getAttribute("name");
                String callback = replacedMethodEle.getAttribute("replacer");
                ReplaceOverride replaceOverride = new ReplaceOverride(name, callback);
                List argTypeEles = DomUtils.getChildElementsByTagName((Element)replacedMethodEle, (String)"arg-type");
                for (Element argTypeEle : argTypeEles) {
                    replaceOverride.addTypeIdentifier(argTypeEle.getAttribute("match"));
                }
                replaceOverride.setSource(this.extractSource(replacedMethodEle));
                overrides.addOverride((MethodOverride)replaceOverride);
            }
            ++i;
        }
    }

    public void parseConstructorArgElement(Element ele, BeanDefinition bd) {
        block17: {
            String indexAttr = ele.getAttribute("index");
            String typeAttr = ele.getAttribute("type");
            String nameAttr = ele.getAttribute("name");
            if (StringUtils.hasLength((String)indexAttr)) {
                try {
                    int index = Integer.parseInt(indexAttr);
                    if (index < 0) {
                        this.error("'index' cannot be lower than 0", ele);
                        break block17;
                    }
                    try {
                        this.parseState.push((ParseState.Entry)new ConstructorArgumentEntry(index));
                        Object value = this.parsePropertyValue(ele, bd, null);
                        ConstructorArgumentValues.ValueHolder valueHolder = new ConstructorArgumentValues.ValueHolder(value);
                        if (StringUtils.hasLength((String)typeAttr)) {
                            valueHolder.setType(typeAttr);
                        }
                        if (StringUtils.hasLength((String)nameAttr)) {
                            valueHolder.setName(nameAttr);
                        }
                        valueHolder.setSource(this.extractSource(ele));
                        if (bd.getConstructorArgumentValues().hasIndexedArgumentValue(index)) {
                            this.error("Ambiguous constructor-arg entries for index " + index, ele);
                        } else {
                            bd.getConstructorArgumentValues().addIndexedArgumentValue(index, valueHolder);
                        }
                    }
                    finally {
                        this.parseState.pop();
                    }
                }
                catch (NumberFormatException ex) {
                    this.error("Attribute 'index' of tag 'constructor-arg' must be an integer", ele);
                }
            } else {
                try {
                    this.parseState.push((ParseState.Entry)new ConstructorArgumentEntry());
                    Object value = this.parsePropertyValue(ele, bd, null);
                    ConstructorArgumentValues.ValueHolder valueHolder = new ConstructorArgumentValues.ValueHolder(value);
                    if (StringUtils.hasLength((String)typeAttr)) {
                        valueHolder.setType(typeAttr);
                    }
                    if (StringUtils.hasLength((String)nameAttr)) {
                        valueHolder.setName(nameAttr);
                    }
                    valueHolder.setSource(this.extractSource(ele));
                    bd.getConstructorArgumentValues().addGenericArgumentValue(valueHolder);
                }
                finally {
                    this.parseState.pop();
                }
            }
        }
    }

    public void parsePropertyElement(Element ele, BeanDefinition bd) {
        String propertyName = ele.getAttribute("name");
        if (!StringUtils.hasLength((String)propertyName)) {
            this.error("Tag 'property' must have a 'name' attribute", ele);
            return;
        }
        this.parseState.push((ParseState.Entry)new PropertyEntry(propertyName));
        try {
            if (bd.getPropertyValues().contains(propertyName)) {
                this.error("Multiple 'property' definitions for property '" + propertyName + "'", ele);
                return;
            }
            Object val = this.parsePropertyValue(ele, bd, propertyName);
            PropertyValue pv = new PropertyValue(propertyName, val);
            this.parseMetaElements(ele, (BeanMetadataAttributeAccessor)pv);
            pv.setSource(this.extractSource(ele));
            bd.getPropertyValues().addPropertyValue(pv);
        }
        finally {
            this.parseState.pop();
        }
    }

    public void parseQualifierElement(Element ele, AbstractBeanDefinition bd) {
        String typeName = ele.getAttribute("type");
        if (!StringUtils.hasLength((String)typeName)) {
            this.error("Tag 'qualifier' must have a 'type' attribute", ele);
            return;
        }
        this.parseState.push((ParseState.Entry)new QualifierEntry(typeName));
        try {
            AutowireCandidateQualifier qualifier = new AutowireCandidateQualifier(typeName);
            qualifier.setSource(this.extractSource(ele));
            String value = ele.getAttribute("value");
            if (StringUtils.hasLength((String)value)) {
                qualifier.setAttribute(AutowireCandidateQualifier.VALUE_KEY, (Object)value);
            }
            NodeList nl = ele.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                if (node instanceof Element && this.nodeNameEquals(node, "attribute")) {
                    Element attributeEle = (Element)node;
                    String attributeName = attributeEle.getAttribute("key");
                    String attributeValue = attributeEle.getAttribute("value");
                    if (StringUtils.hasLength((String)attributeName) && StringUtils.hasLength((String)attributeValue)) {
                        BeanMetadataAttribute attribute = new BeanMetadataAttribute(attributeName, (Object)attributeValue);
                        attribute.setSource(this.extractSource(attributeEle));
                        qualifier.addMetadataAttribute(attribute);
                    } else {
                        this.error("Qualifier 'attribute' tag must have a 'name' and 'value'", attributeEle);
                        return;
                    }
                }
                ++i;
            }
            bd.addQualifier(qualifier);
        }
        finally {
            this.parseState.pop();
        }
    }

    public Object parsePropertyValue(Element ele, BeanDefinition bd, String propertyName) {
        String elementName = propertyName != null ? "<property> element for property '" + propertyName + "'" : "<constructor-arg> element";
        NodeList nl = ele.getChildNodes();
        Element subElement = null;
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element && !this.nodeNameEquals(node, "description") && !this.nodeNameEquals(node, "meta")) {
                if (subElement != null) {
                    this.error(String.valueOf(elementName) + " must not contain more than one sub-element", ele);
                } else {
                    subElement = (Element)node;
                }
            }
            ++i;
        }
        boolean hasRefAttribute = ele.hasAttribute("ref");
        boolean hasValueAttribute = ele.hasAttribute("value");
        if (hasRefAttribute && hasValueAttribute || (hasRefAttribute || hasValueAttribute) && subElement != null) {
            this.error(String.valueOf(elementName) + " is only allowed to contain either 'ref' attribute OR 'value' attribute OR sub-element", ele);
        }
        if (hasRefAttribute) {
            String refName = ele.getAttribute("ref");
            if (!StringUtils.hasText((String)refName)) {
                this.error(String.valueOf(elementName) + " contains empty 'ref' attribute", ele);
            }
            RuntimeBeanReference ref = new RuntimeBeanReference(refName);
            ref.setSource(this.extractSource(ele));
            return ref;
        }
        if (hasValueAttribute) {
            TypedStringValue valueHolder = new TypedStringValue(ele.getAttribute("value"));
            valueHolder.setSource(this.extractSource(ele));
            return valueHolder;
        }
        if (subElement != null) {
            return this.parsePropertySubElement(subElement, bd);
        }
        this.error(String.valueOf(elementName) + " must specify a ref or value", ele);
        return null;
    }

    public Object parsePropertySubElement(Element ele, BeanDefinition bd) {
        return this.parsePropertySubElement(ele, bd, null);
    }

    public Object parsePropertySubElement(Element ele, BeanDefinition bd, String defaultValueType) {
        if (!this.isDefaultNamespace(this.getNamespaceURI(ele))) {
            this.error("Cannot support nested element .", ele);
            return null;
        }
        if (this.nodeNameEquals(ele, "bean")) {
            ReconfigBeanDefinitionHolder nestedBd = this.parseBeanDefinitionElement(ele, bd);
            if (nestedBd != null) {
                nestedBd = this.decorateBeanDefinitionIfRequired(ele, nestedBd, bd);
            }
            return nestedBd;
        }
        if (this.nodeNameEquals(ele, "ref")) {
            String refName = ele.getAttribute("bean");
            boolean toParent = false;
            if (!StringUtils.hasLength((String)refName) && !StringUtils.hasLength((String)(refName = ele.getAttribute("local")))) {
                refName = ele.getAttribute("parent");
                toParent = true;
                if (!StringUtils.hasLength((String)refName)) {
                    this.error("'bean', 'local' or 'parent' is required for <ref> element", ele);
                    return null;
                }
            }
            if (!StringUtils.hasText((String)refName)) {
                this.error("<ref> element contains empty target attribute", ele);
                return null;
            }
            RuntimeBeanReference ref = new RuntimeBeanReference(refName, toParent);
            ref.setSource(this.extractSource(ele));
            return ref;
        }
        if (this.nodeNameEquals(ele, "idref")) {
            return this.parseIdRefElement(ele);
        }
        if (this.nodeNameEquals(ele, "value")) {
            return this.parseValueElement(ele, defaultValueType);
        }
        if (this.nodeNameEquals(ele, "null")) {
            TypedStringValue nullHolder = new TypedStringValue(null);
            nullHolder.setSource(this.extractSource(ele));
            return nullHolder;
        }
        if (this.nodeNameEquals(ele, "array")) {
            return this.parseArrayElement(ele, bd);
        }
        if (this.nodeNameEquals(ele, "list")) {
            return this.parseListElement(ele, bd);
        }
        if (this.nodeNameEquals(ele, "set")) {
            return this.parseSetElement(ele, bd);
        }
        if (this.nodeNameEquals(ele, "map")) {
            return this.parseMapElement(ele, bd);
        }
        if (this.nodeNameEquals(ele, "props")) {
            return this.parsePropsElement(ele);
        }
        this.error("Unknown property sub-element: [" + ele.getNodeName() + "]", ele);
        return null;
    }

    public Object parseIdRefElement(Element ele) {
        String refName = ele.getAttribute("bean");
        if (!StringUtils.hasLength((String)refName) && !StringUtils.hasLength((String)(refName = ele.getAttribute("local")))) {
            this.error("Either 'bean' or 'local' is required for <idref> element", ele);
            return null;
        }
        if (!StringUtils.hasText((String)refName)) {
            this.error("<idref> element contains empty target attribute", ele);
            return null;
        }
        RuntimeBeanNameReference ref = new RuntimeBeanNameReference(refName);
        ref.setSource(this.extractSource(ele));
        return ref;
    }

    public Object parseValueElement(Element ele, String defaultTypeName) {
        String value = DomUtils.getTextValue((Element)ele);
        String specifiedTypeName = ele.getAttribute("type");
        String typeName = specifiedTypeName;
        if (!StringUtils.hasText((String)typeName)) {
            typeName = defaultTypeName;
        }
        try {
            TypedStringValue typedValue = this.buildTypedStringValue(value, typeName);
            typedValue.setSource(this.extractSource(ele));
            typedValue.setSpecifiedTypeName(specifiedTypeName);
            return typedValue;
        }
        catch (ClassNotFoundException ex) {
            this.error("Type class [" + typeName + "] not found for <value> element", ele, ex);
            return value;
        }
    }

    protected TypedStringValue buildTypedStringValue(String value, String targetTypeName) throws ClassNotFoundException {
        TypedStringValue typedValue = !StringUtils.hasText((String)targetTypeName) ? new TypedStringValue(value) : new TypedStringValue(value, targetTypeName);
        return typedValue;
    }

    public Object parseArrayElement(Element arrayEle, BeanDefinition bd) {
        String elementType = arrayEle.getAttribute("value-type");
        NodeList nl = arrayEle.getChildNodes();
        ManagedArray target = new ManagedArray(elementType, nl.getLength());
        target.setSource(this.extractSource(arrayEle));
        target.setElementTypeName(elementType);
        target.setMergeEnabled(this.parseMergeAttribute(arrayEle));
        this.parseCollectionElements(nl, (Collection<Object>)target, bd, elementType);
        return target;
    }

    public List<Object> parseListElement(Element collectionEle, BeanDefinition bd) {
        String defaultElementType = collectionEle.getAttribute("value-type");
        NodeList nl = collectionEle.getChildNodes();
        ManagedList target = new ManagedList(nl.getLength());
        target.setSource(this.extractSource(collectionEle));
        target.setElementTypeName(defaultElementType);
        target.setMergeEnabled(this.parseMergeAttribute(collectionEle));
        this.parseCollectionElements(nl, (Collection<Object>)target, bd, defaultElementType);
        return target;
    }

    public Set<Object> parseSetElement(Element collectionEle, BeanDefinition bd) {
        String defaultElementType = collectionEle.getAttribute("value-type");
        NodeList nl = collectionEle.getChildNodes();
        ManagedSet target = new ManagedSet(nl.getLength());
        target.setSource(this.extractSource(collectionEle));
        target.setElementTypeName(defaultElementType);
        target.setMergeEnabled(this.parseMergeAttribute(collectionEle));
        this.parseCollectionElements(nl, (Collection<Object>)target, bd, defaultElementType);
        return target;
    }

    protected void parseCollectionElements(NodeList elementNodes, Collection<Object> target, BeanDefinition bd, String defaultElementType) {
        int i = 0;
        while (i < elementNodes.getLength()) {
            Node node = elementNodes.item(i);
            if (node instanceof Element && !this.nodeNameEquals(node, "description")) {
                target.add(this.parsePropertySubElement((Element)node, bd, defaultElementType));
            }
            ++i;
        }
    }

    public Map<Object, Object> parseMapElement(Element mapEle, BeanDefinition bd) {
        String defaultKeyType = mapEle.getAttribute("key-type");
        String defaultValueType = mapEle.getAttribute("value-type");
        List entryEles = DomUtils.getChildElementsByTagName((Element)mapEle, (String)"entry");
        ManagedMap map = new ManagedMap(entryEles.size());
        map.setSource(this.extractSource(mapEle));
        map.setKeyTypeName(defaultKeyType);
        map.setValueTypeName(defaultValueType);
        map.setMergeEnabled(this.parseMergeAttribute(mapEle));
        for (Element entryEle : entryEles) {
            NodeList entrySubNodes = entryEle.getChildNodes();
            Element keyEle = null;
            Element valueEle = null;
            int j = 0;
            while (j < entrySubNodes.getLength()) {
                Node node = entrySubNodes.item(j);
                if (node instanceof Element) {
                    Element candidateEle = (Element)node;
                    if (this.nodeNameEquals(candidateEle, "key")) {
                        if (keyEle != null) {
                            this.error("<entry> element is only allowed to contain one <key> sub-element", entryEle);
                        } else {
                            keyEle = candidateEle;
                        }
                    } else if (valueEle != null) {
                        this.error("<entry> element must not contain more than one value sub-element", entryEle);
                    } else {
                        valueEle = candidateEle;
                    }
                }
                ++j;
            }
            Object key = null;
            boolean hasKeyAttribute = entryEle.hasAttribute("key");
            boolean hasKeyRefAttribute = entryEle.hasAttribute("key-ref");
            if (hasKeyAttribute && hasKeyRefAttribute || (hasKeyAttribute || hasKeyRefAttribute) && keyEle != null) {
                this.error("<entry> element is only allowed to contain either a 'key' attribute OR a 'key-ref' attribute OR a <key> sub-element", entryEle);
            }
            if (hasKeyAttribute) {
                key = this.buildTypedStringValueForMap(entryEle.getAttribute("key"), defaultKeyType, entryEle);
            } else if (hasKeyRefAttribute) {
                String refName = entryEle.getAttribute("key-ref");
                if (!StringUtils.hasText((String)refName)) {
                    this.error("<entry> element contains empty 'key-ref' attribute", entryEle);
                }
                RuntimeBeanReference ref = new RuntimeBeanReference(refName);
                ref.setSource(this.extractSource(entryEle));
                key = ref;
            } else if (keyEle != null) {
                key = this.parseKeyElement(keyEle, bd, defaultKeyType);
            } else {
                this.error("<entry> element must specify a key", entryEle);
            }
            Object value = null;
            boolean hasValueAttribute = entryEle.hasAttribute("value");
            boolean hasValueRefAttribute = entryEle.hasAttribute("value-ref");
            if (hasValueAttribute && hasValueRefAttribute || (hasValueAttribute || hasValueRefAttribute) && valueEle != null) {
                this.error("<entry> element is only allowed to contain either 'value' attribute OR 'value-ref' attribute OR <value> sub-element", entryEle);
            }
            if (hasValueAttribute) {
                value = this.buildTypedStringValueForMap(entryEle.getAttribute("value"), defaultValueType, entryEle);
            } else if (hasValueRefAttribute) {
                String refName = entryEle.getAttribute("value-ref");
                if (!StringUtils.hasText((String)refName)) {
                    this.error("<entry> element contains empty 'value-ref' attribute", entryEle);
                }
                RuntimeBeanReference ref = new RuntimeBeanReference(refName);
                ref.setSource(this.extractSource(entryEle));
                value = ref;
            } else if (valueEle != null) {
                value = this.parsePropertySubElement(valueEle, bd, defaultValueType);
            } else {
                this.error("<entry> element must specify a value", entryEle);
            }
            map.put(key, value);
        }
        return map;
    }

    protected final Object buildTypedStringValueForMap(String value, String defaultTypeName, Element entryEle) {
        try {
            TypedStringValue typedValue = this.buildTypedStringValue(value, defaultTypeName);
            typedValue.setSource(this.extractSource(entryEle));
            return typedValue;
        }
        catch (ClassNotFoundException ex) {
            this.error("Type class [" + defaultTypeName + "] not found for Map key/value type", entryEle, ex);
            return value;
        }
    }

    protected Object parseKeyElement(Element keyEle, BeanDefinition bd, String defaultKeyTypeName) {
        NodeList nl = keyEle.getChildNodes();
        Element subElement = null;
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element) {
                if (subElement != null) {
                    this.error("<key> element must not contain more than one value sub-element", keyEle);
                } else {
                    subElement = (Element)node;
                }
            }
            ++i;
        }
        return this.parsePropertySubElement(subElement, bd, defaultKeyTypeName);
    }

    public Properties parsePropsElement(Element propsEle) {
        ManagedProperties props = new ManagedProperties();
        props.setSource(this.extractSource(propsEle));
        props.setMergeEnabled(this.parseMergeAttribute(propsEle));
        List propEles = DomUtils.getChildElementsByTagName((Element)propsEle, (String)"prop");
        for (Element propEle : propEles) {
            String key = propEle.getAttribute("key");
            String value = DomUtils.getTextValue((Element)propEle).trim();
            TypedStringValue keyHolder = new TypedStringValue(key);
            keyHolder.setSource(this.extractSource(propEle));
            TypedStringValue valueHolder = new TypedStringValue(value);
            valueHolder.setSource(this.extractSource(propEle));
            props.put((Object)keyHolder, (Object)valueHolder);
        }
        return props;
    }

    public boolean parseMergeAttribute(Element collectionElement) {
        String value = collectionElement.getAttribute("merge");
        return "true".equals(value);
    }

    public BeanDefinitionHolder decorateBeanDefinitionIfRequired(Element ele, BeanDefinitionHolder definitionHolder) {
        return this.decorateBeanDefinitionIfRequired(ele, definitionHolder, null);
    }

    public BeanDefinitionHolder decorateBeanDefinitionIfRequired(Element ele, BeanDefinitionHolder definitionHolder, BeanDefinition containingBd) {
        BeanDefinitionHolder finalDefinition = definitionHolder;
        NamedNodeMap attributes = ele.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node node = attributes.item(i);
            finalDefinition = this.decorateIfRequired(node, finalDefinition, containingBd);
            ++i;
        }
        NodeList children = ele.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node node = children.item(i2);
            if (node.getNodeType() == 1) {
                finalDefinition = this.decorateIfRequired(node, finalDefinition, containingBd);
            }
            ++i2;
        }
        return finalDefinition;
    }

    private BeanDefinitionHolder decorateIfRequired(Node node, BeanDefinitionHolder originalDef, BeanDefinition containingBd) {
        return originalDef;
    }

    public boolean isDefaultNamespace(String namespaceUri) {
        return !StringUtils.hasLength((String)namespaceUri) || "http://www.springframework.org/schema/beans".equals(namespaceUri);
    }

    private String getNamespaceURI(Node node) {
        return node.getNamespaceURI();
    }

    private boolean nodeNameEquals(Node node, String desiredName) {
        return desiredName.equals(node.getNodeName()) || desiredName.equals(this.getLocalName(node));
    }

    public String getLocalName(Node node) {
        return node.getLocalName();
    }
}

