/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.inject.spring.config;

import org.beangle.inject.spring.config.ReconfigType;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.util.StringUtils;

public class ReconfigBeanDefinitionHolder
extends BeanDefinitionHolder {
    private ReconfigType configType = ReconfigType.UPDATE;

    public ReconfigBeanDefinitionHolder(BeanDefinition beanDefinition, String beanName, String[] aliases) {
        super(beanDefinition, beanName, aliases);
    }

    public ReconfigBeanDefinitionHolder(BeanDefinition beanDefinition, String beanName) {
        super(beanDefinition, beanName);
    }

    public ReconfigBeanDefinitionHolder(BeanDefinitionHolder beanDefinitionHolder) {
        super(beanDefinitionHolder);
    }

    public ReconfigType getConfigType() {
        return this.configType;
    }

    public void setConfigType(ReconfigType configType) {
        this.configType = configType;
    }

    public String toString() {
        BeanDefinition bd;
        StringBuilder sb = new StringBuilder();
        if (this.configType.equals((Object)ReconfigType.UPDATE)) {
            sb.append("UPDATE:");
        } else {
            sb.append("REMOVE:");
        }
        sb.append(this.getBeanName()).append("'");
        if (this.getAliases() != null && this.getAliases().length > 0) {
            sb.append(" aliases[").append(StringUtils.arrayToCommaDelimitedString((Object[])this.getAliases())).append("]");
        }
        if ((bd = this.getBeanDefinition()).getBeanClassName() != null) {
            sb.append(" [").append(bd.getBeanClassName()).append("]");
        }
        if (bd.getScope() != null && !bd.getScope().equals("")) {
            sb.append("; scope=").append(bd.getScope());
        }
        if (bd.isAbstract()) {
            sb.append("; abstract=true");
        }
        if (bd.isLazyInit()) {
            sb.append("; lazyInit=true");
        }
        if (bd instanceof GenericBeanDefinition) {
            GenericBeanDefinition gbd = (GenericBeanDefinition)bd;
            if (gbd.getAutowireMode() > 0) {
                sb.append("; autowireMode=").append(gbd.getAutowireMode());
            }
            if (gbd.getFactoryBeanName() != null) {
                sb.append("; factoryBeanName=").append(gbd.getFactoryBeanName());
            }
            if (gbd.getFactoryMethodName() != null) {
                sb.append("; factoryMethodName=").append(gbd.getFactoryMethodName());
            }
            if (gbd.getInitMethodName() != null) {
                sb.append("; initMethodName=").append(gbd.getInitMethodName());
            }
            if (gbd.getDestroyMethodName() != null) {
                sb.append("; destroyMethodName=").append(gbd.getDestroyMethodName());
            }
        }
        return sb.toString();
    }
}

