/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.inject.spring.config;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.inject.Resources;
import org.beangle.commons.lang.Strings;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ResourcesEditor
extends PropertyEditorSupport {
    private final ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    private URL getResource(String location) {
        if (Strings.isBlank((CharSequence)location)) {
            return null;
        }
        Resource res = this.resourceLoader.getResource(location);
        try {
            return res.exists() ? res.getURL() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private List<URL> getResources(String locationPattern) {
        List locals = CollectUtils.newArrayList();
        try {
            Resource[] reses;
            Resource[] resourceArray = reses = this.resourcePatternResolver.getResources(locationPattern);
            int n = reses.length;
            int n2 = 0;
            while (n2 < n) {
                Resource res = resourceArray[n2];
                if (res.exists()) {
                    locals.add(res.getURL());
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return locals;
    }

    @Override
    public void setAsText(String text) {
        if (Strings.isNotBlank((CharSequence)text)) {
            Resources resources = new Resources();
            String[] paths = text.split(";");
            if (paths.length > 0) {
                resources.setGlobal(this.getResource(paths[0]));
            }
            if (paths.length > 1) {
                resources.setLocals(this.getResources(paths[1]));
            }
            if (paths.length > 2) {
                resources.setUser(this.getResource(paths[2]));
            }
            this.setValue(resources);
        } else {
            this.setValue(null);
        }
    }
}

