/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.inject.spring.web;

import javax.servlet.ServletContext;
import org.beangle.commons.inject.Container;
import org.beangle.commons.inject.ContainerHook;
import org.beangle.commons.inject.Containers;
import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.reflect.Reflections;
import org.beangle.inject.spring.SpringContainer;
import org.beangle.inject.spring.web.XmlWebApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;
import org.springframework.util.ClassUtils;

public class ContextLoader {
    private static final Logger logger = LoggerFactory.getLogger(ContextLoader.class);
    public static final String ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE = "org.springframework.web.context.WebApplicationContext.ROOT";
    public static final String APPLICATION_CONTEXT_ID_PREFIX = "WebApplicationContext:";
    public static final String CONTEXT_CLASS_PARAM = "contextClass";
    public static final String CONFIG_LOCATION_PARAM = "contextConfigLocation";

    protected ConfigurableApplicationContext createApplicationContext(ServletContext sc) {
        Class<?> contextClass = this.determineContextClass(sc);
        if (!ConfigurableApplicationContext.class.isAssignableFrom(contextClass)) {
            throw new ApplicationContextException("Custom context class [" + contextClass.getName() + "] is not of type [" + ConfigurableApplicationContext.class.getName() + "]");
        }
        ConfigurableApplicationContext wac = (ConfigurableApplicationContext)Reflections.newInstance(contextClass);
        if (wac instanceof XmlWebApplicationContext) {
            ((XmlWebApplicationContext)wac).setAllowBeanDefinitionOverriding(false);
        }
        return wac;
    }

    public ApplicationContext initApplicationContext(ServletContext servletContext) {
        if (ContextLoader.getContext(servletContext) != null) {
            throw new IllegalStateException("Cannot initialize context because there is already a root application context present - check whether you have multiple ContextListener* definitions in your web.xml!");
        }
        logger.info("Root ApplicationContext: initialization started");
        long startTime = System.currentTimeMillis();
        try {
            ConfigurableApplicationContext context = this.createApplicationContext(servletContext);
            this.configureAndRefreshApplicationContext(context, servletContext);
            servletContext.setAttribute(ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)context);
            SpringContainer container = new SpringContainer((ApplicationContext)context);
            Containers.setRoot((Container)container);
            for (ContainerHook hook : Containers.getHooks()) {
                hook.notify((Container)container);
            }
            logger.info("Root ApplicationContext: initialization completed in {} ms", (Object)(System.currentTimeMillis() - startTime));
            return context;
        }
        catch (RuntimeException ex) {
            logger.error("Context initialization failed", (Throwable)ex);
            throw ex;
        }
        catch (Error err) {
            logger.error("Context initialization failed", (Throwable)err);
            throw err;
        }
    }

    protected void configureAndRefreshApplicationContext(ConfigurableApplicationContext wac, ServletContext sc) {
        wac.setId(APPLICATION_CONTEXT_ID_PREFIX + Objects.toString((Object)sc.getServletContextName()));
        String initParameter = sc.getInitParameter(CONFIG_LOCATION_PARAM);
        if (initParameter == null) {
            initParameter = "classpath:spring-context.xml";
        }
        if (wac instanceof AbstractRefreshableConfigApplicationContext) {
            ((AbstractRefreshableConfigApplicationContext)wac).setConfigLocation(initParameter);
        }
        this.customizeContext(sc, wac);
        wac.refresh();
    }

    protected void customizeContext(ServletContext servletContext, ConfigurableApplicationContext applicationContext) {
    }

    protected Class<?> determineContextClass(ServletContext servletContext) {
        String contextClassName = servletContext.getInitParameter(CONTEXT_CLASS_PARAM);
        if (contextClassName != null) {
            try {
                return ClassUtils.forName((String)contextClassName, (ClassLoader)ClassUtils.getDefaultClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new ApplicationContextException("Failed to load custom context class [" + contextClassName + "]", (Throwable)ex);
            }
        }
        return XmlWebApplicationContext.class;
    }

    public void closeApplicationContext(ServletContext servletContext) {
        logger.info("Closing Spring root ApplicationContext");
        ConfigurableApplicationContext context = ContextLoader.getContext(servletContext);
        if (context != null) {
            context.close();
        }
        servletContext.removeAttribute(ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    public static ConfigurableApplicationContext getContext(ServletContext servletContext) {
        Object context = servletContext.getAttribute(ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (context == null) {
            context = servletContext.getAttribute(ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        if (!(context instanceof Exception)) {
            return (ConfigurableApplicationContext)context;
        }
        return null;
    }
}

