/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.auth;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Objects;
import org.beangle.security.core.Authentication;
import org.beangle.security.core.GrantedAuthority;
import org.beangle.security.core.userdetail.UserDetail;

public abstract class AbstractAuthentication
implements Authentication {
    private static final long serialVersionUID = 3966615358056184985L;
    private Object details;
    private final Collection<GrantedAuthority> authorities;
    private boolean authenticated = false;

    public AbstractAuthentication(Collection<? extends GrantedAuthority> authorities) {
        if (authorities == null) {
            this.authorities = Collections.emptyList();
        } else {
            Assert.noNullElements(authorities, (String)"authorities cannot contain any null element", (Object[])new Object[0]);
            this.authorities = Collections.unmodifiableCollection(CollectUtils.newArrayList(authorities));
        }
    }

    @Override
    public Object getDetails() {
        return this.details;
    }

    public void setDetails(Object details) {
        this.details = details;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AbstractAuthentication) {
            AbstractAuthentication test = (AbstractAuthentication)obj;
            return Objects.equalsBuilder().add(this.getPrincipal(), test.getPrincipal()).add(this.getCredentials(), test.getCredentials()).add(this.getDetails(), test.getDetails()).add(this.isAuthenticated(), test.isAuthenticated()).add(this.getAuthorities(), test.getAuthorities()).isEquals();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return null == this.getPrincipal() ? 629 : this.getPrincipal().hashCode();
    }

    @Override
    public String getName() {
        if (this.getPrincipal() instanceof UserDetail) {
            return ((UserDetail)this.getPrincipal()).getUsername();
        }
        if (this.getPrincipal() instanceof Principal) {
            return ((Principal)this.getPrincipal()).getName();
        }
        return this.getPrincipal() == null ? "" : this.getPrincipal().toString();
    }
}

